package dev.felnull.imp.client.renderer.item;

import dev.architectury.platform.Platform;
import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.client.model.IMPModels;
import dev.felnull.imp.integration.PatchouliIntegration;
import dev.felnull.imp.item.ManualItem;
import dev.felnull.otyacraftengine.client.renderer.item.BEWLItemRenderer;
import dev.felnull.otyacraftengine.client.util.OEModelUtil;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import dev.felnull.otyacraftengine.integration.PatchouliWrapper;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_809;
import var;

public class ManualItemRenderer implements BEWLItemRenderer {
    private static final class_310 mc = class_310.method_1551();
    private static final class_2561 FELNULL_DEV_TEXT = new class_2585("FelNull DEV");
    private static final class_2561 MANUAL_TEXT = new class_2588("imp.text.manual");
    private static final class_2561 COVER_INFO_TEXT = new class_2588("imp.text.manual.coverInfo");
    private final class_2561 MOD_NAME_TEXT;
    private final class_2561 MOD_VERSION_TEXT;
    private int openProgress;
    private int openProgressO;

    public ManualItemRenderer() {
        var mod = Platform.getMod(IamMusicPlayer.MODID);
        this.MOD_NAME_TEXT = new class_2585(mod.getName());
        this.MOD_VERSION_TEXT = new class_2585("v" + mod.getVersion());
    }

    @Override
    public void render(class_1799 stack, class_809.class_811 transformType, class_4587 poseStack, class_4597 multiBufferSource, float f, int light, int overlay) {
        var model = OEModelUtil.getModel(IMPModels.MANUAL);
        var vc = multiBufferSource.getBuffer(class_4722.method_24074());
        float par = class_3532.method_16439(f, openProgressO, openProgress) / 10f;
        poseStack.method_22903();
        if (transformType == class_809.class_811.field_4322) {
            OERenderUtil.poseTrans16(poseStack, 11, 0, 0);
            OERenderUtil.poseRotateZ(poseStack, -25 * par);
            OERenderUtil.poseTrans16(poseStack, -11, 0, 0);
        }

        OERenderUtil.renderModel(poseStack, vc, model, light, overlay);

        if (transformType == class_809.class_811.field_4322 || transformType == class_809.class_811.field_4321) {
            OERenderUtil.poseTrans16(poseStack, 0, 0.125 * par, 0);
            OERenderUtil.poseTrans16(poseStack, 10, 0.125, 0);
            OERenderUtil.poseRotateZ(poseStack, -135 * par);
            OERenderUtil.poseTrans16(poseStack, -10, -0.125, 0);
        }

        OERenderUtil.poseTrans16(poseStack, 0, 0.125, 0);
        renderTurning(poseStack, multiBufferSource, vc, light, overlay);
        poseStack.method_22909();
    }

    public void tick() {
        if (mc.field_1687 == null || mc.field_1724 == null) {
            openProgress = 0;
            openProgressO = 0;
            return;
        }
        if (mc.method_1493()) return;
        openProgressO = openProgress;
        if (PatchouliIntegration.isEnableIntegration() && ManualItem.MANUAL_BOOK.equals(PatchouliWrapper.getOpenBookGui())) {
            openProgress = Math.min(openProgress + 1, 10);
        } else {
            openProgress = Math.max(openProgress - 1, 0);
        }
    }

    private void renderTurning(class_4587 poseStack, class_4597 multiBufferSource, class_4588 vc, int light, int overlay) {
        var model = OEModelUtil.getModel(IMPModels.MANUAL_TURNING);
        poseStack.method_22903();
        OERenderUtil.renderModel(poseStack, vc, model, light, overlay);
        renderText(poseStack, multiBufferSource, FELNULL_DEV_TEXT, light, 9f, 15.75f, 0.4f, false, 0);
        renderText(poseStack, multiBufferSource, MANUAL_TEXT, light, 4.225f / 2f, 15.75f, 0.54f, true, 0xFFFFFFFF);
        renderText(poseStack, multiBufferSource, MOD_NAME_TEXT, light, 9.85f, 14.5f, 0.7f, false, 0);
        renderText(poseStack, multiBufferSource, MOD_VERSION_TEXT, light, 9.85f, 13.5f, 0.4f, false, 0);
        renderText(poseStack, multiBufferSource, COVER_INFO_TEXT, light, 11f / 2f, 12, 0.4f, true, 0);
        poseStack.method_22909();
    }

    private void renderText(class_4587 poseStack, class_4597 multiBufferSource, class_2561 text, int light, float x, float y, float scale, boolean center, int color) {
        poseStack.method_22903();
        poseStack.method_22904(0, OERenderUtil.MIN_BREADTH, 0);
        OERenderUtil.poseTrans16(poseStack, x, 0.125, y);
        OERenderUtil.poseRotateX(poseStack, -90f);
        OERenderUtil.poseRotateZ(poseStack, 180f);
        if (center) {
            OERenderUtil.renderCenterTextSprite(poseStack, multiBufferSource, text, 0, 0, 0, scale, 0, mc.field_1772.field_2000, color, light);
        } else {
            OERenderUtil.renderTextSprite(poseStack, multiBufferSource, text, 0, 0, 0, scale, 0, mc.field_1772.field_2000, color, light);
        }
        poseStack.method_22909();
    }
}
