package dev.felnull.imp.inventory;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.otyacraftengine.item.location.IPlayerItemLocation;
import dev.felnull.otyacraftengine.util.OEMenuUtil;
import net.minecraft.class_1263;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_3917;

public class IMPMenus {
    private static final DeferredRegister<class_3917<?>> MENUS = DeferredRegister.create(IamMusicPlayer.MODID, class_2378.field_25083);
    public static final RegistrySupplier<class_3917<MusicManagerMenu>> MUSIC_MANAGER = registerBlockMenu("music_manager", MusicManagerMenu::new);
    public static final RegistrySupplier<class_3917<CassetteDeckMenu>> CASSETTE_DECK = registerBlockMenu("cassette_deck", CassetteDeckMenu::new);
    public static final RegistrySupplier<class_3917<BoomboxMenu>> BOOMBOX = registerItemAndBlockMenu("boombox", BoomboxMenu::new);

    private static <T extends class_1703> RegistrySupplier<class_3917<T>> registerItemAndBlockMenu(String name, OEItemAndBlockMenuFactory<T> factoryItemAndBlock ) {
        return MENUS.register(name, () -> OEMenuUtil.createMenuType(factoryItemAndBlock.getBlockMenuFactory(), factoryItemAndBlock.getItemMenuFactory()));
    }

    private static <T extends class_1703> RegistrySupplier<class_3917<T>> registerBlockMenu(String name, OEMenuUtil.OEBlockMenuFactory<T> factory) {
        return MENUS.register(name, () -> OEMenuUtil.createMenuType(factory));
    }

    public static void init() {
        MENUS.register();
    }

    public interface OEItemAndBlockMenuFactory<T extends class_1703> {
        T create(int i, class_1661 playerInventory, class_1263 container, class_2338 pos, class_1799 itemStack, IPlayerItemLocation location);

         default OEMenuUtil.OEBlockMenuFactory<T> getBlockMenuFactory(){
            return (i, inventory, blockPos, container) -> create(i, inventory, container, blockPos, class_1799.field_8037, null);
        }
         default OEMenuUtil.OEItemMenuFactory<T> getItemMenuFactory(){
            return (i, inventory, itemStack, iPlayerItemLocation, container) -> create(i, inventory, container, class_2338.field_10980, itemStack, iPlayerItemLocation);
        }
    }
}
