package dev.felnull.imp.networking;

import dev.architectury.networking.NetworkManager;
import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.client.handler.ClientMessageHandler;
import dev.felnull.imp.music.resource.*;
import dev.felnull.imp.server.handler.ServerMessageHandler;
import dev.felnull.imp.util.IMPNbtUtil;
import dev.felnull.otyacraftengine.item.location.IPlayerItemLocation;
import dev.felnull.otyacraftengine.item.location.PlayerItemLocations;
import dev.felnull.otyacraftengine.networking.BlockEntityExistence;
import dev.felnull.otyacraftengine.networking.PacketMessage;
import dev.felnull.otyacraftengine.util.OENbtUtil;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import record;
import var;

public class IMPPackets {
    public static final class_2960 MUSIC_SYNC = new class_2960(IamMusicPlayer.MODID, "music_sync");
    public static final class_2960 MUSIC_PLAYLIST_ADD = new class_2960(IamMusicPlayer.MODID, "music_playlist_add");
    public static final class_2960 MUSIC_PLAYLIST_EDIT = new class_2960(IamMusicPlayer.MODID, "music_playlist_edit");
    public static final class_2960 MUSIC_PLAYLIST_CHANGE_AUTHORITY = new class_2960(IamMusicPlayer.MODID, "music_playlist_change_authority");
    public static final class_2960 MUSIC_ADD = new class_2960(IamMusicPlayer.MODID, "music_add");
    public static final class_2960 MUSIC_EDIT = new class_2960(IamMusicPlayer.MODID, "music_edit");
    public static final class_2960 MUSIC_OR_PLAYLIST_DELETE = new class_2960(IamMusicPlayer.MODID, "music_or_playlist_delete");
    public static final class_2960 MUSIC_RING_READY = new class_2960(IamMusicPlayer.MODID, "music_ring_ready");
    public static final class_2960 MUSIC_RING_READY_RESULT = new class_2960(IamMusicPlayer.MODID, "music_ring_ready_result");
    public static final class_2960 MUSIC_RING_STATE = new class_2960(IamMusicPlayer.MODID, "music_ring_state");
    public static final class_2960 MUSIC_RING_UPDATE_RESULT = new class_2960(IamMusicPlayer.MODID, "music_ring_update_result");
    public static final class_2960 MULTIPLE_MUSIC_ADD = new class_2960(IamMusicPlayer.MODID, "multiple_music_add");
    public static final class_2960 HAND_LID_CYCLE = new class_2960(IamMusicPlayer.MODID, "hand_lid_cycle");

    public static void init() {
        NetworkManager.registerReceiver(NetworkManager.c2s(), MUSIC_SYNC, (friendlyByteBuf, packetContext) -> ServerMessageHandler.onMusicSyncRequestMessage(new MusicSyncRequestMessage(friendlyByteBuf), packetContext));
        NetworkManager.registerReceiver(NetworkManager.c2s(), MUSIC_PLAYLIST_ADD, (friendlyByteBuf, packetContext) -> ServerMessageHandler.onMusicPlayListAddMessage(new MusicPlayListMessage(friendlyByteBuf), packetContext));
        NetworkManager.registerReceiver(NetworkManager.c2s(), MUSIC_PLAYLIST_EDIT, (friendlyByteBuf, packetContext) -> ServerMessageHandler.onMusicPlayListEditMessage(new MusicPlayListMessage(friendlyByteBuf), packetContext));
        NetworkManager.registerReceiver(NetworkManager.c2s(), MUSIC_PLAYLIST_CHANGE_AUTHORITY, (friendlyByteBuf, packetContext) -> ServerMessageHandler.onMusicPlayListChangeAuthority(new MusicPlayListChangeAuthorityMessage(friendlyByteBuf), packetContext));
        NetworkManager.registerReceiver(NetworkManager.c2s(), MUSIC_ADD, (friendlyByteBuf, packetContext) -> ServerMessageHandler.onMusicAddMessage(new MusicMessage(friendlyByteBuf), packetContext));
        NetworkManager.registerReceiver(NetworkManager.c2s(), MUSIC_EDIT, (friendlyByteBuf, packetContext) -> ServerMessageHandler.onMusicEditMessage(new MusicMessage(friendlyByteBuf), packetContext));
        NetworkManager.registerReceiver(NetworkManager.c2s(), MUSIC_RING_READY_RESULT, (friendlyByteBuf, packetContext) -> ServerMessageHandler.onMusicReadyResultMessage(new MusicRingReadyResultMessage(friendlyByteBuf), packetContext));
        NetworkManager.registerReceiver(NetworkManager.c2s(), MUSIC_RING_UPDATE_RESULT, (friendlyByteBuf, packetContext) -> ServerMessageHandler.onMusicUpdateResultMessage(new MusicRingUpdateResultMessage(friendlyByteBuf), packetContext));
        NetworkManager.registerReceiver(NetworkManager.c2s(), MUSIC_OR_PLAYLIST_DELETE, (friendlyByteBuf, packetContext) -> ServerMessageHandler.onMusicOrPlayListDeleteMessage(new MusicOrPlayListDeleteMessage(friendlyByteBuf), packetContext));
        NetworkManager.registerReceiver(NetworkManager.c2s(), MULTIPLE_MUSIC_ADD, (friendlyByteBuf, packetContext) -> ServerMessageHandler.onMultipleMusicAdd(new MultipleMusicAddMessage(friendlyByteBuf), packetContext));
        NetworkManager.registerReceiver(NetworkManager.c2s(), HAND_LID_CYCLE, (friendlyByteBuf, packetContext) -> ServerMessageHandler.onHandLidCycleMessage(new LidCycleMessage(friendlyByteBuf), packetContext));
    }

    public static void clientInit() {
        NetworkManager.registerReceiver(NetworkManager.s2c(), MUSIC_SYNC, (friendlyByteBuf, packetContext) -> ClientMessageHandler.onMusicSyncResponseMessage(new MusicSyncResponseMessage(friendlyByteBuf), packetContext));
        NetworkManager.registerReceiver(NetworkManager.s2c(), MUSIC_RING_READY, (friendlyByteBuf, packetContext) -> ClientMessageHandler.onMusicRingReadyResponseMessage(new MusicReadyMessage(friendlyByteBuf), packetContext));
        NetworkManager.registerReceiver(NetworkManager.s2c(), MUSIC_RING_STATE, (friendlyByteBuf, packetContext) -> ClientMessageHandler.onMusicRingStateResponseMessage(new MusicRingStateMessage(friendlyByteBuf), packetContext));
    }

    public static class LidCycleMessage implements PacketMessage {
        public final UUID boomboxId;
        public final IPlayerItemLocation itemLocation;

        public LidCycleMessage(class_2540 buf) {
            this.boomboxId = buf.method_10790();
            this.itemLocation = PlayerItemLocations.create(buf.method_10810(), buf.method_10798());
        }

        public LidCycleMessage(UUID boomboxId, IPlayerItemLocation itemLocation) {
            this.boomboxId = boomboxId;
            this.itemLocation = itemLocation;
        }

        @Override
        public class_2540 toFBB() {
            var buf = new class_2540(Unpooled.buffer());
            buf.writeUUID(this.boomboxId);
            buf.writeResourceLocation(this.itemLocation.getResourceLocation());
            buf.writeNbt(this.itemLocation.toTag());
            return buf;
        }
    }

    public static class MusicPlayListChangeAuthorityMessage implements PacketMessage {
        public final UUID playlist;
        public final UUID player;
        public final AuthorityInfo.AuthorityType authorityType;
        public final BlockEntityExistence blockEntityExistence;

        public MusicPlayListChangeAuthorityMessage(class_2540 bf) {
            this.playlist = bf.method_10790();
            this.player = bf.method_10790();
            this.authorityType = AuthorityInfo.AuthorityType.getByName(bf.method_19772());
            this.blockEntityExistence = BlockEntityExistence.readFBB(bf);
        }

        public MusicPlayListChangeAuthorityMessage(UUID playlist, UUID player, AuthorityInfo.AuthorityType authorityType, BlockEntityExistence blockEntityExistence) {
            this.playlist = playlist;
            this.player = player;
            this.authorityType = authorityType;
            this.blockEntityExistence = blockEntityExistence;
        }

        @Override
        public class_2540 toFBB() {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.method_10797(playlist);
            buf.method_10797(player);
            buf.method_10814(authorityType.getName());
            this.blockEntityExistence.writeFBB(buf);
            return buf;
        }
    }

    public static class MultipleMusicAddMessage implements PacketMessage {
        public final UUID playlist;
        public final List<Music> musics;
        public final BlockEntityExistence blockEntityExistence;

        public MultipleMusicAddMessage(class_2540 bf) {
            this.playlist = bf.method_10790();
            this.musics = new ArrayList<>();
            IMPNbtUtil.readMusics(bf.method_10798(), "Musics", musics);
            this.blockEntityExistence = BlockEntityExistence.readFBB(bf);
        }

        public MultipleMusicAddMessage(UUID playlist, List<Music> musics, BlockEntityExistence blockEntityExistence) {
            this.playlist = playlist;
            this.musics = musics;
            this.blockEntityExistence = blockEntityExistence;
        }

        @Override
        public class_2540 toFBB() {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.method_10797(this.playlist);
            buf.method_10794(IMPNbtUtil.writeMusics(new class_2487(), "Musics", musics));
            this.blockEntityExistence.writeFBB(buf);
            return buf;
        }
    }

    public static class MusicOrPlayListDeleteMessage implements PacketMessage {
        public final UUID playListID;
        public final UUID musicID;
        public final BlockEntityExistence blockEntityExistence;
        public final boolean music;

        public MusicOrPlayListDeleteMessage(class_2540 bf) {
            this.playListID = bf.method_10790();
            this.musicID = bf.method_10790();
            this.blockEntityExistence = BlockEntityExistence.readFBB(bf);
            this.music = bf.readBoolean();
        }

        public MusicOrPlayListDeleteMessage(UUID playListID, UUID musicID, BlockEntityExistence blockEntityExistence, boolean music) {
            this.playListID = playListID;
            this.musicID = musicID;
            this.blockEntityExistence = blockEntityExistence;
            this.music = music;
        }

        @Override
        public class_2540 toFBB() {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.method_10797(this.playListID);
            buf.method_10797(this.musicID);
            this.blockEntityExistence.writeFBB(buf);
            buf.writeBoolean(this.music);
            return buf;
        }
    }


    public static record MusicRingUpdateResultMessage(UUID uuid, UUID waitId,
                                                      MusicRingResponseStateType ringResponseStateType) implements PacketMessage {
        public MusicRingUpdateResultMessage(class_2540 bf) {
            this(bf.method_10790(), bf.method_10790(), bf.method_10818(MusicRingResponseStateType.class));
        }

        @Override
        public class_2540 toFBB() {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.method_10797(uuid);
            buf.method_10797(waitId);
            buf.method_10817(ringResponseStateType);
            return buf;
        }
    }

    public static record MusicRingStateMessage(UUID uuid, UUID waitId, MusicRingStateType stateType, long elapsed,
                                               class_2487 tracker) implements PacketMessage {
        public MusicRingStateMessage(UUID uuid, UUID waitId, MusicRingStateType stateType) {
            this(uuid, waitId, stateType, 0, new class_2487());
        }

        public MusicRingStateMessage(class_2540 bf) {
            this(bf.method_10790(), bf.method_10790(), bf.method_10818(MusicRingStateType.class), bf.readLong(), bf.method_10798());
        }

        @Override
        public class_2540 toFBB() {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.method_10797(uuid);
            buf.method_10797(waitId);
            buf.method_10817(stateType);
            buf.writeLong(elapsed);
            buf.method_10794(tracker);
            return buf;
        }
    }

    public static class MusicRingReadyResultMessage implements PacketMessage {
        public final UUID waitID;
        public final UUID uuid;
        public final boolean result;
        public final boolean retry;
        public final long elapsed;

        public MusicRingReadyResultMessage(class_2540 bf) {
            this.waitID = bf.method_10790();
            this.uuid = bf.method_10790();
            this.result = bf.readBoolean();
            this.retry = bf.readBoolean();
            this.elapsed = bf.readLong();
        }

        public MusicRingReadyResultMessage(UUID waitID, UUID uuid, boolean result, boolean retry, long elapsed) {
            this.waitID = waitID;
            this.uuid = uuid;
            this.result = result;
            this.retry = retry;
            this.elapsed = elapsed;
        }

        @Override
        public class_2540 toFBB() {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.method_10797(waitID);
            buf.method_10797(uuid);
            buf.writeBoolean(result);
            buf.writeBoolean(retry);
            buf.writeLong(elapsed);
            return buf;
        }
    }

    public static record MusicReadyMessage(UUID waitId, UUID uuid, MusicSource source, class_2487 tracker,
                                           long position) implements PacketMessage {
        public MusicReadyMessage(class_2540 bf) {
            this(bf.method_10790(), bf.method_10790(), OENbtUtil.readSerializable(bf.method_10798(), "ms", new MusicSource()), bf.method_10798(), bf.readLong());
        }

        @Override
        public class_2540 toFBB() {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.method_10797(this.waitId);
            buf.method_10797(this.uuid);
            buf.method_10794(OENbtUtil.writeSerializable(new class_2487(), "ms", this.source));
            buf.method_10794(this.tracker);
            buf.writeLong(this.position);
            return buf;
        }
    }

    public static class MusicMessage implements PacketMessage {
        public final UUID uuid;
        public final UUID playlist;
        public final String name;
        public final String author;
        public final ImageInfo image;
        public final MusicSource source;
        public final BlockEntityExistence blockEntityExistence;

        public MusicMessage(class_2540 bf) {
            this.uuid = bf.method_10790();
            this.playlist = bf.method_10790();
            this.name = bf.method_19772();
            this.author = bf.method_19772();
            this.image = OENbtUtil.readSerializable(bf.method_10798(), "Image", new ImageInfo());
            this.source = OENbtUtil.readSerializable(bf.method_10798(), "Source", new MusicSource());
            this.blockEntityExistence = BlockEntityExistence.readFBB(bf);
        }

        public MusicMessage(UUID playlist, String name, String author, ImageInfo image, MusicSource source, BlockEntityExistence blockEntityExistence) {
            this(UUID.randomUUID(), playlist, name, author, image, source, blockEntityExistence);
        }

        public MusicMessage(UUID uuid, UUID playlist, String name, String author, ImageInfo image, MusicSource source, BlockEntityExistence blockEntityExistence) {
            this.uuid = uuid;
            this.playlist = playlist;
            this.name = name;
            this.author = author;
            this.image = image;
            this.source = source;
            this.blockEntityExistence = blockEntityExistence;
        }

        @Override
        public class_2540 toFBB() {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.method_10797(this.uuid);
            buf.method_10797(this.playlist);
            buf.method_10814(this.name);
            buf.method_10814(this.author);
            buf.method_10794(OENbtUtil.writeSerializable(new class_2487(), "Image", image));
            buf.method_10794(OENbtUtil.writeSerializable(new class_2487(), "Source", source));
            blockEntityExistence.writeFBB(buf);
            return buf;
        }
    }

    public static class MusicPlayListMessage implements PacketMessage {
        public final UUID uuid;
        public final String name;
        public final ImageInfo image;
        public final boolean publiced;
        public final boolean initMember;
        public final List<UUID> invitePlayers;
        public final BlockEntityExistence blockEntityExistence;
        public final List<Music> importMusics;

        public MusicPlayListMessage(class_2540 bf) {
            this.uuid = bf.method_10790();
            this.name = bf.method_19772();
            this.image = OENbtUtil.readSerializable(bf.method_10798(), "Image", new ImageInfo());
            this.publiced = bf.readBoolean();
            this.initMember = bf.readBoolean();
            this.invitePlayers = new ArrayList<>();
            OENbtUtil.readUUIDList(bf.method_10798(), "InvitePlayers", invitePlayers);
            this.blockEntityExistence = BlockEntityExistence.readFBB(bf);
            this.importMusics = new ArrayList<>();
            IMPNbtUtil.readMusics(bf.method_10798(), "ImportMusics", importMusics);
        }

        public MusicPlayListMessage(String name, ImageInfo image, boolean publiced, boolean initMember, List<UUID> invitePlayers, BlockEntityExistence blockEntityExistence, List<Music> importMusics) {
            this(UUID.randomUUID(), name, image, publiced, initMember, invitePlayers, blockEntityExistence, importMusics);
        }

        public MusicPlayListMessage(UUID uuid, String name, ImageInfo image, boolean publiced, boolean initMember, List<UUID> invitePlayers, BlockEntityExistence blockEntityExistence, List<Music> importMusics) {
            this.uuid = uuid;
            this.name = name;
            this.image = image;
            this.publiced = publiced;
            this.initMember = initMember;
            this.invitePlayers = invitePlayers;
            this.blockEntityExistence = blockEntityExistence;
            this.importMusics = importMusics;
        }

        @Override
        public class_2540 toFBB() {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.method_10797(this.uuid);
            buf.method_10814(this.name);
            buf.method_10794(OENbtUtil.writeSerializable(new class_2487(), "Image", image));
            buf.writeBoolean(publiced);
            buf.writeBoolean(initMember);
            buf.method_10794(OENbtUtil.writeUUIDList(new class_2487(), "InvitePlayers", invitePlayers));
            blockEntityExistence.writeFBB(buf);
            buf.method_10794(IMPNbtUtil.writeMusics(new class_2487(), "ImportMusics", importMusics));
            return buf;
        }
    }

    public static class MusicSyncResponseMessage implements PacketMessage {
        public final MusicSyncType syncType;
        public final UUID syncId;
        public final List<MusicPlayList> playLists;
        public final List<Music> musics;

        public MusicSyncResponseMessage(class_2540 bf) {
            this.syncType = MusicSyncType.getById(bf.readInt());
            this.syncId = bf.method_10790();
            this.playLists = new ArrayList<>();
            IMPNbtUtil.readMusicPlayLists(bf.method_10798(), "PlayLists", playLists);
            this.musics = new ArrayList<>();
            IMPNbtUtil.readMusics(bf.method_10798(), "Musics", musics);
        }

        public MusicSyncResponseMessage(MusicSyncType syncType, UUID syncId, List<MusicPlayList> playLists, List<Music> musics) {
            this.syncType = syncType;
            this.syncId = syncId;
            this.playLists = playLists;
            this.musics = musics;
        }

        @Override
        public class_2540 toFBB() {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.writeInt(syncType.ordinal());
            buf.method_10797(syncId);
            buf.method_10794(IMPNbtUtil.writeMusicPlayLists(new class_2487(), "PlayLists", playLists));
            buf.method_10794(IMPNbtUtil.writeMusics(new class_2487(), "Musics", musics));
            return buf;
        }
    }

    public static class MusicSyncRequestMessage implements PacketMessage {
        public final MusicSyncType syncType;
        public final UUID syncId;

        public MusicSyncRequestMessage(class_2540 bf) {
            this(MusicSyncType.getById(bf.readInt()), bf.method_10790());
        }

        public MusicSyncRequestMessage(MusicSyncType syncType, UUID syncId) {
            this.syncType = syncType;
            this.syncId = syncId;
        }

        @Override
        public class_2540 toFBB() {
            class_2540 buf = new class_2540(Unpooled.buffer());
            buf.writeInt(syncType.ordinal());
            buf.method_10797(syncId);
            return buf;
        }
    }

    public static enum MusicSyncType {
        NONE,
        PLAYLIST_CAN_JOIN,
        PLAYLIST_MY_LIST,
        MUSIC_BY_PLAYLIST,
        UPDATE;

        private static MusicSyncType getById(int id) {
            if (values().length > id)
                return values()[id];
            return NONE;
        }
    }

    public static enum MusicRingStateType {
        NONE,
        PLAY,
        STOP,
        UPDATE
    }

    public static enum MusicRingResponseStateType {
        NONE,
        PLAYING,
        LOADING
    }
}
