package dev.felnull.imp.server.music.ringer;

import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.imp.music.tracker.MusicTrackerEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;

public interface IMusicRinger {
    public class_2561 getRingerName();

    public class_3218 getRingerLevel();

    public UUID getRingerUUID();

    public boolean exists();

    public boolean isRingerPlaying();

    public void setRingerPlaying(boolean playing);

    public @Nullable MusicSource getRingerMusicSource();

    public boolean isRingerLoop();

    public long getRingerPosition();

    public void setRingerPosition(long position);

    public MusicTrackerEntry getRingerTracker();

    public @NotNull class_243 getRingerSpatialPosition();

    public float getRingerVolume();

    public float getRingerRange();

    public boolean isRingerStream();

    default public boolean isRingerWait() {
        return getMusicRing().isWaitRinger(getRingerUUID());
    }

    default public MusicRing getMusicRing() {
        return MusicRingManager.getInstance().getMusicRing(getRingerLevel());
    }

    default public boolean alreadyAdded() {
        return getMusicRing().hasRinger(getRingerUUID());
    }

    default public void ringerTick() {
        if (!alreadyAdded())
            addRingerInRingManager();
    }

    default public void addRingerInRingManager() {
        getMusicRing().addRinger(this);
    }

    default public void ringerRestart() {
        getMusicRing().restart(getRingerUUID());
    }

    default public void ringerEnd() {

    }

    public boolean isRingerMute();

    default public boolean isRingerRemote() {
        return false;
    }

    @Nullable
    default public String getRingerMusicAuthor() {
        return null;
    }

    @NotNull
    default public class_1799 getRingerAntenna() {
        return class_1799.field_8037;
    }
}
