/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.blockentity;

import dev.felnull.imp.block.IMPBlocks;
import dev.felnull.imp.blockentity.IMPBaseEntityBlockEntity;
import dev.felnull.imp.blockentity.IMPBlockEntities;
import dev.felnull.imp.inventory.MusicManagerMenu;
import dev.felnull.imp.music.resource.AuthorityInfo;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.Music;
import dev.felnull.imp.music.resource.MusicPlayList;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.imp.server.music.MusicManager;
import dev.felnull.otyacraftengine.server.data.ITAGSerializable;
import dev.felnull.otyacraftengine.util.OENbtUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MusicManagerBlockEntity
extends IMPBaseEntityBlockEntity {
    private class_2371<class_1799> items = class_2371.method_10213((int)0, (Object)class_1799.field_8037);
    protected final Map<UUID, class_2487> playerData = new HashMap<UUID, class_2487>();
    private class_2487 myData = new class_2487();

    public MusicManagerBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super((class_2591)IMPBlockEntities.MUSIC_MANAGER.get(), blockPos, blockState);
    }

    protected class_2561 method_17823() {
        return ((class_2248)IMPBlocks.MUSIC_MANAGER.get()).method_9518();
    }

    protected class_1703 method_5465(int i, class_1661 inventory) {
        return new MusicManagerMenu(i, inventory, this.method_11016(), (class_1263)this);
    }

    public static void tick(class_1937 level, class_2338 blockPos, class_2680 blockState, MusicManagerBlockEntity blockEntity) {
        if (!level.method_8608()) {
            blockEntity.playerData.forEach((n, m) -> {
                String monst = m.method_10558("Monitor");
                if (!monst.isEmpty()) {
                    MonitorType type = MonitorType.getByName(monst);
                    if (blockEntity.isPowered() && type == MonitorType.OFF || !blockEntity.isPowered() && type != MonitorType.OFF) {
                        m.method_10582("Monitor", MonitorType.getDefault(blockEntity, n).getName());
                    }
                    if (type == MonitorType.OFF) {
                        m.method_10551("SelectedPlayList");
                        m.method_10551("SelectedMusic");
                    }
                    MusicManager mm = MusicManager.getInstance();
                    if (m.method_10545("SelectedPlayList") && (mm.getSaveData().getPlayLists().get(m.method_25926("SelectedPlayList")) == null || !mm.getSaveData().getPlayLists().get(m.method_25926("SelectedPlayList")).getAuthority().getAuthorityType((UUID)n).isMoreReadOnly())) {
                        m.method_10551("SelectedPlayList");
                        m.method_10551("SelectedMusic");
                    } else if (m.method_10545("SelectedMusic") && !mm.getSaveData().getMusics().containsKey(m.method_25926("SelectedMusic"))) {
                        m.method_10551("SelectedMusic");
                    }
                    if (m.method_10545("SelectedPlayer")) {
                        boolean rmFlg = !m.method_10545("SelectedPlayList");
                        boolean rmFlg2 = false;
                        if (m.method_10545("SelectedPlayList")) {
                            MusicPlayList pl = mm.getSaveData().getPlayLists().get(m.method_25926("SelectedPlayList"));
                            rmFlg2 = pl != null ? !pl.getAuthority().getPlayersAuthority().containsKey(m.method_25926("SelectedPlayer")) : true;
                        }
                        if (rmFlg || rmFlg2) {
                            m.method_10551("SelectedPlayer");
                        }
                    }
                    if (type != null && type.isNeedSelectPlayList() && !m.method_10545("SelectedPlayList")) {
                        m.method_10582("Monitor", MonitorType.PLAY_LIST.getName());
                    }
                    if (type != null && type.isNeedSelectMusic() && !m.method_10545("SelectedMusic")) {
                        m.method_10582("Monitor", MonitorType.PLAY_LIST.getName());
                    }
                }
            });
            blockEntity.method_5431();
            blockEntity.sync();
        }
    }

    private void updateMonitor(class_3222 player, MonitorType newM, MonitorType oldM) {
        Music ms;
        MusicPlayList pls;
        MusicPlayList pls2;
        boolean keepFlg4;
        class_2487 tag = this.getPlayerData(player);
        boolean keepFlg = oldM == MonitorType.ADD_MUSIC && newM == MonitorType.SEARCH_MUSIC || oldM == MonitorType.SEARCH_MUSIC && newM == MonitorType.ADD_MUSIC;
        boolean keepFlg2 = oldM == MonitorType.ADD_MUSIC && newM == MonitorType.UPLOAD_MUSIC || oldM == MonitorType.UPLOAD_MUSIC && newM == MonitorType.ADD_MUSIC;
        boolean keepFlg3 = oldM != null && newM != null && oldM.isKeepPlayListData() && newM.isKeepPlayListData();
        boolean bl = keepFlg4 = oldM != null && newM != null && oldM.isKeepMusicData() && newM.isKeepMusicData();
        if (!(keepFlg || keepFlg2 || keepFlg3 || keepFlg4)) {
            tag.method_10551("Image");
            tag.method_10551("ImageURL");
            tag.method_10551("CreateName");
            tag.method_10551("Publishing");
            tag.method_10551("InitialAuthority");
            tag.method_10551("InvitePlayerName");
            tag.method_10551("InvitePlayers");
            tag.method_10551("MusicLoaderType");
            tag.method_10551("MusicSourceName");
            tag.method_10551("MusicSource");
            tag.method_10551("MusicAuthor");
            tag.method_10551("ImportIdentifier");
            tag.method_10551("ImportPlayListName");
            tag.method_10551("ImportPlayListAuthor");
            tag.method_10551("ImportPlayListMusicCount");
        }
        tag.method_10551("SelectedPlayer");
        tag.method_10551("MusicSearchName");
        MusicManager mm = MusicManager.getInstance();
        UUID pl = this.getSelectedPlayList(player);
        if (oldM == MonitorType.DETAIL_PLAY_LIST && newM == MonitorType.EDIT_PLAY_LIST && pl != null && (pls2 = mm.getSaveData().getPlayLists().get(pl)) != null) {
            this.setImage(player, pls2.getImage());
            this.setCreateName(player, pls2.getName());
            this.setInitialAuthority(player, pls2.getAuthority().getInitialAuthority() == AuthorityInfo.AuthorityType.MEMBER ? "member" : "read_only");
            this.setPublishing(player, pls2.getAuthority().isPublic() ? "public" : "private");
            this.setInvitePlayers(player, pls2.getAuthority().getRawAuthority().entrySet().stream().filter(n -> ((AuthorityInfo.AuthorityType)((Object)((Object)n.getValue()))).isInvitation()).map(Map.Entry::getKey).toList());
        }
        UUID m = this.getSelectedMusic(player);
        if (oldM == MonitorType.DETAIL_MUSIC && newM == MonitorType.EDIT_MUSIC && m != null && (pls = mm.getSaveData().getPlayLists().get(pl)) != null && pls.getMusicList().contains(m) && (ms = mm.getSaveData().getMusics().get(m)) != null) {
            this.setImage(player, ms.getImage());
            this.setCreateName(player, ms.getName());
            this.setMusicAuthor(player, ms.getAuthor());
            this.setMusicSource(player, ms.getSource());
            this.setMusicLoaderType(player, ms.getSource().getLoaderType());
        }
        this.method_5431();
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        OENbtUtil.readMap((class_2487)tag, (String)"PlayerData", this.playerData);
    }

    public void method_11007(class_2487 tag) {
        super.method_11007(tag);
        OENbtUtil.writeMap((class_2487)tag, (String)"PlayerData", this.playerData);
    }

    public class_2487 getSyncData(class_3222 player, class_2487 tag) {
        class_2487 pltag = this.playerData.get(player.method_7334().getId());
        if (pltag != null) {
            tag.method_10566("Data", (class_2520)pltag);
        }
        return tag;
    }

    public void onSync(class_2487 tag) {
        super.onSync(tag);
        this.myData = tag.method_10562("Data");
    }

    @Nullable
    public UUID getSelectedMusic(@NotNull class_3222 player) {
        class_2487 tag = this.getPlayerData(player);
        if (tag.method_10545("SelectedMusic")) {
            return tag.method_25926("SelectedMusic");
        }
        return null;
    }

    @Nullable
    public UUID getSelectedPlayer(@NotNull class_3222 player) {
        class_2487 tag = this.getPlayerData(player);
        if (tag.method_10545("SelectedPlayer")) {
            return tag.method_25926("SelectedPlayer");
        }
        return null;
    }

    @Nullable
    public UUID getSelectedPlayList(@NotNull class_3222 player) {
        class_2487 tag = this.getPlayerData(player);
        if (tag.method_10545("SelectedPlayList")) {
            return tag.method_25926("SelectedPlayList");
        }
        return null;
    }

    public class_2487 getPlayerData(class_3222 player) {
        UUID id = player.method_7334().getId();
        if (!this.playerData.containsKey(id)) {
            this.playerData.put(id, new class_2487());
        }
        return this.playerData.get(id);
    }

    @Nullable
    public UUID getMySelectedPlayer() {
        if (!this.myData.method_10545("SelectedPlayer")) {
            return null;
        }
        return this.myData.method_25926("SelectedPlayer");
    }

    @Nullable
    public UUID getMySelectedMusic() {
        if (!this.myData.method_10545("SelectedMusic")) {
            return null;
        }
        return this.myData.method_25926("SelectedMusic");
    }

    public UUID getMySelectedPlayList() {
        if (!this.myData.method_10545("SelectedPlayList")) {
            return null;
        }
        return this.myData.method_25926("SelectedPlayList");
    }

    public MusicSource getMyMusicSource() {
        if (this.myData.method_10545("MusicSource")) {
            return (MusicSource)OENbtUtil.readSerializable((class_2487)this.myData, (String)"MusicSource", (ITAGSerializable)new MusicSource());
        }
        return MusicSource.EMPTY;
    }

    public void setMusicSource(class_3222 player, MusicSource source) {
        OENbtUtil.writeSerializable((class_2487)this.getPlayerData(player), (String)"MusicSource", (ITAGSerializable)source);
        this.method_5431();
    }

    public int getMyImportPlayListMusicCount() {
        return this.myData.method_10550("ImportPlayListMusicCount");
    }

    public void setImportPlayListMusicCount(@NotNull class_3222 player, int num) {
        this.getPlayerData(player).method_10569("ImportPlayListMusicCount", num);
        this.method_5431();
    }

    @NotNull
    public String getMyImportPlayListAuthor() {
        return this.myData.method_10558("ImportPlayListAuthor");
    }

    public void setImportPlayListAuthor(@NotNull class_3222 player, @NotNull String name) {
        this.getPlayerData(player).method_10582("ImportPlayListAuthor", name);
        this.method_5431();
    }

    @NotNull
    public String getMyImportPlayListName() {
        return this.myData.method_10558("ImportPlayListName");
    }

    public void setImportPlayListName(@NotNull class_3222 player, @NotNull String name) {
        this.getPlayerData(player).method_10582("ImportPlayListName", name);
        this.method_5431();
    }

    @NotNull
    public String getMyImportIdentifier() {
        return this.myData.method_10558("ImportIdentifier");
    }

    public void setImportIdentifier(@NotNull class_3222 player, @NotNull String identifier) {
        this.getPlayerData(player).method_10582("ImportIdentifier", identifier);
        this.method_5431();
    }

    public String getMyMusicSourceName() {
        return this.myData.method_10558("MusicSourceName");
    }

    public void setMusicSourceName(class_3222 player, String name) {
        this.getPlayerData(player).method_10582("MusicSourceName", name);
        this.method_5431();
    }

    public String getMyMusicAuthor() {
        return this.myData.method_10558("MusicAuthor");
    }

    public void setMusicAuthor(class_3222 player, String name) {
        this.getPlayerData(player).method_10582("MusicAuthor", name);
        this.method_5431();
    }

    public String getMyMusicSearchName() {
        return this.myData.method_10558("MusicSearchName");
    }

    public void setMusicSearchName(class_3222 player, String name) {
        this.getPlayerData(player).method_10582("MusicSearchName", name);
        this.method_5431();
    }

    public String getMyMusicLoaderType() {
        return this.myData.method_10558("MusicLoaderType");
    }

    public void setMusicLoaderType(class_3222 player, String name) {
        this.getPlayerData(player).method_10582("MusicLoaderType", name);
        this.method_5431();
    }

    public void setSelectedPlayer(@NotNull class_3222 player, @Nullable UUID selectedPlayer) {
        if (selectedPlayer != null) {
            this.getPlayerData(player).method_25927("SelectedPlayer", selectedPlayer);
        } else {
            this.getPlayerData(player).method_10551("SelectedPlayer");
        }
        this.method_5431();
    }

    public void setSelectedMusic(@NotNull class_3222 player, @Nullable UUID selectedMusic) {
        MonitorType type = this.getMonitor(player);
        if (type != null && type.isNeedSelectMusic() && this.getPlayerData(player).method_10545("SelectedMusic")) {
            UUID old = this.getPlayerData(player).method_25926("SelectedMusic");
            if (selectedMusic == null || !selectedMusic.equals(old)) {
                this.setMonitor(player, MonitorType.PLAY_LIST);
            }
        }
        if (selectedMusic != null) {
            this.getPlayerData(player).method_25927("SelectedMusic", selectedMusic);
        } else {
            this.getPlayerData(player).method_10551("SelectedMusic");
        }
        this.method_5431();
    }

    public void setSelectedPlayList(@NotNull class_3222 player, @Nullable UUID selectedPlayList) {
        MonitorType type = this.getMonitor(player);
        if (type != null && type.isNeedSelectPlayList() && this.getPlayerData(player).method_10545("SelectedPlayList")) {
            UUID old = this.getPlayerData(player).method_25926("SelectedPlayList");
            if (selectedPlayList == null || !selectedPlayList.equals(old)) {
                this.setMonitor(player, MonitorType.PLAY_LIST);
            }
        }
        if (selectedPlayList != null) {
            this.getPlayerData(player).method_25927("SelectedPlayList", selectedPlayList);
        } else {
            this.getPlayerData(player).method_10551("SelectedPlayList");
        }
        this.method_5431();
    }

    public List<UUID> getMyInvitePlayers() {
        ArrayList<UUID> pls = new ArrayList<UUID>();
        OENbtUtil.readUUIDList((class_2487)this.myData, (String)"InvitePlayers", pls);
        return pls;
    }

    public void setInvitePlayers(class_3222 player, List<UUID> players) {
        class_2487 tag = this.getPlayerData(player);
        tag.method_10551("InvitePlayers");
        OENbtUtil.writeUUIDList((class_2487)tag, (String)"InvitePlayers", players);
        this.method_5431();
    }

    public String getMyInvitePlayerName() {
        return this.myData.method_10558("InvitePlayerName");
    }

    public void setInvitePlayerName(class_3222 player, String name) {
        this.getPlayerData(player).method_10582("InvitePlayerName", name);
        this.method_5431();
    }

    public void setImage(class_3222 player, ImageInfo image) {
        OENbtUtil.writeSerializable((class_2487)this.getPlayerData(player), (String)"Image", (ITAGSerializable)image);
        this.method_5431();
    }

    public ImageInfo getMyImage() {
        if (this.myData.method_10562("Image").method_33133()) {
            return ImageInfo.EMPTY;
        }
        return (ImageInfo)OENbtUtil.readSerializable((class_2487)this.myData, (String)"Image", (ITAGSerializable)new ImageInfo());
    }

    public String getMyInitialAuthority() {
        return this.myData.method_10558("InitialAuthority");
    }

    public void setInitialAuthority(class_3222 player, String initialAuthority) {
        this.getPlayerData(player).method_10582("InitialAuthority", initialAuthority);
        this.method_5431();
    }

    public String getMyPublishing() {
        return this.myData.method_10558("Publishing");
    }

    public void setPublishing(class_3222 player, String publishing) {
        this.getPlayerData(player).method_10582("Publishing", publishing);
        this.method_5431();
    }

    public String getMyCreateName() {
        return this.myData.method_10558("CreateName");
    }

    public void setCreateName(class_3222 player, String name) {
        this.getPlayerData(player).method_10582("CreateName", name);
        this.method_5431();
    }

    public void setImageURL(class_3222 player, String url) {
        this.getPlayerData(player).method_10582("ImageURL", url);
        this.method_5431();
    }

    public String getMyImageURL() {
        return this.myData.method_10558("ImageURL");
    }

    public MonitorType getMonitor(class_3222 player) {
        return MonitorType.getByNameOrDefault(this.getPlayerData(player).method_10558("Monitor"), this, player.method_7334().getId());
    }

    public void setMonitor(class_3222 player, MonitorType type) {
        MonitorType oldM = MonitorType.getByNameOrDefault(this.getPlayerData(player).method_10558("Monitor"), this, player.method_7334().getId());
        if (oldM != type) {
            this.updateMonitor(player, type, oldM);
        }
        this.getPlayerData(player).method_10582("Monitor", type.getName());
        this.method_5431();
    }

    public MonitorType getMyMonitor(class_1657 player) {
        String name = this.myData.method_10558("Monitor");
        return MonitorType.getByNameOrDefault(name, this, player.method_7334().getId());
    }

    @Override
    public class_2487 onInstruction(class_3222 player, String name, int num, class_2487 data) {
        if ("set_monitor".equals(name)) {
            String mn = data.method_10558("type");
            if (!mn.isEmpty()) {
                this.setMonitor(player, MonitorType.getByName(mn));
            }
            return null;
        }
        if ("add_playlist".equals(name)) {
            if (data.method_10545("playlist")) {
                UUID pl = data.method_25926("playlist");
                MusicManager.getInstance().addPlayListToPlayer(pl, player);
            }
            return data;
        }
        if ("set_image_url".equals(name)) {
            String url = data.method_10558("url");
            this.setImageURL(player, url);
            return null;
        }
        if ("set_image".equals(name)) {
            ImageInfo image = (ImageInfo)OENbtUtil.readSerializable((class_2487)data, (String)"image", (ITAGSerializable)new ImageInfo());
            this.setImage(player, image);
            return null;
        }
        if ("set_create_name".equals(name)) {
            String cname = data.method_10558("name");
            this.setCreateName(player, cname);
            return null;
        }
        if ("set_publishing".equals(name)) {
            String pub = data.method_10558("publishing");
            this.setPublishing(player, pub);
            return null;
        }
        if ("set_initial_authority".equals(name)) {
            String ina = data.method_10558("initial_authority");
            this.setInitialAuthority(player, ina);
            return null;
        }
        if ("set_invite_player_name".equals(name)) {
            String pname = data.method_10558("name");
            this.setInvitePlayerName(player, pname);
            return null;
        }
        if ("set_invite_players".equals(name)) {
            ArrayList<UUID> pls = new ArrayList<UUID>();
            OENbtUtil.readUUIDList((class_2487)data, (String)"players", pls);
            this.setInvitePlayers(player, pls);
            return null;
        }
        if ("set_selected_playlist".equals(name)) {
            if (data.method_10545("playlist")) {
                UUID id = data.method_25926("playlist");
                this.setSelectedPlayList(player, id);
            } else {
                this.setSelectedPlayList(player, null);
            }
            return data;
        }
        if ("set_music_loader_type".equals(name)) {
            String lname = data.method_10558("name");
            this.setMusicLoaderType(player, lname);
            return null;
        }
        if ("set_music_source_name".equals(name)) {
            String mname = data.method_10558("name");
            this.setMusicSourceName(player, mname);
            return null;
        }
        if ("set_music_source".equals(name)) {
            MusicSource ms = (MusicSource)OENbtUtil.readSerializable((class_2487)data, (String)"MusicSource", (ITAGSerializable)new MusicSource());
            this.setMusicSource(player, ms);
            return null;
        }
        if ("set_music_search_name".equals(name)) {
            String sname = data.method_10558("name");
            this.setMusicSearchName(player, sname);
            return null;
        }
        if ("set_music_author".equals(name)) {
            String author = data.method_10558("author");
            this.setMusicAuthor(player, author);
            return null;
        }
        if ("set_import_identifier".equals(name)) {
            this.setImportIdentifier(player, data.method_10558("id"));
            return null;
        }
        if ("set_import_playlist_name".equals(name)) {
            this.setImportPlayListName(player, data.method_10558("name"));
            return null;
        }
        if ("set_import_playlist_author".equals(name)) {
            this.setImportPlayListAuthor(player, data.method_10558("author"));
            return null;
        }
        if ("set_import_playlist_music_count".equals(name)) {
            this.setImportPlayListMusicCount(player, data.method_10550("count"));
            return null;
        }
        if ("set_selected_music".equals(name)) {
            if (data.method_10545("music")) {
                UUID id = data.method_25926("music");
                this.setSelectedMusic(player, id);
            } else {
                this.setSelectedMusic(player, null);
            }
            return null;
        }
        if ("set_selected_player".equals(name)) {
            if (data.method_10545("player")) {
                UUID id = data.method_25926("player");
                this.setSelectedPlayer(player, id);
            } else {
                this.setSelectedPlayer(player, null);
            }
            return null;
        }
        return super.onInstruction(player, name, num, data);
    }

    @NotNull
    public class_2371<class_1799> getItems() {
        return this.items;
    }

    public static enum MonitorType {
        OFF("off", false),
        TEST("test", false),
        PLAY_LIST("play_list", false),
        ADD_PLAY_LIST("add_play_list", false),
        ADD_ONLINE_PLAY_LIST("add_online_play_list", false),
        EDIT_PLAY_LIST("edit_play_list", true),
        DETAIL_PLAY_LIST("detail_play_list", true),
        IMPORT_PLAY_LIST_SELECT("import_play_list_select", false),
        CREATE_PLAY_LIST("create_play_list", false),
        DELETE_PLAY_LIST("delete_play_list", true),
        ADD_MUSIC("add_music", true),
        SEARCH_MUSIC("search_music", true),
        UPLOAD_MUSIC("upload_music", true),
        DETAIL_MUSIC("detail_music", true),
        EDIT_MUSIC("edit_music", true),
        DELETE_MUSIC("delete_music", true),
        IMPORT_YOUTUBE_PLAY_LIST("import_youtube_play_list", false),
        IMPORT_MUSICS_SELECT("import_musics_select", true),
        IMPORT_YOUTUBE_PLAY_LIST_MUSICS("import_youtube_play_list_musics", true),
        AUTHORITY("authority", true);

        private final String name;
        private final boolean needSelectPlayList;

        private MonitorType(String name, boolean needSelectPlayList) {
            this.name = name;
            this.needSelectPlayList = needSelectPlayList;
        }

        public String getName() {
            return this.name;
        }

        public static MonitorType getByNameOrDefault(String name, MusicManagerBlockEntity blockEntity, UUID player) {
            for (MonitorType value : MonitorType.values()) {
                if (!value.getName().equals(name)) continue;
                return value;
            }
            return MonitorType.getDefault(blockEntity, player);
        }

        public static MonitorType getByName(String name) {
            for (MonitorType value : MonitorType.values()) {
                if (!value.getName().equals(name)) continue;
                return value;
            }
            return OFF;
        }

        public boolean isNeedSelectPlayList() {
            return this.needSelectPlayList;
        }

        public boolean isNeedSelectMusic() {
            return this == DETAIL_MUSIC || this == DELETE_MUSIC || this == EDIT_MUSIC;
        }

        public boolean isKeepPlayListData() {
            return this == CREATE_PLAY_LIST || this == IMPORT_PLAY_LIST_SELECT || this == IMPORT_YOUTUBE_PLAY_LIST;
        }

        public boolean isKeepMusicData() {
            return this == ADD_MUSIC || this == IMPORT_MUSICS_SELECT || this == IMPORT_YOUTUBE_PLAY_LIST_MUSICS;
        }

        public static MonitorType getDefault(MusicManagerBlockEntity blockEntity, UUID player) {
            return blockEntity.isPowered() ? PLAY_LIST : OFF;
        }
    }
}

