/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen.monitor.boombox;

import dev.architectury.utils.value.BooleanValue;
import dev.architectury.utils.value.FloatValue;
import dev.felnull.fnjl.util.FNStringUtil;
import dev.felnull.imp.client.gui.components.LoopControlWidget;
import dev.felnull.imp.client.gui.components.PlayProgressWidget;
import dev.felnull.imp.client.gui.screen.BoomboxScreen;
import dev.felnull.imp.client.gui.screen.monitor.boombox.PlayBackBaseBMonitor;
import dev.felnull.imp.data.BoomboxData;
import dev.felnull.imp.music.resource.MusicSource;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

public abstract class PlayBackFiniteBaseBMMonitor
extends PlayBackBaseBMonitor {
    private static final class_2561 LOADING_MUSIC_TEXT = new class_2588("imp.text.musicLoading");
    private LoopControlWidget loopControlWidget;
    private PlayProgressWidget playProgressWidget;

    public PlayBackFiniteBaseBMMonitor(BoomboxData.MonitorType monitorType, BoomboxScreen screen) {
        super(monitorType, screen);
    }

    @Override
    public void init(int leftPos, int topPos) {
        super.init(leftPos, topPos);
        this.loopControlWidget = this.addRenderWidget(new LoopControlWidget(this.getStartX() + (this.isShortTipProgressBar() ? 156 : 189), this.getStartY() + (this.isShortTipProgressBar() ? 15 : 26), new BooleanValue(){

            public void accept(boolean t) {
                PlayBackFiniteBaseBMMonitor.this.setLoop(t);
            }

            public boolean getAsBoolean() {
                return PlayBackFiniteBaseBMMonitor.this.isLoop();
            }
        }));
        this.loopControlWidget.field_22764 = this.canPlay();
        this.playProgressWidget = this.addRenderWidget(new PlayProgressWidget(this.getStartX() + (this.isShortProgressBar() ? 48 : 12), this.getStartY() + 28, this.getProgressBarWidth(this.getScreen().getBoomBoxData()), new FloatValue(){

            public float getAsFloat() {
                MusicSource s = PlayBackFiniteBaseBMMonitor.this.getPlayBackSource();
                if (!s.isEmpty()) {
                    return (float)PlayBackFiniteBaseBMMonitor.this.getScreen().getMusicPosition() / (float)s.getDuration();
                }
                return 0.0f;
            }

            public void accept(float t) {
                MusicSource s = PlayBackFiniteBaseBMMonitor.this.getPlayBackSource();
                if (!s.isEmpty()) {
                    long vl = (long)((float)s.getDuration() * t);
                    PlayBackFiniteBaseBMMonitor.this.getScreen().insPositionAndRestart(vl);
                }
            }
        }));
        this.playProgressWidget.field_22764 = this.canPlay();
    }

    @Override
    public void tick() {
        super.tick();
        this.loopControlWidget.field_22764 = this.canPlay();
        this.loopControlWidget.field_22760 = this.getStartX() + (this.isShortTipProgressBar() ? 156 : 189);
        this.loopControlWidget.field_22761 = this.getStartY() + (this.isShortTipProgressBar() ? 15 : 26);
        this.playProgressWidget.field_22764 = this.canPlay();
        this.playProgressWidget.method_25358(this.getProgressBarWidth(this.getScreen().getBoomBoxData()));
        this.playProgressWidget.field_22760 = this.getStartX() + (this.isShortProgressBar() ? 48 : 12);
    }

    private int getProgressBarWidth(BoomboxData data) {
        return (this.isShortProgressBar(data) ? 133 : 176) - (this.isShortTipProgressBar() ? (this.isShortProgressBar(data) ? 2 : 10) : 0);
    }

    private void setLoop(boolean loop) {
        this.getScreen().insLoop(loop);
    }

    private boolean isLoop() {
        return this.getScreen().isLoop();
    }

    private void setPause() {
        this.getScreen().insPause();
    }

    private void setPlaying(boolean playing) {
        this.getScreen().insPlaying(playing);
    }

    @Override
    public void render(class_4587 poseStack, float f, int mouseX, int mouseY) {
        super.render(poseStack, f, mouseX, mouseY);
        if (!this.canPlay()) {
            return;
        }
        class_2561 ptx = LOADING_MUSIC_TEXT;
        if (!this.getScreen().isMusicLoading()) {
            ptx = new class_2585(FNStringUtil.getTimeProgress((long)this.getScreen().getMusicPosition(), (long)this.getPlayBackSource().getDuration()));
        }
        this.drawSmartText(poseStack, ptx, this.getStartX() + 38 - (this.isShortProgressBar() ? 0 : 36), this.getStartY() + 15, -15639282);
    }

    @Override
    public void renderAppearance(class_4587 poseStack, class_4597 multiBufferSource, int i, int j, float f, float monitorWidth, float monitorHeight, BoomboxData data) {
        super.renderAppearance(poseStack, multiBufferSource, i, j, f, monitorWidth, monitorHeight, data);
        if (!this.canPlay(data)) {
            return;
        }
        class_2561 ptx = LOADING_MUSIC_TEXT;
        if (!data.isLoadingMusic()) {
            ptx = new class_2585(FNStringUtil.getTimeProgress((long)data.getMusicPosition(), (long)this.getPlayBackSource(data).getDuration()));
        }
        float onPxW = monitorWidth / (float)this.width;
        float onPxH = monitorHeight / (float)this.height;
        this.renderSmartTextSpriteColorSprite(poseStack, multiBufferSource, ptx, 38.0f - (this.isShortProgressBar(data) ? 0.0f : 36.0f), 17.0f, 0.002f, onPxW, onPxH, monitorHeight, -15639282, i);
        this.renderLoopControl(poseStack, multiBufferSource, this.isShortTipProgressBar() ? 156.0f : 189.0f, this.isShortTipProgressBar() ? 15.0f : 26.0f, 0.002f, i, j, onPxW, onPxH, monitorHeight, data.isLoop());
        this.renderPlayProgress(poseStack, multiBufferSource, this.isShortProgressBar(data) ? 48.0f : 12.0f, 28.0f, 0.002f, i, j, onPxW, onPxH, monitorHeight, this.getProgressBarWidth(data), (float)data.getMusicPosition() / (float)this.getPlayBackSource(data).getDuration());
    }
}

