/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen.monitor.boombox;

import com.sedmelluq.discord.lavaplayer.source.youtube.YoutubeAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import dev.felnull.imp.client.gui.IIMPSmartRender;
import dev.felnull.imp.client.gui.components.SmartButton;
import dev.felnull.imp.client.gui.screen.BoomboxScreen;
import dev.felnull.imp.client.gui.screen.monitor.boombox.BoomboxMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.imp.client.lava.LavaPlayerManager;
import dev.felnull.imp.data.BoomboxData;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.MusicSource;
import dev.felnull.imp.util.FlagThread;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_342;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;

public class RadioSelectBMonitor
extends BoomboxMonitor {
    private static final class_2960 RADIO_SELECT_BG_TEXTURE = new class_2960("iammusicplayer", "textures/gui/container/boombox/monitor/radio_select.png");
    private static final class_2960 RADIO_SELECT_IMAGE_BG_TEXTURE = new class_2960("iammusicplayer", "textures/gui/container/boombox/monitor/radio_select_image.png");
    private static final class_2561 RADIO_CHECKING_TEXT = new class_2588("imp.text.radioChecking");
    private static final class_2561 ENTER_STREAM_TEXT = new class_2588("imp.text.enterStream");
    private class_342 radioUrlEditBox;
    private SmartButton radioStreamStartButton;
    private RadioCheckLoader radioCheckLoader;
    private String lastRadioUrl;

    public RadioSelectBMonitor(BoomboxData.MonitorType monitorType, BoomboxScreen screen) {
        super(monitorType, screen);
    }

    @Override
    public void init(int leftPos, int topPos) {
        super.init(leftPos, topPos);
        this.radioUrlEditBox = this.addRenderWidget(new class_342(IIMPSmartRender.mc.field_1772, this.getStartX() + 2, this.getStartY() + this.height - 2 - 12, this.width - 4 - 35, 12, (class_2561)new class_2588("imp.editBox.radioUrl")));
        this.radioUrlEditBox.method_1880(300);
        this.radioUrlEditBox.method_1852(this.getRadioUrl());
        this.radioUrlEditBox.method_1863(this::setRadioUrl);
        this.radioStreamStartButton = this.addRenderWidget(new SmartButton(this.getStartX() + this.width - 34 - 1, this.getStartY() + this.height - 1 - 14, 34, 14, (class_2561)new class_2588("imp.button.radioStreamStart"), n -> this.setMonitor(BoomboxData.MonitorType.RADIO)));
        this.radioStreamStartButton.setHideText(true);
        this.radioStreamStartButton.setIcon(MusicManagerMonitor.WIDGETS_TEXTURE, 19, 123, 17, 8);
        this.radioStreamStartButton.field_22763 = this.canRadioStreamStart();
        this.startRadioCheckLoad(this.getRadioUrl());
    }

    @Override
    public void render(class_4587 poseStack, float f, int mouseX, int mouseY) {
        super.render(poseStack, f, mouseX, mouseY);
        OERenderUtil.drawTexture((class_2960)RADIO_SELECT_BG_TEXTURE, (class_4587)poseStack, (float)this.getStartX(), (float)this.getStartY(), (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height);
        if (this.isRadioChecking()) {
            this.drawSmartText(poseStack, RADIO_CHECKING_TEXT, this.getStartX() + 2, (float)this.getStartY() + ((float)this.height - 1.0f - 14.0f - 6.5f) / 2.0f);
        } else if (!this.getRadioSource().isEmpty()) {
            float st = 2.0f;
            if (!this.getRadioImage().isEmpty()) {
                OERenderUtil.drawTexture((class_2960)RADIO_SELECT_IMAGE_BG_TEXTURE, (class_4587)poseStack, (float)this.getStartX(), (float)this.getStartY(), (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height);
                this.getPlayImageRenderer().draw(this.getRadioImage(), poseStack, this.getStartX() + 1, this.getStartY() + 1, 20);
                st += 21.0f;
            }
            if (!this.getScreen().getBoomBoxData().getRadioName().isEmpty()) {
                this.drawSmartText(poseStack, (class_2561)new class_2585(OERenderUtil.getWidthString((String)this.getScreen().getBoomBoxData().getRadioName(), (float)((float)(this.width - 3) - st), (String)"...")), (float)this.getStartX() + st, this.getStartY() + 2);
            }
            if (!this.getScreen().getBoomBoxData().getRadioAuthor().isEmpty()) {
                class_2588 tx = new class_2588("imp.text.musicAuthor", new Object[]{""});
                this.drawSmartText(poseStack, (class_2561)new class_2588("imp.text.musicAuthor", new Object[]{OERenderUtil.getWidthString((String)this.getScreen().getBoomBoxData().getRadioAuthor(), (float)((float)(this.width - 3) - st - (float)RadioSelectBMonitor.mc.field_1772.method_27525((class_5348)tx)), (String)"...")}), (float)this.getStartX() + st, this.getStartY() + 12);
            }
        } else {
            this.drawSmartText(poseStack, ENTER_STREAM_TEXT, this.getStartX() + 2, (float)this.getStartY() + ((float)this.height - 1.0f - 14.0f - 6.5f) / 2.0f);
        }
    }

    @Override
    public void renderAppearance(class_4587 poseStack, class_4597 multiBufferSource, int i, int j, float f, float monitorWidth, float monitorHeight, BoomboxData data) {
        super.renderAppearance(poseStack, multiBufferSource, i, j, f, monitorWidth, monitorHeight, data);
        OERenderUtil.renderTextureSprite((class_2960)RADIO_SELECT_BG_TEXTURE, (class_4587)poseStack, (class_4597)multiBufferSource, (float)0.0f, (float)0.0f, (float)0.002f, (float)0.0f, (float)0.0f, (float)0.0f, (float)monitorWidth, (float)monitorHeight, (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height, (int)i, (int)j);
        float onPxW = monitorWidth / (float)this.width;
        float onPxH = monitorHeight / (float)this.height;
        if (!this.getRadioSource(data).isEmpty()) {
            float st = 3.0f;
            if (!data.getRadioImage().isEmpty()) {
                OERenderUtil.renderTextureSprite((class_2960)RADIO_SELECT_IMAGE_BG_TEXTURE, (class_4587)poseStack, (class_4597)multiBufferSource, (float)0.0f, (float)0.0f, (float)0.003f, (float)0.0f, (float)0.0f, (float)0.0f, (float)monitorWidth, (float)monitorHeight, (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height, (int)i, (int)j);
                this.renderPlayListImage(poseStack, multiBufferSource, data.getRadioImage(), 1.0f, 1.0f, 0.0050000004f, 20.0f, i, j, onPxW, onPxH, monitorHeight);
                st += 21.0f;
            }
            if (!data.getRadioName().isEmpty()) {
                this.renderSmartTextSprite(poseStack, multiBufferSource, (class_2561)new class_2585(OERenderUtil.getWidthString((String)data.getRadioName(), (float)((float)(this.width - 3) - st), (String)"...")), st, 4.0f, 0.004f, onPxW, onPxH, monitorHeight, i);
            }
            if (!data.getRadioAuthor().isEmpty()) {
                class_2588 tx = new class_2588("imp.text.musicAuthor", new Object[]{""});
                this.renderSmartTextSprite(poseStack, multiBufferSource, (class_2561)new class_2588("imp.text.musicAuthor", new Object[]{OERenderUtil.getWidthString((String)data.getRadioAuthor(), (float)((float)(this.width - 3) - st - (float)RadioSelectBMonitor.mc.field_1772.method_27525((class_5348)tx)), (String)"...")}), st, 14.0f, 0.004f, onPxW, onPxH, monitorHeight, i);
            }
        } else {
            this.renderSmartTextSprite(poseStack, multiBufferSource, ENTER_STREAM_TEXT, 2.0f, ((float)this.height - 1.0f - 14.0f - 6.5f) / 2.0f, 0.004f, onPxW, onPxH, monitorHeight, i);
        }
        this.renderSmartButtonSprite(poseStack, multiBufferSource, this.width - 34 - 1, this.height - 1 - 14, 0.004f, 34.0f, 14.0f, i, j, onPxW, onPxH, monitorHeight, MusicManagerMonitor.WIDGETS_TEXTURE, 19, 123, 17, 8, 256, 256, !this.canRadioStreamStart(data));
        this.renderSmartEditBoxSprite(poseStack, multiBufferSource, 1.0f, this.height - 2 - 12, 0.004f, this.width - 2 - 35, 12.0f, i, j, onPxW, onPxH, monitorHeight, this.getRadioUrl(data));
    }

    @Override
    public void tick() {
        super.tick();
        this.radioStreamStartButton.field_22763 = this.canRadioStreamStart();
    }

    private boolean canRadioStreamStart(BoomboxData data) {
        return !this.getRadioSource(data).isEmpty();
    }

    private boolean canRadioStreamStart() {
        return !this.getRadioSource().isEmpty();
    }

    public void setRadioUrl(String url) {
        this.getScreen().insRadioUrl(url);
        this.startRadioCheckLoad(url);
    }

    private boolean isRadioChecking() {
        return this.radioCheckLoader != null && this.radioCheckLoader.isAlive();
    }

    private void startRadioCheckLoad(String url) {
        if (url.equals(this.lastRadioUrl)) {
            return;
        }
        this.setRadioSource(MusicSource.EMPTY);
        this.setRadioImage(ImageInfo.EMPTY);
        this.lastRadioUrl = url;
        this.stopRadioCheckLoad();
        this.radioCheckLoader = new RadioCheckLoader(url);
        this.radioCheckLoader.start();
    }

    private void stopRadioCheckLoad() {
        if (this.radioCheckLoader != null) {
            this.radioCheckLoader.stopped();
            this.radioCheckLoader = null;
        }
    }

    private void setRadioSource(MusicSource source) {
        this.getScreen().insRadioSource(source);
    }

    private void setRadioImage(ImageInfo image) {
        this.getScreen().insRadioImage(image);
    }

    private void setRadioAuthor(String author) {
        this.getScreen().insRadioAuthor(author);
    }

    private void setRadioName(String name) {
        this.getScreen().insRadioName(name);
    }

    private class RadioCheckLoader
    extends FlagThread {
        private final String url;

        private RadioCheckLoader(String url) {
            this.url = url;
        }

        @Override
        public void run() {
            if (this.isStopped()) {
                return;
            }
            try {
                Optional<AudioTrack> otrack = LavaPlayerManager.getInstance().loadTrack(this.url);
                if (this.isStopped()) {
                    return;
                }
                if (otrack.isPresent()) {
                    AudioTrack track = otrack.get();
                    AudioTrackInfo info = track.getInfo();
                    if (!info.isStream) {
                        return;
                    }
                    if (this.isStopped()) {
                        return;
                    }
                    if (track.getSourceManager() instanceof YoutubeAudioSourceManager) {
                        IIMPSmartRender.mc.method_20493(() -> RadioSelectBMonitor.this.setRadioImage(new ImageInfo(ImageInfo.ImageType.YOUTUBE_THUMBNAIL, info.identifier)));
                    }
                    if (this.isStopped()) {
                        return;
                    }
                    IIMPSmartRender.mc.method_20493(() -> {
                        RadioSelectBMonitor.this.setRadioSource(new MusicSource("", info.identifier, -1L));
                        RadioSelectBMonitor.this.setRadioName(info.title);
                        RadioSelectBMonitor.this.setRadioAuthor(info.author);
                    });
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

