/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen.monitor.cassette_deck;

import dev.architectury.utils.value.BooleanValue;
import dev.architectury.utils.value.FloatValue;
import dev.architectury.utils.value.IntValue;
import dev.felnull.fnjl.util.FNStringUtil;
import dev.felnull.imp.blockentity.CassetteDeckBlockEntity;
import dev.felnull.imp.client.gui.components.LoopControlWidget;
import dev.felnull.imp.client.gui.components.PlayBackControlWidget;
import dev.felnull.imp.client.gui.components.PlayProgressWidget;
import dev.felnull.imp.client.gui.components.SmartButton;
import dev.felnull.imp.client.gui.components.VolumeWidget;
import dev.felnull.imp.client.gui.screen.CassetteDeckScreen;
import dev.felnull.imp.client.gui.screen.monitor.cassette_deck.CassetteDeckMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.imp.item.CassetteTapeItem;
import dev.felnull.imp.music.resource.Music;
import dev.felnull.imp.util.IMPItemUtil;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

public class PlaybackCDMonitor
extends CassetteDeckMonitor {
    protected static final class_2960 PLAYBACK_BG_TEXTURE = new class_2960("iammusicplayer", "textures/gui/container/cassette_deck/monitor/playback.png");
    protected static final class_2960 PLAYBACK_IMAGE_TEXTURE = new class_2960("iammusicplayer", "textures/gui/container/cassette_deck/monitor/playback_image.png");
    private static final class_2561 NO_CASSETTE_TAPE_TEXT = new class_2588("imp.text.noCassetteTape");
    private static final class_2561 NO_MUSIC_CASSETTE_TAPE_TEXT = new class_2588("imp.text.noMusicCassetteTape");
    private static final class_2561 LOADING_MUSIC_TEXT = new class_2588("imp.text.musicLoading");
    private SmartButton backButton;
    private VolumeWidget volumeWidget;
    private PlayBackControlWidget playBackControlWidget;
    private LoopControlWidget loopControlWidget;
    private PlayProgressWidget playProgressWidget;

    public PlaybackCDMonitor(CassetteDeckBlockEntity.MonitorType monitorType, CassetteDeckScreen screen) {
        super(monitorType, screen);
    }

    @Override
    public void init(int leftPos, int topPos) {
        super.init(leftPos, topPos);
        this.backButton = this.addRenderWidget(new SmartButton(this.getStartX() + 1, this.getStartY() + 44, 14, 11, (class_2561)new class_2588("gui.back"), n -> this.insMonitor(CassetteDeckBlockEntity.MonitorType.MENU)));
        this.backButton.setHideText(true);
        this.backButton.setIcon(MusicManagerMonitor.WIDGETS_TEXTURE, 11, 123, 8, 8);
        this.volumeWidget = this.addRenderWidget(new VolumeWidget(this.getStartX() + 168, this.getStartY() + 16, new IntValue(){

            public void accept(int value) {
                PlaybackCDMonitor.this.getScreen().insVolume(value);
            }

            public int getAsInt() {
                return PlaybackCDMonitor.this.getVolume();
            }
        }, () -> this.getScreen().isMute(), n -> this.getScreen().insMute(n)));
        this.volumeWidget.field_22764 = this.isPlayBack();
        this.playBackControlWidget = this.addRenderWidget(new PlayBackControlWidget(this.getStartX() + (this.isShortProgressBar() ? 45 : 2), this.getStartY() + 30, () -> this.getScreen().isPlaying() ? PlayBackControlWidget.StateType.STOP : PlayBackControlWidget.StateType.PLAYING, n -> {
            switch (n) {
                case PLAYING: {
                    this.getScreen().insPlaying(true);
                    break;
                }
                case STOP: {
                    this.getScreen().insPlaying(false);
                    break;
                }
                case PAUSE: {
                    this.getScreen().insPause();
                }
            }
        }));
        this.playBackControlWidget.field_22764 = this.isPlayBack();
        this.loopControlWidget = this.addRenderWidget(new LoopControlWidget(this.getStartX() + 189, this.getStartY() + 31, new BooleanValue(){

            public void accept(boolean t) {
                PlaybackCDMonitor.this.getScreen().insLoop(t);
            }

            public boolean getAsBoolean() {
                return PlaybackCDMonitor.this.getScreen().isLoop();
            }
        }));
        this.loopControlWidget.field_22764 = this.isPlayBack();
        this.playProgressWidget = this.addRenderWidget(new PlayProgressWidget(this.getStartX() + (this.isShortProgressBar() ? 55 : 12), this.getStartY() + 33, this.isShortProgressBar() ? 133 : 176, new FloatValue(){

            public float getAsFloat() {
                Music music;
                if (!PlaybackCDMonitor.this.getCassetteTape().method_7960() && IMPItemUtil.isCassetteTape(PlaybackCDMonitor.this.getCassetteTape()) && (music = CassetteTapeItem.getMusic(PlaybackCDMonitor.this.getCassetteTape())) != null) {
                    return (float)PlaybackCDMonitor.this.getScreen().getPosition() / (float)music.getSource().getDuration();
                }
                return 0.0f;
            }

            public void accept(float t) {
                Music music;
                if (!PlaybackCDMonitor.this.getCassetteTape().method_7960() && IMPItemUtil.isCassetteTape(PlaybackCDMonitor.this.getCassetteTape()) && (music = CassetteTapeItem.getMusic(PlaybackCDMonitor.this.getCassetteTape())) != null) {
                    long vl = (long)((float)music.getSource().getDuration() * t);
                    PlaybackCDMonitor.this.getScreen().insPositionAndRestart(vl);
                }
            }
        }));
        this.playProgressWidget.field_22764 = this.isPlayBack();
    }

    @Override
    public void renderAppearance(CassetteDeckBlockEntity blockEntity, class_4587 poseStack, class_4597 multiBufferSource, int i, int j, float f, float monitorWidth, float monitorHeight) {
        super.renderAppearance(blockEntity, poseStack, multiBufferSource, i, j, f, monitorWidth, monitorHeight);
        float onPxW = monitorWidth / (float)this.width;
        float onPxH = monitorHeight / (float)this.height;
        this.renderSmartButtonSprite(poseStack, multiBufferSource, 1.0f, 44.0f, 0.002f, 14.0f, 11.0f, i, j, onPxW, onPxH, monitorHeight, MusicManagerMonitor.WIDGETS_TEXTURE, 11, 123, 8, 8, 256, 256);
        if (!this.getCassetteTape(blockEntity).method_7960() && IMPItemUtil.isCassetteTape(this.getCassetteTape(blockEntity))) {
            Music music = CassetteTapeItem.getMusic(this.getCassetteTape(blockEntity));
            if (music != null) {
                OERenderUtil.renderTextureSprite((class_2960)PLAYBACK_BG_TEXTURE, (class_4587)poseStack, (class_4597)multiBufferSource, (float)0.0f, (float)0.0f, (float)0.002f, (float)0.0f, (float)0.0f, (float)0.0f, (float)monitorWidth, (float)monitorHeight, (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height, (int)i, (int)j);
                if (!music.getImage().isEmpty()) {
                    OERenderUtil.renderTextureSprite((class_2960)PLAYBACK_IMAGE_TEXTURE, (class_4587)poseStack, (class_4597)multiBufferSource, (float)0.0f, (float)0.0f, (float)0.003f, (float)0.0f, (float)0.0f, (float)0.0f, (float)monitorWidth, (float)monitorHeight, (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height, (int)i, (int)j);
                }
                int sx = 2;
                if (!music.getImage().isEmpty()) {
                    this.renderPlayListImage(poseStack, multiBufferSource, music.getImage(), 1.0f, 1.0f, 0.004f, this.height - 3 - 13, i, j, onPxW, onPxH, monitorHeight);
                    sx += this.height - 2 - 13;
                }
                this.renderSmartCenterTextSprite(poseStack, multiBufferSource, (class_2561)new class_2585(OERenderUtil.getWidthString((String)music.getName(), (float)(this.width - sx - 2), (String)"...")), (float)sx + ((float)(this.width - sx) - 2.0f) / 2.0f, 3.0f, 0.002f, onPxW, onPxH, monitorHeight, i);
                class_2561 ptx = LOADING_MUSIC_TEXT;
                if (!blockEntity.isLoadingMusic()) {
                    ptx = new class_2585(FNStringUtil.getTimeProgress((long)blockEntity.getPosition(), (long)music.getSource().getDuration()));
                }
                this.renderSmartTextSpriteColorSprite(poseStack, multiBufferSource, ptx, 45.0f - (this.isShortProgressBar(blockEntity) ? 0.0f : 43.0f), 17.0f, 0.002f, onPxW, onPxH, monitorHeight, -15639282, i);
                this.renderVolumeSprite(poseStack, multiBufferSource, 168.0f, 16.0f, 0.002f, i, j, onPxW, onPxH, monitorHeight, this.getVolume(blockEntity), this.isMute(blockEntity));
                this.renderPlayBackControl(poseStack, multiBufferSource, this.isShortProgressBar(blockEntity) ? 45.0f : 2.0f, 30.0f, 0.002f, i, j, onPxW, onPxH, monitorHeight, blockEntity.isPlaying() ? PlayBackControlWidget.StateType.STOP : PlayBackControlWidget.StateType.PLAYING);
                this.renderLoopControl(poseStack, multiBufferSource, 189.0f, 31.0f, 0.002f, i, j, onPxW, onPxH, monitorHeight, blockEntity.isLoop());
                this.renderPlayProgress(poseStack, multiBufferSource, this.isShortProgressBar(blockEntity) ? 55.0f : 12.0f, 33.0f, 0.002f, i, j, onPxW, onPxH, monitorHeight, this.isShortProgressBar(blockEntity) ? 133.0f : 176.0f, (float)blockEntity.getPosition() / (float)music.getSource().getDuration());
            } else {
                this.renderSmartCenterTextSprite(poseStack, multiBufferSource, NO_MUSIC_CASSETTE_TAPE_TEXT, (float)this.width / 2.0f, ((float)this.height - 10.0f) / 2.0f, 0.002f, onPxW, onPxH, monitorHeight, i);
            }
        } else {
            this.renderSmartCenterTextSprite(poseStack, multiBufferSource, NO_CASSETTE_TAPE_TEXT, (float)this.width / 2.0f, ((float)this.height - 10.0f) / 2.0f, 0.002f, onPxW, onPxH, monitorHeight, i);
        }
    }

    @Override
    public void render(class_4587 poseStack, float f, int mouseX, int mouseY) {
        super.render(poseStack, f, mouseX, mouseY);
        if (!this.getCassetteTape().method_7960() && IMPItemUtil.isCassetteTape(this.getCassetteTape())) {
            Music music = CassetteTapeItem.getMusic(this.getCassetteTape());
            if (music != null) {
                OERenderUtil.drawTexture((class_2960)PLAYBACK_BG_TEXTURE, (class_4587)poseStack, (float)this.getStartX(), (float)this.getStartY(), (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height);
                if (!music.getImage().isEmpty()) {
                    OERenderUtil.drawTexture((class_2960)PLAYBACK_IMAGE_TEXTURE, (class_4587)poseStack, (float)this.getStartX(), (float)this.getStartY(), (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height);
                }
                int sx = 2;
                if (!music.getImage().isEmpty()) {
                    this.getPlayImageRenderer().draw(music.getImage(), poseStack, this.getStartX() + 1, this.getStartY() + 1, this.height - 2 - 13);
                    sx += this.height - 2 - 13;
                }
                this.drawSmartCenterText(poseStack, (class_2561)new class_2585(OERenderUtil.getWidthString((String)music.getName(), (float)(this.width - sx - 2), (String)"...")), (float)(this.getStartX() + sx) + ((float)(this.width - sx) - 2.0f) / 2.0f, this.getStartY() + 3);
                class_2561 ptx = LOADING_MUSIC_TEXT;
                if (!this.getScreen().isLoading()) {
                    ptx = new class_2585(FNStringUtil.getTimeProgress((long)this.getScreen().getPosition(), (long)music.getSource().getDuration()));
                }
                this.drawSmartText(poseStack, ptx, this.getStartX() + 45 - (this.isShortProgressBar() ? 0 : 43), this.getStartY() + 17, -15639282);
            } else {
                this.drawSmartCenterText(poseStack, NO_MUSIC_CASSETTE_TAPE_TEXT, (float)this.getStartX() + (float)this.width / 2.0f, (float)this.getStartY() + ((float)this.height - 10.0f) / 2.0f);
            }
        } else {
            this.drawSmartCenterText(poseStack, NO_CASSETTE_TAPE_TEXT, (float)this.getStartX() + (float)this.width / 2.0f, (float)this.getStartY() + ((float)this.height - 10.0f) / 2.0f);
        }
    }

    @Override
    public void tick() {
        super.tick();
        this.volumeWidget.field_22764 = this.isPlayBack();
        this.playBackControlWidget.field_22764 = this.isPlayBack();
        this.playBackControlWidget.field_22760 = this.getStartX() + (this.isShortProgressBar() ? 45 : 2);
        this.loopControlWidget.field_22764 = this.isPlayBack();
        this.playProgressWidget.field_22764 = this.isPlayBack();
        this.playProgressWidget.method_25358(this.isShortProgressBar() ? 133 : 176);
        this.playProgressWidget.field_22760 = this.getStartX() + (this.isShortProgressBar() ? 55 : 12);
    }

    private boolean isShortProgressBar(CassetteDeckBlockEntity blockEntity) {
        Music m;
        if (!this.getCassetteTape(blockEntity).method_7960() && IMPItemUtil.isCassetteTape(this.getCassetteTape(blockEntity)) && (m = CassetteTapeItem.getMusic(this.getCassetteTape(blockEntity))) != null) {
            return !m.getImage().isEmpty();
        }
        return false;
    }

    private boolean isShortProgressBar() {
        Music m;
        if (!this.getCassetteTape().method_7960() && IMPItemUtil.isCassetteTape(this.getCassetteTape()) && (m = CassetteTapeItem.getMusic(this.getCassetteTape())) != null) {
            return !m.getImage().isEmpty();
        }
        return false;
    }

    private boolean isPlayBack() {
        if (!this.getCassetteTape().method_7960() && IMPItemUtil.isCassetteTape(this.getCassetteTape())) {
            return CassetteTapeItem.getMusic(this.getCassetteTape()) != null;
        }
        return false;
    }
}

