/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen.monitor.music_manager;

import dev.felnull.imp.blockentity.MusicManagerBlockEntity;
import dev.felnull.imp.client.gui.components.SmartButton;
import dev.felnull.imp.client.gui.screen.MusicManagerScreen;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.ImageNameBaseMMMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicBaseMMMonitor;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.Music;
import dev.felnull.imp.music.resource.MusicPlayList;
import dev.felnull.imp.music.resource.MusicSource;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DetailMusicMMMonitor
extends MusicBaseMMMonitor {
    private static final class_2561 EDIT_TEXT = new class_2588("imp.button.edit");
    private static final class_2561 DELETE_TEXT = new class_2588("imp.button.delete").method_27692(class_124.field_1079);
    private SmartButton editButton;
    private SmartButton deleteButton;
    private String cashName;

    public DetailMusicMMMonitor(MusicManagerBlockEntity.MonitorType type, MusicManagerScreen screen) {
        super(type, screen);
        this.locked();
    }

    @Override
    public void init(int leftPos, int topPos) {
        super.init(leftPos, topPos);
        this.editButton = this.addRenderWidget(new SmartButton(this.getStartX() + this.width - 95 - 87, this.getStartY() + 180, 87, 15, EDIT_TEXT, n -> this.insMonitor(MusicManagerBlockEntity.MonitorType.EDIT_MUSIC)));
        this.editButton.field_22764 = this.canEdit();
        this.deleteButton = this.addRenderWidget(new SmartButton(this.getStartX() + this.width - 5 - 87, this.getStartY() + 180, 87, 15, DELETE_TEXT, n -> this.insMonitor(MusicManagerBlockEntity.MonitorType.DELETE_MUSIC)));
        this.deleteButton.field_22764 = this.canDelete();
        this.cashName = this.getName();
    }

    @Override
    public void renderAppearance(MusicManagerBlockEntity blockEntity, class_4587 poseStack, class_4597 multiBufferSource, int i, int j, float f, float monitorWidth, float monitorHeight) {
        super.renderAppearance(blockEntity, poseStack, multiBufferSource, i, j, f, monitorWidth, monitorHeight);
        float onPxW = monitorWidth / (float)this.width;
        float onPxH = monitorHeight / (float)this.height;
        if (this.canEdit(blockEntity)) {
            this.renderSmartButtonSprite(poseStack, multiBufferSource, this.width - 95 - 87, 180.0f, 0.002f, 87.0f, 15.0f, i, j, onPxW, onPxH, monitorHeight, EDIT_TEXT, true);
        }
        if (this.canDelete(blockEntity)) {
            this.renderSmartButtonSprite(poseStack, multiBufferSource, this.width - 5 - 87, 180.0f, 0.002f, 87.0f, 15.0f, i, j, onPxW, onPxH, monitorHeight, DELETE_TEXT, true);
        }
    }

    @Override
    public boolean done(ImageInfo imageInfo, String name) {
        this.setSelectedMusic(null);
        return true;
    }

    @Override
    public void tick() {
        super.tick();
        this.editButton.field_22764 = this.canEdit();
        this.deleteButton.field_22764 = this.canDelete();
        if (!this.cashName.equals(this.getName())) {
            this.cashName = this.getName();
            this.nameEditBox.method_1852(this.cashName);
        }
    }

    @Override
    @Nullable
    protected ImageNameBaseMMMonitor.DoneType getDoneType() {
        return null;
    }

    private boolean canEdit(MusicManagerBlockEntity musicManagerBlockEntity) {
        Music m = this.getSelectedMusic(musicManagerBlockEntity);
        return m != null && m.getOwner().equals(DetailMusicMMMonitor.mc.field_1724.method_7334().getId());
    }

    private boolean canDelete(MusicManagerBlockEntity musicManagerBlockEntity) {
        MusicPlayList pl = this.getSelectedMusicPlayList(musicManagerBlockEntity);
        Music m = this.getSelectedMusic(musicManagerBlockEntity);
        return pl != null && pl.getAuthority().getAuthorityType(DetailMusicMMMonitor.mc.field_1724.method_7334().getId()).canMusicDelete() || m != null && m.getOwner().equals(DetailMusicMMMonitor.mc.field_1724.method_7334().getId());
    }

    private boolean canEdit() {
        Music m = this.getSelectedMusic();
        return m != null && m.getOwner().equals(DetailMusicMMMonitor.mc.field_1724.method_7334().getId());
    }

    private boolean canDelete() {
        MusicPlayList pl = this.getSelectedMusicPlayList();
        Music m = this.getSelectedMusic();
        return pl != null && pl.getAuthority().getAuthorityType(DetailMusicMMMonitor.mc.field_1724.method_7334().getId()).canMusicDelete() || m != null && m.getOwner().equals(DetailMusicMMMonitor.mc.field_1724.method_7334().getId());
    }

    @Override
    @NotNull
    protected String getMusicAuthor(@NotNull MusicManagerBlockEntity musicManagerBlockEntity) {
        Music m = this.getSelectedMusic(musicManagerBlockEntity);
        if (m != null) {
            return m.getAuthor();
        }
        return "";
    }

    @Override
    @Nullable
    protected MusicManagerBlockEntity.MonitorType getParentType() {
        return MusicManagerBlockEntity.MonitorType.PLAY_LIST;
    }

    @Override
    @NotNull
    protected String getMusicLoaderType(@NotNull MusicManagerBlockEntity musicManagerBlockEntity) {
        Music m = this.getSelectedMusic(musicManagerBlockEntity);
        if (m != null) {
            return m.getSource().getLoaderType();
        }
        return "";
    }

    @Override
    @NotNull
    protected ImageInfo getImage(MusicManagerBlockEntity musicManagerBlockEntity) {
        Music m = this.getSelectedMusic(musicManagerBlockEntity);
        if (m != null) {
            return m.getImage();
        }
        return ImageInfo.EMPTY;
    }

    @Override
    @NotNull
    protected String getName(@NotNull MusicManagerBlockEntity musicManagerBlockEntity) {
        Music m = this.getSelectedMusic(musicManagerBlockEntity);
        if (m != null) {
            return m.getName();
        }
        return "";
    }

    @Override
    @NotNull
    protected MusicSource getMusicSource(@NotNull MusicManagerBlockEntity blockEntity) {
        Music m = this.getSelectedMusic(blockEntity);
        if (m != null) {
            return m.getSource();
        }
        return MusicSource.EMPTY;
    }

    private void setSelectedMusic(@Nullable UUID uuid) {
        this.getScreen().insSelectedMusic(uuid);
    }

    @Nullable
    private Music getSelectedMusic() {
        class_2586 class_25862 = this.getScreen().getBlockEntity();
        if (class_25862 instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)class_25862;
            return this.getSelectedMusic(musicManagerBlockEntity);
        }
        return null;
    }

    @Nullable
    private Music getSelectedMusic(MusicManagerBlockEntity musicManagerBlockEntity) {
        List<Music> sms;
        UUID id = this.getSelectedMusicRaw(musicManagerBlockEntity);
        UUID pl = this.getSelectedPlayList(musicManagerBlockEntity);
        if (id != null && pl != null && (sms = this.getSyncManager().getMusics(pl)) != null) {
            return sms.stream().filter(n -> id.equals(n.getUuid())).findFirst().orElse(null);
        }
        return null;
    }

    @Nullable
    private UUID getSelectedMusicRaw() {
        class_2586 class_25862 = this.getScreen().getBlockEntity();
        if (class_25862 instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)class_25862;
            return this.getSelectedMusicRaw(musicManagerBlockEntity);
        }
        return null;
    }

    @Nullable
    private UUID getSelectedMusicRaw(MusicManagerBlockEntity musicManagerBlockEntity) {
        return musicManagerBlockEntity.getMySelectedMusic();
    }

    protected MusicPlayList getSelectedMusicPlayList() {
        class_2586 class_25862 = this.getScreen().getBlockEntity();
        if (class_25862 instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)class_25862;
            return this.getSelectedMusicPlayList(musicManagerBlockEntity);
        }
        return null;
    }

    protected MusicPlayList getSelectedMusicPlayList(MusicManagerBlockEntity musicManagerBlockEntity) {
        List<MusicPlayList> pls = this.getSyncManager().getMyPlayList();
        if (pls == null) {
            return null;
        }
        return this.getSyncManager().getMyPlayList().stream().filter(n -> n.getUuid().equals(this.getSelectedPlayList(musicManagerBlockEntity))).findFirst().orElse(null);
    }

    @Nullable
    protected UUID getSelectedPlayList() {
        class_2586 class_25862 = this.getScreen().getBlockEntity();
        if (class_25862 instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlockEntity = (MusicManagerBlockEntity)class_25862;
            return this.getSelectedPlayList(musicManagerBlockEntity);
        }
        return null;
    }

    @Nullable
    private UUID getSelectedPlayList(MusicManagerBlockEntity musicManagerBlockEntity) {
        return musicManagerBlockEntity.getMySelectedPlayList();
    }
}

