/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.lava;

import com.sedmelluq.lava.common.natives.NativeLibraryProperties;
import com.sedmelluq.lava.common.natives.architecture.SystemType;
import dev.felnull.imp.client.lava.LavaNativeManager;
import dev.felnull.imp.client.lava.LavaPlayerLoader;
import java.nio.file.Path;
import java.util.function.Predicate;

public class IMPSystemNativeLibraryProperties
implements NativeLibraryProperties {
    private final Predicate<SystemType> systemFilter;
    private final String libraryName;

    public IMPSystemNativeLibraryProperties(String libraryName, Predicate<SystemType> systemFilter) {
        this.systemFilter = systemFilter;
        this.libraryName = libraryName;
    }

    public String getLibraryPath() {
        return null;
    }

    public String getLibraryDirectory() {
        SystemType sys = IMPSystemNativeLibraryProperties.detectMatchingSystemType(this, this.systemFilter);
        if (sys == null) {
            throw new IllegalStateException("System type is null");
        }
        String natName = sys.osType.identifier() + "-" + sys.architectureType.identifier();
        boolean ret = LavaNativeManager.getInstance().load(natName, sys.formatLibraryName(this.libraryName));
        if (!ret) {
            throw new UnsatisfiedLinkError("Failed to load the library");
        }
        Path p = LavaPlayerLoader.getNaiveLibraryFolder().resolve(natName);
        return p.toAbsolutePath().toString();
    }

    public String getExtractionPath() {
        return null;
    }

    public String getSystemName() {
        return null;
    }

    public String getLibraryFileNamePrefix() {
        return null;
    }

    public String getLibraryFileNameSuffix() {
        return null;
    }

    public String getArchitectureName() {
        return null;
    }

    private static SystemType detectMatchingSystemType(NativeLibraryProperties properties, Predicate<SystemType> systemFilter) {
        SystemType systemType;
        try {
            systemType = SystemType.detect((NativeLibraryProperties)properties);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        if (systemFilter != null && !systemFilter.test(systemType)) {
            return null;
        }
        return systemType;
    }
}

