/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.neteasecloudmusic;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.felnull.fnjl.util.FNStringUtil;
import dev.felnull.fnjl.util.FNURLUtil;
import dev.felnull.imp.IamMusicPlayer;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.tuple.Pair;

public class NetEaseCloudMusicManager {
    private static final NetEaseCloudMusicManager INSTANCE = new NetEaseCloudMusicManager();
    private static final String BUILD_IN_API_URL = "https://api.felnull.dev/netease-cloud-music-api/";
    private static final String API_VERSION = "1";
    private static final Gson GSON = new Gson();
    private final AtomicBoolean init = new AtomicBoolean();
    private String apiURL = null;

    public static NetEaseCloudMusicManager getInstance() {
        return INSTANCE;
    }

    public void reload() {
        this.init.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        AtomicBoolean atomicBoolean = this.init;
        synchronized (atomicBoolean) {
            if (!this.init.compareAndSet(false, true)) {
                return;
            }
            String curl = IamMusicPlayer.CONFIG.neteaseCloudMusicApiURL;
            try {
                String ret = this.jsonCheck(curl);
                if (ret != null) {
                    curl = ret;
                }
            }
            catch (Exception ret) {
                // empty catch block
            }
            try {
                FNURLUtil.getResponse((URL)new URL(curl));
            }
            catch (IOException e) {
                curl = BUILD_IN_API_URL;
            }
            this.apiURL = curl;
        }
    }

    private String jsonCheck(String url) throws Exception {
        JsonObject jo;
        try (InputStream stream = FNURLUtil.getStream((URL)new URL(url));
             BufferedInputStream bufStream = new BufferedInputStream(stream);
             InputStreamReader reader = new InputStreamReader((InputStream)bufStream, StandardCharsets.UTF_8);){
            jo = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
        }
        JsonObject jao = jo.getAsJsonObject("netease_cloud_music_api");
        JsonElement jaeo = jao.get(API_VERSION);
        if (jaeo == null || !jaeo.isJsonPrimitive() || !jaeo.getAsJsonPrimitive().isString()) {
            return null;
        }
        return jaeo.getAsString();
    }

    public String getMp3Url(String songId) throws IOException {
        JsonObject jo;
        this.init();
        String urlStr = FNStringUtil.urlConcatenation((String)this.apiURL, (String)("/song/url?id=" + songId));
        try (InputStream stream = FNURLUtil.getStream((URL)new URL(urlStr));
             BufferedInputStream bufStream = new BufferedInputStream(stream);
             InputStreamReader reader = new InputStreamReader((InputStream)bufStream, StandardCharsets.UTF_8);){
            jo = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
        }
        JsonArray data = jo.getAsJsonArray("data");
        if (data.isEmpty()) {
            return null;
        }
        JsonObject entry = data.get(0).getAsJsonObject();
        return entry.get("url").getAsString();
    }

    public JsonObject getSongJson(String songId) throws IOException {
        JsonObject jo;
        this.init();
        String urlStr = FNStringUtil.urlConcatenation((String)this.apiURL, (String)("/song/detail?ids=" + songId));
        try (InputStream stream = FNURLUtil.getStream((URL)new URL(urlStr));
             BufferedInputStream bufStream = new BufferedInputStream(stream);
             InputStreamReader reader = new InputStreamReader((InputStream)bufStream, StandardCharsets.UTF_8);){
            jo = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
        }
        JsonArray songs = jo.getAsJsonArray("songs");
        if (songs.isEmpty()) {
            throw new IllegalArgumentException("Song not found");
        }
        return songs.get(0).getAsJsonObject();
    }

    public String getPictureURL(JsonObject songJson) {
        JsonObject ajo = songJson.getAsJsonObject("al");
        return ajo.get("picUrl").getAsString();
    }

    public Pair<String, List<String>> getNameAndArtist(JsonObject songJson) {
        JsonObject aljo = songJson.getAsJsonObject("al");
        String name = aljo.get("name").getAsString();
        ArrayList<String> artists = new ArrayList<String>();
        JsonArray arjo = songJson.getAsJsonArray("ar");
        for (JsonElement jo : arjo) {
            artists.add(jo.getAsJsonObject().get("name").getAsString());
        }
        return Pair.of((Object)name, artists);
    }

    public List<JsonObject> getSearchSongs(String text) throws IOException, URISyntaxException {
        JsonObject jo;
        this.init();
        text = URLEncoder.encode(text, StandardCharsets.UTF_8);
        text = new URI(text).toASCIIString();
        String urlStr = FNStringUtil.urlConcatenation((String)this.apiURL, (String)("/cloudsearch?keywords=" + text));
        try (InputStream stream = FNURLUtil.getStream((URL)new URL(urlStr));
             BufferedInputStream bufStream = new BufferedInputStream(stream);
             InputStreamReader reader = new InputStreamReader((InputStream)bufStream, StandardCharsets.UTF_8);){
            jo = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
        }
        JsonObject rj = jo.getAsJsonObject("result");
        if (rj == null) {
            return new ArrayList<JsonObject>();
        }
        JsonArray sj = rj.getAsJsonArray("songs");
        if (sj == null) {
            return new ArrayList<JsonObject>();
        }
        ArrayList<JsonObject> ret = new ArrayList<JsonObject>();
        for (JsonElement je : sj) {
            ret.add(je.getAsJsonObject());
        }
        return ret;
    }
}

