package dev.felnull.imp.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.felnull.imp.client.gui.screen.IMPBaseContainerScreen;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_344;
import net.minecraft.class_4587;
import net.minecraft.class_757;

public class PowerButton extends class_344 {
    private final IMPBaseContainerScreen<?> screen;
    private final class_2960 resourceLocation;
    private final int xTexStart;
    private final int yTexStart;
    private final int textureWidth;
    private final int textureHeight;

    public PowerButton(IMPBaseContainerScreen<?> screen, int x, int y, int width, int height, int xTexStart, int yTexStart, class_2960 resourceLocation, int textureWidth, int textureHeight) {
        super(x, y, width, height, xTexStart, yTexStart, height, resourceLocation, textureWidth, textureHeight, button -> onPower(screen), class_2561.method_43471("imp.button.power"));
        this.screen = screen;
        this.field_2127 = resourceLocation;
        this.field_2126 = xTexStart;
        this.field_2125 = yTexStart;
        this.field_2124 = textureWidth;
        this.field_19080 = textureHeight;
    }

    @Override
    public void method_48579(class_4587 poseStack, int i, int j, float f) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture(0, this.field_2127);
        int tx = this.field_2126;
        int ty = this.field_2125;

        if (this.method_25367())
            ty += this.field_22759;

        if (screen.isPowered())
            tx += this.field_22758;

        RenderSystem.enableDepthTest();
        method_25290(poseStack, this.method_46426(), this.method_46427(), (float) tx, (float) ty, this.field_22758, this.field_22759, this.field_2124, this.field_19080);
        /*if (this.isHoveredOrFocused())
            this.renderToolTip(poseStack, i, j);*/
    }

    private static void onPower(IMPBaseContainerScreen<?> screen) {
        screen.insPower(!screen.isPowered());
    }
}
