package dev.felnull.imp.entity.village;

import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.felnull.fnjl.util.FNDataUtil;
import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.block.IMPBlocks;
import dev.felnull.otyacraftengine.util.OERegisterUtils;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2248;
import net.minecraft.class_4158;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class IMPPoiType {
    private static final DeferredRegister<class_4158> POI_TYPES = DeferredRegister.create(IamMusicPlayer.MODID, class_7924.field_41212);
    private static final Function<class_4158, class_5321<class_4158>> RESOURCE_KEY_CACHE = FNDataUtil.memoize(poi -> class_7923.field_41128.method_29113(poi).orElseThrow());

    public static final RegistrySupplier<class_4158> DJ = register("dj", IMPBlocks.BOOMBOX, 1, 1);

    private static RegistrySupplier<class_4158> register(String name, Supplier<class_2248> block, int maxTickets, int validRange) {
        return POI_TYPES.register(name, () -> new class_4158(OERegisterUtils.getPoiTypeBlockStates(block.get()), maxTickets, validRange));
    }

    public static class_5321<class_4158> getResourceKey(class_4158 poiType) {
        return RESOURCE_KEY_CACHE.apply(poiType);
    }

    public static void init() {
        POI_TYPES.register();
        OERegisterUtils.registerPoiTypeBlockStates(DJ);
    }
}
