package dev.felnull.imp.client.music.media;

import MusicMediaResult;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.client.lava.LavaPlayerManager;
import dev.felnull.imp.music.resource.ImageInfo;
import dev.felnull.imp.music.resource.MusicSource;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public abstract class LavaPlayerBaseMusicMedia implements MusicMedia {
    private static final class_2561 ENTER_TEXT = class_2561.method_43471("imp.text.enterText.default");
    private final String name;
    private final class_2561 componentName;
    private final class_2960 icon;

    protected LavaPlayerBaseMusicMedia(String name) {
        this.name = name;
        this.componentName = class_2561.method_43471("imp.loaderType." + name);
        var il = new class_2960(IamMusicPlayer.MODID, "textures/gui/container/music_manager/loader_types/" + name + ".png");
        this.icon = il;
    }

    abstract public void registerSourceManager(AudioPlayerManager audioPlayerManager);

    @Override
    public class_2561 getMediaName() {
        return componentName;
    }

    @Override
    public class_2561 getEnterText() {
        return ENTER_TEXT;
    }

    @Override
    public class_2960 getIcon() {
        return icon;
    }

    @Override
    public MusicMediaResult load(String sourceName) throws Exception {
        var lm = LavaPlayerManager.getInstance();

        var otrack = lm.loadTrack(sourceName);
        if (otrack.isPresent() && !match(otrack.get()))
            return null;

        if (otrack.isPresent() && !otrack.get().getInfo().isStream)
            return createResult(otrack.get());
        return null;
    }

    public MusicMediaResult createResult(AudioTrack track) {
        var ms = new MusicSource(name, getIdentifier(track), track.getDuration());
        return new MusicMediaResult(ms, createThumbnail(track), track.getInfo().title, track.getInfo().author);
    }

    protected ImageInfo createThumbnail(AudioTrack track) {
        return null;
    }

    protected String getIdentifier(AudioTrack track) {
        return track.getIdentifier();
    }

    abstract public boolean match(AudioTrack track);

    public int priority() {
        return 0;
    }
}
