/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.gui.screen.monitor.music_manager;

import com.google.common.collect.ImmutableSet;
import dev.felnull.imp.blockentity.MusicManagerBlockEntity;
import dev.felnull.imp.client.gui.IIMPSmartRender;
import dev.felnull.imp.client.gui.components.PlayersFixedButtonsList;
import dev.felnull.imp.client.gui.components.SmartButton;
import dev.felnull.imp.client.gui.components.SmartRadioButton;
import dev.felnull.imp.client.gui.screen.MusicManagerScreen;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.MusicManagerMonitor;
import dev.felnull.imp.client.gui.screen.monitor.music_manager.PlayListBaseMMMonitor;
import dev.felnull.otyacraftengine.client.gui.components.FixedButtonsList;
import dev.felnull.otyacraftengine.client.gui.components.RadioButtonV2;
import dev.felnull.otyacraftengine.client.util.OEClientUtil;
import dev.felnull.otyacraftengine.client.util.OERenderUtil;
import dev.felnull.otyacraftengine.util.OEPlayerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_342;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SavedPlayListBaseMMMonitor
extends PlayListBaseMMMonitor {
    private static final class_2960 CREATE_PLAYLIST_TEXTURE = new class_2960("iammusicplayer", "textures/gui/container/music_manager/monitor/create_play_list.png");
    private static final class_2561 INVITE_TEXT = new class_2588("imp.text.invite");
    private static final class_2561 INVITE_PLAYER_BY_MCID_OR_UUID_TEXT = new class_2588("imp.text.invitePlayerByMCIDOrUUID");
    private static final class_2561 UNINVITED_TEXT = new class_2588("imp.text.uninvited");
    private static final class_2561 INVITED_TEXT = new class_2588("imp.text.invited");
    private final List<UUID> onlinePlayers = new ArrayList<UUID>();
    private final List<UUID> invitePlayers = new ArrayList<UUID>();
    private class_342 invitePlayerByNameEditBox;
    private SmartButton addInvitePlayerButton;
    private SmartRadioButton publicRadio;
    private SmartRadioButton privateRadio;
    private SmartRadioButton initAuthReadOnlyRadio;
    private SmartRadioButton initAuthMemberRadio;
    private PlayerUUIDLoadThread playerUUIDLoadThread;

    public SavedPlayListBaseMMMonitor(MusicManagerBlockEntity.MonitorType type, MusicManagerScreen screen) {
        super(type, screen);
    }

    @Override
    public void init(int leftPos, int topPos) {
        super.init(leftPos, topPos);
        Supplier<Set<RadioButtonV2>> pRdos = () -> ImmutableSet.of((Object)this.publicRadio, (Object)this.privateRadio);
        this.publicRadio = this.addRenderWidget(new SmartRadioButton(this.getStartX() + 5, this.getStartY() + 140, PUBLIC_RDO_TEXT, n -> this.setPublishingType(PlayListBaseMMMonitor.PublishingType.PUBLIC), pRdos));
        this.publicRadio.setChecked(this.getPublishingType() == PlayListBaseMMMonitor.PublishingType.PUBLIC);
        this.privateRadio = this.addRenderWidget(new SmartRadioButton(this.getStartX() + 95, this.getStartY() + 140, PRIVATE_RDO_TEXT, n -> this.setPublishingType(PlayListBaseMMMonitor.PublishingType.PRIVATE), pRdos));
        this.privateRadio.setChecked(this.getPublishingType() == PlayListBaseMMMonitor.PublishingType.PRIVATE);
        Supplier<Set<RadioButtonV2>> iRdos = () -> ImmutableSet.of((Object)this.initAuthReadOnlyRadio, (Object)this.initAuthMemberRadio);
        this.initAuthReadOnlyRadio = this.addRenderWidget(new SmartRadioButton(this.getStartX() + 189, this.getStartY() + 140, READONLY_RDO_TEXT, n -> this.setInitialAuthority(PlayListBaseMMMonitor.InitialAuthorityType.READ_ONLY), iRdos));
        this.initAuthReadOnlyRadio.setChecked(this.getInitialAuthorityType() == PlayListBaseMMMonitor.InitialAuthorityType.READ_ONLY);
        this.initAuthMemberRadio = this.addRenderWidget(new SmartRadioButton(this.getStartX() + 279, this.getStartY() + 140, MEMBER_RDO_TEXT, n -> this.setInitialAuthority(PlayListBaseMMMonitor.InitialAuthorityType.MEMBER), iRdos));
        this.initAuthMemberRadio.setChecked(this.getInitialAuthorityType() == PlayListBaseMMMonitor.InitialAuthorityType.MEMBER);
        this.invitePlayerByNameEditBox = new class_342(IIMPSmartRender.mc.field_1772, this.getStartX() + 189, this.getStartY() + 112, 141, 12, (class_2561)new class_2588("imp.editBox.invitePlayerByName"));
        this.invitePlayerByNameEditBox.method_1880(300);
        this.invitePlayerByNameEditBox.method_1852(this.getInvitePlayerName());
        this.invitePlayerByNameEditBox.method_1863(this::setInvitePlayerName);
        this.addRenderWidget(this.invitePlayerByNameEditBox);
        this.addInvitePlayerButton = this.addRenderWidget(new SmartButton(this.getStartX() + 333, this.getStartY() + 111, 33, 14, (class_2561)new class_2588("imp.button.addInvitePlayer"), n -> {
            this.startPlayerUUIDLoad(this.invitePlayerByNameEditBox.method_1882());
            this.invitePlayerByNameEditBox.method_1852("");
        }));
        this.addInvitePlayerButton.setIcon(MusicManagerMonitor.WIDGETS_TEXTURE, 106, 19, 11, 11);
        this.addInvitePlayerButton.setHideText(true);
        this.addRenderWidget(new PlayersFixedButtonsList(this.getStartX() + 189, this.getStartY() + 23, 87, 65, 5, (class_2561)new class_2588("imp.fixedList.onlinePlayers"), this.onlinePlayers, (FixedButtonsList.PressEntry<UUID>)((FixedButtonsList.PressEntry)(fixedButtonsList, uuid, i, i1) -> this.addInvitePlayer((UUID)uuid))));
        this.addRenderWidget(new PlayersFixedButtonsList(this.getStartX() + 278, this.getStartY() + 23, 87, 65, 5, (class_2561)new class_2588("imp.fixedList.invitePlayers"), this.invitePlayers, (FixedButtonsList.PressEntry<UUID>)((FixedButtonsList.PressEntry)(fixedButtonsList, uuid, i, i1) -> this.removeInvitePlayer((UUID)uuid))));
    }

    @Override
    public boolean canDone(MusicManagerBlockEntity blockEntity) {
        return super.canDone(blockEntity) && this.getPublishingType(blockEntity) != null && this.getInitialAuthorityType(blockEntity) != null;
    }

    @Override
    public List<class_2561> getNotEntered(List<class_2561> names, MusicManagerBlockEntity blockEntity) {
        if (this.getPublishingType(blockEntity) == null) {
            names.add(PUBLIC_ST_TEXT);
        }
        if (this.getInitialAuthorityType(blockEntity) == null) {
            names.add(INITIAL_AUTHORITY_TEXT);
        }
        return super.getNotEntered(names, blockEntity);
    }

    @Override
    public void render(class_4587 poseStack, float f, int mouseX, int mouseY) {
        super.render(poseStack, f, mouseX, mouseY);
        OERenderUtil.drawTexture((class_2960)CREATE_PLAYLIST_TEXTURE, (class_4587)poseStack, (float)this.getStartX(), (float)this.getStartY(), (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height);
        this.drawSmartText(poseStack, INVITE_PLAYER_BY_MCID_OR_UUID_TEXT, this.getStartX() + 189, this.getStartY() + 102);
        this.drawSmartCenterText(poseStack, UNINVITED_TEXT, this.getStartX() + 230, this.getStartY() + 90);
        this.drawSmartCenterText(poseStack, INVITED_TEXT, this.getStartX() + 312, this.getStartY() + 90);
    }

    @Override
    protected class_2561 getPlayerListName() {
        return INVITE_TEXT;
    }

    @Override
    public void renderAppearance(MusicManagerBlockEntity blockEntity, class_4587 poseStack, class_4597 multiBufferSource, int i, int j, float f, float monitorWidth, float monitorHeight) {
        super.renderAppearance(blockEntity, poseStack, multiBufferSource, i, j, f, monitorWidth, monitorHeight);
        float onPxW = monitorWidth / (float)this.width;
        float onPxH = monitorHeight / (float)this.height;
        this.renderSmartRadioButtonSprite(poseStack, multiBufferSource, 5.0f, 140.0f, 0.004f, 20.0f, 20.0f, i, j, onPxW, onPxH, monitorHeight, PUBLIC_RDO_TEXT, this.getPublishingType(blockEntity) == PlayListBaseMMMonitor.PublishingType.PUBLIC);
        this.renderSmartRadioButtonSprite(poseStack, multiBufferSource, 95.0f, 140.0f, 0.004f, 20.0f, 20.0f, i, j, onPxW, onPxH, monitorHeight, PRIVATE_RDO_TEXT, this.getPublishingType(blockEntity) == PlayListBaseMMMonitor.PublishingType.PRIVATE);
        this.renderSmartRadioButtonSprite(poseStack, multiBufferSource, 189.0f, 140.0f, 0.004f, 20.0f, 20.0f, i, j, onPxW, onPxH, monitorHeight, READONLY_RDO_TEXT, this.getInitialAuthorityType(blockEntity) == PlayListBaseMMMonitor.InitialAuthorityType.READ_ONLY);
        this.renderSmartRadioButtonSprite(poseStack, multiBufferSource, 279.0f, 140.0f, 0.004f, 20.0f, 20.0f, i, j, onPxW, onPxH, monitorHeight, MEMBER_RDO_TEXT, this.getInitialAuthorityType(blockEntity) == PlayListBaseMMMonitor.InitialAuthorityType.MEMBER);
        OERenderUtil.renderTextureSprite((class_2960)CREATE_PLAYLIST_TEXTURE, (class_4587)poseStack, (class_4597)multiBufferSource, (float)0.0f, (float)0.0f, (float)0.003f, (float)0.0f, (float)0.0f, (float)0.0f, (float)monitorWidth, (float)monitorHeight, (float)0.0f, (float)0.0f, (float)this.width, (float)this.height, (float)this.width, (float)this.height, (int)i, (int)j);
        this.renderSmartCenterTextSprite(poseStack, multiBufferSource, UNINVITED_TEXT, 230.0f, 91.0f, 0.003f, onPxW, onPxH, monitorHeight, i);
        this.renderSmartCenterTextSprite(poseStack, multiBufferSource, INVITED_TEXT, 312.0f, 91.0f, 0.003f, onPxW, onPxH, monitorHeight, i);
        this.renderSmartTextSprite(poseStack, multiBufferSource, INVITE_PLAYER_BY_MCID_OR_UUID_TEXT, 189.0f, 102.0f, 0.004f, onPxW, onPxH, monitorHeight, i);
        this.renderSmartEditBoxSprite(poseStack, multiBufferSource, 189.0f, 112.0f, 0.004f, 141.0f, 12.0f, i, j, onPxW, onPxH, monitorHeight, this.getInvitePlayerName(blockEntity));
        this.renderSmartButtonSprite(poseStack, multiBufferSource, 333.0f, 111.0f, 0.004f, 33.0f, 14.0f, i, j, onPxW, onPxH, monitorHeight, MusicManagerMonitor.WIDGETS_TEXTURE, 106, 19, 11, 11, 256, 256);
        ArrayList opl = new ArrayList(IIMPSmartRender.mc.field_1724.field_3944.method_31363());
        opl.remove(IIMPSmartRender.mc.field_1724.method_7334().getId());
        opl.removeAll(this.getInvitePlayers(blockEntity));
        Collection<UUID> ep = this.excludeInvitePlayers(blockEntity);
        if (ep != null) {
            opl.removeAll(this.excludeInvitePlayers(blockEntity));
        }
        for (int k = 0; k < Math.min(5, opl.size()); ++k) {
            this.renderSmartButtonBoxSprite(poseStack, multiBufferSource, 189.0f, 23 + k * 13, 0.004f, 77.0f, 13.0f, i, j, onPxW, onPxH, monitorHeight);
            OERenderUtil.renderPlayerFaceSprite((class_4587)poseStack, (class_4597)multiBufferSource, (UUID)((UUID)opl.get(k)), (float)(190.0f * onPxW), (float)(monitorHeight - (float)(23 + k * 13 + 1 + 11) * onPxH), (float)0.006f, (float)0.0f, (float)0.0f, (float)0.0f, (float)(onPxH * 11.0f), (int)i, (int)j);
            String name = OEClientUtil.getPlayerNameByUUID((UUID)((UUID)opl.get(k))).orElse(((UUID)opl.get(k)).toString());
            class_2585 tx = new class_2585(name);
            float sc = Math.min(1.0f, 59.0f / (float)IIMPSmartRender.mc.field_1772.method_27525((class_5348)tx));
            this.renderSmartTextSprite(poseStack, multiBufferSource, (class_2561)tx, 204.0f, (float)(23 + k * 13) + 3.5f, 0.006f, onPxW, onPxH, monitorHeight, sc, i);
        }
        this.renderScrollbarSprite(poseStack, multiBufferSource, 267.0f, 23.0f, 0.004f, 65.0f, i, j, onPxW, onPxH, monitorHeight, opl.size(), 5);
        List<UUID> ipl = this.getInvitePlayers(blockEntity);
        for (int k = 0; k < Math.min(5, ipl.size()); ++k) {
            this.renderSmartButtonBoxSprite(poseStack, multiBufferSource, 278.0f, 23 + k * 13, 0.004f, 77.0f, 13.0f, i, j, onPxW, onPxH, monitorHeight);
            OERenderUtil.renderPlayerFaceSprite((class_4587)poseStack, (class_4597)multiBufferSource, (UUID)ipl.get(k), (float)(279.0f * onPxW), (float)(monitorHeight - (float)(23 + k * 13 + 1 + 11) * onPxH), (float)0.006f, (float)0.0f, (float)0.0f, (float)0.0f, (float)(onPxH * 11.0f), (int)i, (int)j);
            String name = OEClientUtil.getPlayerNameByUUID((UUID)ipl.get(k)).orElse(ipl.get(k).toString());
            class_2585 tx = new class_2585(name);
            float sc = Math.min(1.0f, 59.0f / (float)IIMPSmartRender.mc.field_1772.method_27525((class_5348)tx));
            this.renderSmartTextSprite(poseStack, multiBufferSource, (class_2561)tx, 293.0f, (float)(23 + k * 13) + 3.5f, 0.006f, onPxW, onPxH, monitorHeight, sc, i);
        }
        this.renderScrollbarSprite(poseStack, multiBufferSource, 355.0f, 23.0f, 0.004f, 65.0f, i, j, onPxW, onPxH, monitorHeight, ipl.size(), 5);
    }

    @Override
    public void depose() {
        super.depose();
        this.stopPlayerUUIDLoad();
    }

    @Override
    public void tick() {
        super.tick();
        this.updateOnlinePlayers();
        this.updateInvitePlayers();
    }

    private void updateOnlinePlayers() {
        this.onlinePlayers.clear();
        this.onlinePlayers.addAll(IIMPSmartRender.mc.field_1724.field_3944.method_31363());
        this.onlinePlayers.remove(IIMPSmartRender.mc.field_1724.method_7334().getId());
        this.onlinePlayers.removeAll(this.getInvitePlayers());
        Collection<UUID> ex = this.excludeInvitePlayers();
        if (ex != null) {
            this.onlinePlayers.removeAll(ex);
        }
    }

    private void updateInvitePlayers() {
        this.invitePlayers.clear();
        this.invitePlayers.addAll(this.getInvitePlayers());
    }

    protected Collection<UUID> excludeInvitePlayers(MusicManagerBlockEntity musicManagerBlockEntity) {
        return null;
    }

    protected Collection<UUID> excludeInvitePlayers() {
        class_2586 class_25862 = this.getScreen().getBlockEntity();
        if (class_25862 instanceof MusicManagerBlockEntity) {
            MusicManagerBlockEntity musicManagerBlock = (MusicManagerBlockEntity)class_25862;
            return this.excludeInvitePlayers(musicManagerBlock);
        }
        return null;
    }

    protected void setPublishingType(@Nullable PlayListBaseMMMonitor.PublishingType publishingType) {
        this.getScreen().insPublishing(publishingType == null ? "" : publishingType.getName());
    }

    protected void setInvitePlayerName(@NotNull String name) {
        this.getScreen().insInvitePlayerName(name);
    }

    protected void setInitialAuthority(@Nullable PlayListBaseMMMonitor.InitialAuthorityType initialAuthorityType) {
        this.getScreen().insInitialAuthority(initialAuthorityType == null ? "" : initialAuthorityType.getName());
    }

    protected void removeInvitePlayer(@NotNull UUID uuid) {
        ArrayList<UUID> pls = new ArrayList<UUID>(this.getInvitePlayers());
        pls.remove(uuid);
        this.setInvitePlayers(pls);
    }

    protected void addInvitePlayer(@NotNull UUID uuid) {
        if (IIMPSmartRender.mc.field_1724.method_7334().equals((Object)uuid)) {
            return;
        }
        ArrayList<UUID> pls = new ArrayList<UUID>(this.getInvitePlayers());
        if (pls.contains(uuid)) {
            return;
        }
        pls.add(uuid);
        this.setInvitePlayers(pls);
    }

    protected void setInvitePlayers(List<UUID> players) {
        this.getScreen().insInvitePlayers(players);
    }

    private void startPlayerUUIDLoad(String text) {
        this.stopPlayerUUIDLoad();
        this.playerUUIDLoadThread = new PlayerUUIDLoadThread(text);
        this.playerUUIDLoadThread.start();
    }

    private void stopPlayerUUIDLoad() {
        if (this.playerUUIDLoadThread != null) {
            this.playerUUIDLoadThread.interrupt();
            this.playerUUIDLoadThread = null;
        }
    }

    private class PlayerUUIDLoadThread
    extends Thread {
        private final String name;

        private PlayerUUIDLoadThread(String name) {
            this.name = name;
        }

        @Override
        public void run() {
            try {
                SavedPlayListBaseMMMonitor.this.addInvitePlayer(UUID.fromString(this.name));
                return;
            }
            catch (Exception exception) {
                OEPlayerUtil.getUUIDByName((String)this.name).ifPresent(SavedPlayListBaseMMMonitor.this::addInvitePlayer);
                return;
            }
        }
    }
}

