/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.music;

import dev.felnull.imp.IamMusicPlayer;
import dev.felnull.imp.client.music.loader.IMPMusicLoaders;
import dev.felnull.imp.client.music.loader.IMusicLoader;
import dev.felnull.imp.client.music.player.IMusicPlayer;
import dev.felnull.imp.client.music.subtitle.IMPMusicSubtitles;
import dev.felnull.imp.client.music.subtitle.IMusicSubtitle;
import dev.felnull.imp.client.music.subtitle.SubtitleType;
import dev.felnull.imp.music.MusicPlaybackInfo;
import dev.felnull.imp.music.resource.MusicSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MusicLoadThread
extends Thread {
    private static final Logger LOGGER = LogManager.getLogger(MusicLoadThread.class);
    private final MusicSource source;
    private final MusicPlaybackInfo playbackInfo;
    private final long position;
    private final MusicLoadResultListener listener;
    private LoadTimer timer;
    private boolean timeOut;

    protected MusicLoadThread(MusicSource source, MusicPlaybackInfo playbackInfo, long position, MusicLoadResultListener listener) {
        this.setName("Music Loader Thread: " + source.getIdentifier());
        this.source = source;
        this.playbackInfo = playbackInfo;
        this.position = position;
        this.listener = listener;
    }

    @Override
    public void run() {
        long time = System.currentTimeMillis();
        IMusicLoader loader = null;
        for (IMusicLoader ldr : IMPMusicLoaders.getLoaders()) {
            try {
                this.timer = new LoadTimer();
                this.timer.start();
                boolean lod = ldr.canLoad(this.source);
                this.timer.interrupt();
                this.timer = null;
                if (!lod) continue;
                loader = ldr;
                break;
            }
            catch (InterruptedException ex) {
                if (!this.timeOut) {
                    return;
                }
                if (IamMusicPlayer.CONFIG.errorLog) {
                    LOGGER.error("Load check time out: " + this.source.getIdentifier());
                }
                this.timeOut = false;
            }
            catch (Exception exception) {
            }
        }
        if (loader == null) {
            if (IamMusicPlayer.CONFIG.errorLog) {
                LOGGER.error("Non existent music loader: " + this.source.getLoaderType());
            }
            this.listener.onResult(false, System.currentTimeMillis() - time, null, false);
            return;
        }
        IMusicPlayer player = null;
        try {
            player = loader.createMusicPlayer(this.source);
            this.timer = new LoadTimer();
            this.timer.start();
            player.load(this.position);
            this.timer.interrupt();
            this.timer = null;
            if (!player.isLoadSuccess()) {
                throw new IllegalStateException("Load failed");
            }
        }
        catch (InterruptedException ignored) {
            if (this.timeOut) {
                if (IamMusicPlayer.CONFIG.errorLog) {
                    LOGGER.error("Load time out: " + this.source.getIdentifier());
                }
                this.listener.onResult(false, System.currentTimeMillis() - time, null, false);
            }
            player.destroy();
            return;
        }
        catch (Exception ex) {
            if (player != null) {
                player.destroy();
            }
            if (IamMusicPlayer.CONFIG.errorLog) {
                LOGGER.error("Failed to load music: " + this.source.getIdentifier(), (Throwable)ex);
            }
            this.listener.onResult(false, System.currentTimeMillis() - time, null, true);
            return;
        }
        if (IamMusicPlayer.CONFIG.subtitleType != SubtitleType.OFF) {
            try {
                IMusicSubtitle subtitle = IMPMusicSubtitles.createSubtitle(this.source.getLoaderType(), this.source);
                if (subtitle != null && subtitle.isExist()) {
                    subtitle.load();
                    player.setSubtitle(subtitle);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.listener.onResult(true, System.currentTimeMillis() - time, player, false);
    }

    public MusicPlaybackInfo getPlaybackInfo() {
        return this.playbackInfo;
    }

    public long getPosition() {
        return this.position;
    }

    public MusicSource getSource() {
        return this.source;
    }

    public MusicLoadResultListener getListener() {
        return this.listener;
    }

    public static interface MusicLoadResultListener {
        public void onResult(boolean var1, long var2, IMusicPlayer var4, boolean var5);
    }

    private class LoadTimer
    extends Thread {
        private LoadTimer() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(15000L);
                MusicLoadThread.this.timeOut = true;
                MusicLoadThread.this.interrupt();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

