/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.music.loadertypes;

import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.imp.client.music.loadertypes.AbstractLavaPlayerMusicLoaderType;
import dev.felnull.imp.client.music.loadertypes.HttpURLMusicLoaderType;
import dev.felnull.imp.client.music.loadertypes.IMusicLoaderType;
import dev.felnull.imp.client.music.loadertypes.MusicLoadResult;
import dev.felnull.imp.client.music.loadertypes.YoutubeMusicLoaderType;
import dev.felnull.imp.client.util.LavaPlayerUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.tuple.Pair;

public class IMPMusicLoaderTypes {
    private static final Map<String, IMusicLoaderType> LOADER_TYPES = new LinkedHashMap<String, IMusicLoaderType>();
    public static AudioPlayerManager allAudioPlayerManager;
    public static final String YOUTUBE = "youtube";
    public static final String HTTP = "http";

    public static void init() {
        IMPMusicLoaderTypes.registerLoaderType(YOUTUBE, new YoutubeMusicLoaderType());
        IMPMusicLoaderTypes.registerLoaderType(HTTP, new HttpURLMusicLoaderType());
    }

    public static IMusicLoaderType getLoaderType(String name) {
        return LOADER_TYPES.get(name);
    }

    public static void registerLoaderType(String name, IMusicLoaderType loaderType) {
        LOADER_TYPES.put(name, loaderType);
        if (allAudioPlayerManager == null) {
            allAudioPlayerManager = LavaPlayerUtil.createAudioPlayerManager();
        }
        if (loaderType instanceof AbstractLavaPlayerMusicLoaderType) {
            AbstractLavaPlayerMusicLoaderType lLoaderType = (AbstractLavaPlayerMusicLoaderType)loaderType;
            lLoaderType.registerSourceManager(allAudioPlayerManager);
        }
    }

    public static Map<String, IMusicLoaderType> getMusicLoaderTypes() {
        return LOADER_TYPES;
    }

    public static Pair<String, MusicLoadResult> loadAuto(String sourceName) throws InterruptedException {
        try {
            Optional<AudioTrack> otrack = LavaPlayerUtil.loadTrack(allAudioPlayerManager, sourceName);
            if (otrack.isPresent() && !otrack.get().getInfo().isStream) {
                AudioTrack track = otrack.get();
                for (Map.Entry<String, IMusicLoaderType> entry : IMPMusicLoaderTypes.getMusicLoaderTypes().entrySet()) {
                    AbstractLavaPlayerMusicLoaderType lLoaderType;
                    IMusicLoaderType iMusicLoaderType = entry.getValue();
                    if (!(iMusicLoaderType instanceof AbstractLavaPlayerMusicLoaderType) || !(lLoaderType = (AbstractLavaPlayerMusicLoaderType)iMusicLoaderType).match(track)) continue;
                    return Pair.of((Object)entry.getKey(), (Object)lLoaderType.createResult(track));
                }
            }
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return null;
    }
}

