/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.client.util;

import com.sedmelluq.discord.lavaplayer.player.AudioConfiguration;
import com.sedmelluq.discord.lavaplayer.player.AudioLoadResultHandler;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.player.DefaultAudioPlayerManager;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.imp.client.music.loadertypes.IMPMusicLoaderTypes;
import dev.felnull.imp.client.music.loadertypes.YoutubeMusicLoaderType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class LavaPlayerUtil {
    private static final Map<CashEntry, AudioTrack> TRACK_CASH = new HashMap<CashEntry, AudioTrack>();

    public static Optional<AudioTrack> loadCashedTrack(String loadType, AudioPlayerManager audioPlayerManager, String identifier, boolean remove) throws ExecutionException, InterruptedException {
        CashEntry ce = new CashEntry(loadType, identifier);
        AudioTrack track = TRACK_CASH.get(ce);
        if (track != null) {
            if (remove) {
                TRACK_CASH.put(ce, TRACK_CASH.get(ce).makeClone());
            }
            return Optional.of(track);
        }
        Optional<AudioTrack> lt = LavaPlayerUtil.loadTrack(audioPlayerManager, identifier);
        lt.ifPresent(n -> TRACK_CASH.put(ce, (AudioTrack)n));
        return lt;
    }

    public static Optional<AudioTrack> loadTrackNonThrow(AudioPlayerManager audioPlayerManager, String identifier) {
        try {
            return LavaPlayerUtil.loadTrack(audioPlayerManager, identifier);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return Optional.empty();
        }
    }

    public static void test() {
        Thread th = new Thread(() -> {
            try {
                LavaPlayerUtil.searchYoutube(((YoutubeMusicLoaderType)IMPMusicLoaderTypes.getLoaderType("youtube")).getAudioPlayerManager(), "TEST");
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        th.start();
    }

    public static Optional<AudioTrack> loadTrack(AudioPlayerManager audioPlayerManager, String identifier) throws ExecutionException, InterruptedException {
        final AtomicReference audioTrack = new AtomicReference();
        final AtomicReference fe = new AtomicReference();
        audioPlayerManager.loadItem(identifier, new AudioLoadResultHandler(){

            public void trackLoaded(AudioTrack track) {
                audioTrack.set(track);
            }

            public void playlistLoaded(AudioPlaylist playlist) {
            }

            public void noMatches() {
            }

            public void loadFailed(FriendlyException ex) {
                fe.set(ex);
            }
        }).get();
        if (fe.get() != null) {
            throw (FriendlyException)fe.get();
        }
        return Optional.ofNullable((AudioTrack)audioTrack.get());
    }

    public static AudioPlayerManager createAudioPlayerManager() {
        DefaultAudioPlayerManager audioPlayerManager = new DefaultAudioPlayerManager();
        audioPlayerManager.setFrameBufferDuration(1000);
        audioPlayerManager.setPlayerCleanupThreshold(Long.MAX_VALUE);
        audioPlayerManager.getConfiguration().setResamplingQuality(AudioConfiguration.ResamplingQuality.HIGH);
        audioPlayerManager.getConfiguration().setOpusEncodingQuality(10);
        return audioPlayerManager;
    }

    public static List<AudioTrack> searchYoutube(AudioPlayerManager audioPlayerManager, String name) throws ExecutionException, InterruptedException {
        return (List)LavaPlayerUtil.loadTracks(audioPlayerManager, "ytsearch:" + name).getRight();
    }

    public static Pair<AudioPlaylist, List<AudioTrack>> loadTracks(@NotNull AudioPlayerManager audioPlayerManager, String name) throws ExecutionException, InterruptedException {
        final ArrayList tracks = new ArrayList();
        final AtomicReference fe = new AtomicReference();
        final AtomicReference playlist = new AtomicReference();
        audioPlayerManager.loadItem(name, new AudioLoadResultHandler(){

            public void trackLoaded(AudioTrack track) {
                tracks.add(track);
            }

            public void playlistLoaded(AudioPlaylist pl) {
                tracks.addAll(pl.getTracks());
                playlist.set(pl);
            }

            public void noMatches() {
            }

            public void loadFailed(FriendlyException ex) {
                fe.set(ex);
            }
        }).get();
        if (fe.get() != null) {
            throw (FriendlyException)fe.get();
        }
        return Pair.of((Object)((AudioPlaylist)playlist.get()), tracks);
    }

    private record CashEntry(String loadType, String str) {
    }
}

