/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.imp.item;

import dev.felnull.imp.block.BoomboxBlock;
import dev.felnull.imp.block.IMPBlocks;
import dev.felnull.imp.blockentity.BoomboxBlockEntity;
import dev.felnull.imp.data.BoomboxData;
import dev.felnull.imp.item.BoomboxEntityRinger;
import dev.felnull.imp.item.BoomboxItemContainer;
import dev.felnull.imp.server.music.ringer.IMusicRinger;
import dev.felnull.imp.server.music.ringer.MusicRingManager;
import dev.felnull.otyacraftengine.item.IInstructionItem;
import dev.felnull.otyacraftengine.item.ItemContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5328;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoomboxItem
extends class_1747
implements IInstructionItem {
    public BoomboxItem(class_2248 block, class_1792.class_1793 properties) {
        super(block, properties);
    }

    public void method_7888(@NotNull class_1799 itemStack, @NotNull class_1937 level, @NotNull class_1297 entity, int i, boolean bl) {
        super.method_7888(itemStack, level, entity, i, bl);
        BoomboxItem.tick(level, entity, itemStack, false);
    }

    public class_1271<class_1799> method_7836(@NotNull class_1937 level, class_1657 player, @NotNull class_1268 interactionHand) {
        class_1799 itemStack = player.method_5998(interactionHand);
        if (BoomboxItem.getTransferProgress(itemStack) == 0 || BoomboxItem.getTransferProgress(itemStack) == 10) {
            if (!level.method_8608()) {
                if (BoomboxItem.checkDuplication(itemStack, (class_1297)player)) {
                    BoomboxItem.setUUID(itemStack, UUID.randomUUID());
                }
                if (player.method_18276()) {
                    BoomboxItem.setPowerOn(itemStack, !BoomboxItem.isPowerOn(itemStack));
                } else if (BoomboxItem.isPowerOn(itemStack)) {
                    BoomboxItemContainer.openContainer((class_3222)player, interactionHand, itemStack);
                }
            }
            return class_1271.method_29237((Object)itemStack, (boolean)level.method_8608());
        }
        return super.method_7836(level, player, interactionHand);
    }

    public class_1269 method_7712(class_1750 blockPlaceContext) {
        class_1799 itemStack = blockPlaceContext.method_8041();
        class_1657 player = blockPlaceContext.method_8036();
        if (player != null && (player.method_18276() || BoomboxItem.isPowerOn(itemStack))) {
            if (BoomboxItem.getTransferProgress(itemStack) == 0 || BoomboxItem.getTransferProgress(itemStack) == 10) {
                if (!blockPlaceContext.method_8045().method_8608()) {
                    if (player.method_18276()) {
                        if (BoomboxItem.getTransferProgress(itemStack) == 0 || BoomboxItem.getTransferProgress(itemStack) == 10) {
                            BoomboxItem.setPowerOn(itemStack, !BoomboxItem.isPowerOn(itemStack));
                        }
                    } else if (BoomboxItem.isPowerOn(itemStack)) {
                        BoomboxItemContainer.openContainer((class_3222)player, blockPlaceContext.method_20287(), itemStack);
                    }
                }
                return class_1269.method_29236((boolean)blockPlaceContext.method_8045().field_9236);
            }
            return class_1269.field_5814;
        }
        return super.method_7712(blockPlaceContext);
    }

    protected boolean method_7709(class_1750 blockPlaceContext, @NotNull class_2680 blockState) {
        return !BoomboxItem.isPowerOn(blockPlaceContext.method_8041()) && super.method_7709(blockPlaceContext, blockState);
    }

    public void method_33261(@NotNull class_1542 itemEntity) {
        if (this.method_7711() instanceof BoomboxBlock) {
            class_5328.method_33263((class_1542)itemEntity, (Stream)BoomboxItem.getContainItem(itemEntity.method_6983()).stream());
        }
        super.method_33261(itemEntity);
    }

    public static void tick(class_1937 level, class_1297 entity, class_1799 stack, boolean musicOnly) {
        class_1309 livingEntity;
        if (!stack.method_31574(IMPBlocks.BOOMBOX.method_8389())) {
            return;
        }
        if (!level.method_8608()) {
            if (BoomboxItem.getUUID(stack) == null) {
                BoomboxItem.setUUID(stack, UUID.randomUUID());
            }
            MusicRingManager mr = MusicRingManager.getInstance();
            UUID uuid = BoomboxItem.getUUID(stack);
            if (uuid != null && BoomboxEntityRinger.canRing(entity) && !mr.isExistRinger((class_3218)level, uuid)) {
                mr.addRinger((class_3218)level, new BoomboxEntityRinger(entity, uuid));
            }
        }
        if (musicOnly) {
            return;
        }
        BoomboxData data = BoomboxItem.getData(stack);
        data.tick(level);
        BoomboxItem.setData(stack, data);
        if (entity instanceof class_1309 && ((livingEntity = (class_1309)entity).method_6047() == stack || livingEntity.method_6079() == stack)) {
            boolean power = BoomboxItem.isPowerOn(stack);
            BoomboxItem.setTransferProgressOld(stack, BoomboxItem.getTransferProgress(stack));
            BoomboxItem.setTransferProgress(stack, BoomboxItem.getTransferProgress(stack) + (power ? 1 : -1));
        }
    }

    protected boolean method_7710(@NotNull class_2338 blockPos, class_1937 level, @Nullable class_1657 player, @NotNull class_1799 itemStack, @NotNull class_2680 blockState) {
        class_2586 be;
        MinecraftServer server = level.method_8503();
        if (server != null && (be = level.method_8321(blockPos)) instanceof BoomboxBlockEntity) {
            BoomboxBlockEntity boomboxBlockEntity = (BoomboxBlockEntity)be;
            boomboxBlockEntity.setByItem(itemStack);
            boomboxBlockEntity.method_5431();
            super.method_7710(blockPos, level, player, itemStack, blockState);
            return true;
        }
        return super.method_7710(blockPos, level, player, itemStack, blockState);
    }

    public static boolean matches(class_1799 src, class_1799 target) {
        if (src == target) {
            return true;
        }
        UUID uid = BoomboxItem.getUUID(src);
        return uid != null && uid.equals(BoomboxItem.getUUID(target));
    }

    public static class_2487 getBoomboxTag(class_1799 stack) {
        if (stack.method_7969() != null) {
            return stack.method_7969().method_10562("BoomboxTag");
        }
        return null;
    }

    public static class_2487 getOrCreateBoomboxTag(class_1799 stack) {
        class_2487 tag = stack.method_7948();
        if (!tag.method_10545("BoomboxTag")) {
            tag.method_10566("BoomboxTag", (class_2520)new class_2487());
        }
        return tag.method_10562("BoomboxTag");
    }

    public static BoomboxData getData(final class_1799 stack) {
        BoomboxData data = new BoomboxData(new BoomboxData.DataAccess(){

            @Override
            public class_1799 getCassetteTape() {
                return BoomboxItem.getCassetteTape(stack);
            }

            @Override
            public class_1799 getAntenna() {
                return BoomboxItem.getAntenna(stack);
            }

            @Override
            public boolean isPower() {
                return BoomboxItem.isPowerOn(stack);
            }

            @Override
            public void setPower(boolean power) {
                BoomboxItem.setPowerOn(stack, power);
            }

            @Override
            public IMusicRinger getRinger() {
                UUID uuid = BoomboxItem.getUUID(stack);
                MusicRingManager mr = MusicRingManager.getInstance();
                if (uuid != null) {
                    return mr.getRinger(uuid);
                }
                return null;
            }

            @Override
            public class_243 getPosition() {
                if (this.getRinger() == null) {
                    return class_243.field_1353;
                }
                return this.getRinger().getRingerSpatialPosition();
            }

            @Override
            public void setCassetteTape(class_1799 cassette) {
                BoomboxItem.setCassetteTape(stack, cassette);
            }

            @Override
            public void dataUpdate(BoomboxData data) {
                BoomboxItem.setData(stack, data);
            }
        });
        class_2487 tag = BoomboxItem.getBoomboxTag(stack);
        if (tag != null) {
            data.load(tag.method_10562("BoomBoxData"), true, true);
        }
        return data;
    }

    public static void setData(class_1799 stack, BoomboxData data) {
        BoomboxItem.getOrCreateBoomboxTag(stack).method_10566("BoomBoxData", (class_2520)data.save(new class_2487(), true, true));
    }

    public static boolean isPowerOn(class_1799 itemStack) {
        if (BoomboxItem.getBoomboxTag(itemStack) != null) {
            return BoomboxItem.getBoomboxTag(itemStack).method_10577("Power");
        }
        return false;
    }

    public static void setPowerOn(class_1799 itemStack, boolean power) {
        BoomboxItem.getOrCreateBoomboxTag(itemStack).method_10556("Power", power);
    }

    public static int getTransferProgress(class_1799 stack) {
        if (BoomboxItem.getBoomboxTag(stack) != null) {
            return BoomboxItem.getBoomboxTag(stack).method_10550("Transfer");
        }
        return 0;
    }

    public static void setTransferProgress(class_1799 stack, int num) {
        BoomboxItem.getOrCreateBoomboxTag(stack).method_10569("Transfer", class_3532.method_15340((int)num, (int)0, (int)10));
    }

    public static int getTransferProgressOld(class_1799 stack) {
        if (BoomboxItem.getBoomboxTag(stack) != null) {
            return BoomboxItem.getBoomboxTag(stack).method_10550("TransferOld");
        }
        return 0;
    }

    public static void setTransferProgressOld(class_1799 stack, int num) {
        BoomboxItem.getOrCreateBoomboxTag(stack).method_10569("TransferOld", class_3532.method_15340((int)num, (int)0, (int)10));
    }

    public static float getTransferProgress(class_1799 stack, float partialTicks) {
        return class_3532.method_16439((float)partialTicks, (float)BoomboxItem.getTransferProgressOld(stack), (float)BoomboxItem.getTransferProgress(stack)) / 10.0f;
    }

    public static UUID getUUID(class_1799 stack) {
        if (BoomboxItem.getBoomboxTag(stack) != null && BoomboxItem.getBoomboxTag(stack).method_10545("Identification")) {
            return BoomboxItem.getBoomboxTag(stack).method_25926("Identification");
        }
        return null;
    }

    public static void setUUID(class_1799 stack, UUID id) {
        BoomboxItem.getOrCreateBoomboxTag(stack).method_25927("Identification", id);
    }

    public static class_2371<class_1799> getContainItem(class_1799 stack) {
        class_2371 stacks = class_2371.method_10213((int)2, (Object)class_1799.field_8037);
        ItemContainer.loadItemList((class_1799)stack, (class_2371)stacks, (String)"BoomboxItems");
        return stacks;
    }

    public static void setContainItem(class_1799 stack, class_2371<class_1799> stacks) {
        ItemContainer.saveItemList((class_1799)stack, stacks, (String)"BoomboxItems");
    }

    public static void setCassetteTape(class_1799 stack, class_1799 cassette) {
        class_2371<class_1799> itms = BoomboxItem.getContainItem(stack);
        itms.set(0, (Object)cassette);
        BoomboxItem.setContainItem(stack, itms);
    }

    public static class_1799 getCassetteTape(class_1799 stack) {
        return (class_1799)BoomboxItem.getContainItem(stack).get(0);
    }

    public static class_1799 getAntenna(class_1799 stack) {
        return (class_1799)BoomboxItem.getContainItem(stack).get(1);
    }

    public class_2487 onInstruction(class_1799 itemStack, class_3222 player, String name, int num, class_2487 data) {
        return BoomboxItem.getData(itemStack).onInstruction(player, name, num, data);
    }

    public static class_1799 createByBE(BoomboxBlockEntity blockEntity, boolean stopMusic) {
        class_1799 itemStack = new class_1799((class_1935)IMPBlocks.BOOMBOX);
        BoomboxItem.setContainItem(itemStack, blockEntity.getItems());
        BoomboxItem.setData(itemStack, blockEntity.getBoomboxData());
        BoomboxData d = BoomboxItem.getData(itemStack);
        if (stopMusic) {
            d.setPlaying(false);
            d.setMusicPosition(0L);
        }
        BoomboxItem.setData(itemStack, d);
        BoomboxItem.setPowerOn(itemStack, blockEntity.isPower());
        if (blockEntity.isPower()) {
            BoomboxItem.setTransferProgress(itemStack, 10);
            BoomboxItem.setTransferProgressOld(itemStack, 10);
        }
        if (blockEntity.method_16914()) {
            itemStack.method_7977(blockEntity.method_5797());
        }
        BoomboxItem.setUUID(itemStack, UUID.randomUUID());
        return itemStack;
    }

    public static boolean checkDuplication(class_1799 stack, class_1297 entity) {
        UUID stackId = BoomboxItem.getUUID(stack);
        if (stackId == null) {
            return false;
        }
        ArrayList<class_1799> allItem = new ArrayList<class_1799>();
        if (entity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)entity;
            for (class_1304 value : class_1304.values()) {
                allItem.add(livingEntity.method_6118(value));
            }
        }
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            allItem.addAll((Collection<class_1799>)player.method_31548().field_7547);
        }
        for (class_1799 item : allItem) {
            if (item == stack || item.method_7960() || !stackId.equals(BoomboxItem.getUUID(item))) continue;
            return true;
        }
        return false;
    }
}

