/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core;

import dev.felnull.itts.core.ITTSRuntimeUse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public class DirectoryLock
implements ITTSRuntimeUse {
    private static final File LOCK_FILE = new File("./dir.lock");
    private FileOutputStream fileOutputStream;
    private FileChannel fileChannel;
    private FileLock fileLock;

    protected void lock() {
        LOCK_FILE.delete();
        try {
            this.fileOutputStream = new FileOutputStream(LOCK_FILE);
            this.fileOutputStream.write(new byte[]{0});
            this.fileChannel = this.fileOutputStream.getChannel();
            this.fileLock = this.fileChannel.tryLock();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to lock directory, directory may be locked by another process", e);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            try {
                this.fileLock.release();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.fileOutputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            LOCK_FILE.delete();
        }));
    }
}

