/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core;

import com.google.common.collect.ImmutableList;
import dev.felnull.itts.core.DirectoryLock;
import dev.felnull.itts.core.ITTSBaseManager;
import dev.felnull.itts.core.audio.VoiceAudioManager;
import dev.felnull.itts.core.cache.CacheManager;
import dev.felnull.itts.core.cache.GlobalCacheAccess;
import dev.felnull.itts.core.config.ConfigAccess;
import dev.felnull.itts.core.config.ConfigManager;
import dev.felnull.itts.core.dict.DictionaryManager;
import dev.felnull.itts.core.discord.Bot;
import dev.felnull.itts.core.savedata.SaveDataAccess;
import dev.felnull.itts.core.savedata.SaveDataManager;
import dev.felnull.itts.core.tts.TTSManager;
import dev.felnull.itts.core.voice.VoiceManager;
import java.util.List;
import java.util.Objects;
import java.util.Timer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ITTSRuntime {
    private static ITTSRuntime INSTANCE;
    private final Logger logger = LogManager.getLogger(ITTSRuntime.class);
    private final ExecutorService asyncWorkerExecutor = Executors.newCachedThreadPool((ThreadFactory)new BasicThreadFactory.Builder().namingPattern("async-worker-%d").daemon(true).build());
    private final ExecutorService heavyProcessExecutor = Executors.newFixedThreadPool(Math.max(Runtime.getRuntime().availableProcessors(), 1), (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("heavy-process-thread-%d").daemon(true).build());
    private final Timer timer = new Timer("ikisugi-timer", true);
    private final DirectoryLock directoryLock = new DirectoryLock();
    private final String version;
    private final boolean developmentEnvironment;
    private final ConfigManager configManager;
    private final TTSManager ttsManager = new TTSManager();
    private final VoiceManager voiceManager = new VoiceManager();
    private final VoiceAudioManager voiceAudioManager = new VoiceAudioManager();
    private final DictionaryManager dictionaryManager = new DictionaryManager();
    private final CacheManager cacheManager;
    private final SaveDataManager saveDataManager;
    private final Bot bot;
    private final List<ITTSBaseManager> managers;
    private long startupTime;

    private ITTSRuntime(@NotNull ConfigAccess configAccess, @NotNull SaveDataAccess saveDataAccess, @Nullable Supplier<GlobalCacheAccess> globalCacheAccessFactory) {
        if (INSTANCE != null) {
            throw new IllegalStateException("ITTSRuntime must be a singleton instance");
        }
        INSTANCE = this;
        this.directoryLock.lock();
        String v = ITTSRuntime.class.getPackage().getImplementationVersion();
        this.developmentEnvironment = v == null;
        this.version = Objects.requireNonNullElse(v, "None");
        this.bot = new Bot();
        this.configManager = new ConfigManager(configAccess);
        this.saveDataManager = new SaveDataManager(saveDataAccess);
        this.cacheManager = new CacheManager(globalCacheAccessFactory);
        this.managers = ImmutableList.of((Object)this.configManager, (Object)this.saveDataManager, (Object)this.voiceManager);
    }

    public static ITTSRuntime getInstance() {
        if (INSTANCE == null) {
            throw new IllegalStateException("Instance does not exist");
        }
        return INSTANCE;
    }

    public static ITTSRuntime newRuntime(@NotNull ConfigAccess configAccess, @NotNull SaveDataAccess saveDataAccess, @Nullable Supplier<GlobalCacheAccess> globalCacheAccessFactory) {
        return new ITTSRuntime(configAccess, saveDataAccess, globalCacheAccessFactory);
    }

    public void execute() {
        this.startupTime = System.currentTimeMillis();
        this.logger.info("The Ikisugi TTS ({})", (Object)this.getVersionText());
        this.logger.info("--System info--");
        this.logger.info("Java runtime: {}", (Object)System.getProperty("java.runtime.name"));
        this.logger.info("Java version: {}", (Object)System.getProperty("java.version"));
        this.logger.info("Java vm name: {}", (Object)System.getProperty("java.vm.name"));
        this.logger.info("Java vm version: {}", (Object)System.getProperty("java.vm.version"));
        this.logger.info("OS: {}", (Object)System.getProperty("os.name"));
        this.logger.info("Arch: {}", (Object)System.getProperty("os.arch"));
        this.logger.info("Available Processors: {}", (Object)Runtime.getRuntime().availableProcessors());
        this.logger.info("---------------");
        this.logger.info("Start setup");
        this.managers.stream().map(ITTSBaseManager::init).forEach(CompletableFuture::join);
        this.logger.info("Setup complete");
        this.bot.start();
    }

    public long getStartupTime() {
        return this.startupTime;
    }

    public Executor getAsyncWorkerExecutor() {
        return this.asyncWorkerExecutor;
    }

    public ExecutorService getHeavyProcessExecutor() {
        return this.heavyProcessExecutor;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public boolean isDevelopmentEnvironment() {
        return this.developmentEnvironment;
    }

    public String getVersion() {
        return this.version;
    }

    public String getVersionText() {
        return this.isDevelopmentEnvironment() ? "\u958b\u767a\u74b0\u5883" : "v" + this.getVersion();
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public TTSManager getTTSManager() {
        return this.ttsManager;
    }

    public VoiceAudioManager getVoiceAudioManager() {
        return this.voiceAudioManager;
    }

    public SaveDataManager getSaveDataManager() {
        return this.saveDataManager;
    }

    public VoiceManager getVoiceManager() {
        return this.voiceManager;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public DictionaryManager getDictionaryManager() {
        return this.dictionaryManager;
    }

    public Bot getBot() {
        return this.bot;
    }
}

