/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.audio;

import com.sedmelluq.discord.lavaplayer.player.AudioLoadResultHandler;
import com.sedmelluq.discord.lavaplayer.player.AudioPlayer;
import com.sedmelluq.discord.lavaplayer.player.event.AudioEventAdapter;
import com.sedmelluq.discord.lavaplayer.player.event.AudioEventListener;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackEndReason;
import dev.felnull.itts.core.ITTSRuntimeUse;
import dev.felnull.itts.core.audio.LoadedSaidText;
import dev.felnull.itts.core.audio.VoiceAudioHandler;
import dev.felnull.itts.core.audio.VoiceAudioManager;
import dev.felnull.itts.core.audio.loader.VoiceTrackLoader;
import dev.felnull.itts.core.tts.saidtext.SaidText;
import dev.felnull.itts.core.util.TTSUtils;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import net.dv8tion.jda.api.audio.AudioSendHandler;
import net.dv8tion.jda.api.managers.AudioManager;
import org.apache.commons.lang3.tuple.Pair;

public class VoiceAudioScheduler
extends AudioEventAdapter
implements ITTSRuntimeUse {
    private final AudioManager audioManager;
    private final VoiceAudioManager voiceAudioManager;
    private final AudioPlayer audioPlayer;
    private final AtomicReference<Pair<LoadedSaidText, Runnable>> currentLoaded = new AtomicReference();
    private final long guildId;

    public VoiceAudioScheduler(AudioManager audioManager, VoiceAudioManager voiceAudioManager, long guildId) {
        this.audioManager = audioManager;
        this.voiceAudioManager = voiceAudioManager;
        this.audioPlayer = voiceAudioManager.getAudioPlayerManager().createPlayer();
        this.guildId = guildId;
        this.audioPlayer.addListener((AudioEventListener)this);
        this.audioManager.setSendingHandler((AudioSendHandler)new VoiceAudioHandler(this.audioPlayer));
    }

    public void dispose() {
        this.stop();
        this.audioManager.setSendingHandler(null);
    }

    public CompletableFuture<LoadedSaidText> load(SaidText saidText) {
        return CompletableFuture.supplyAsync(() -> {
            String sayText = this.getDictionaryManager().applyDict(saidText.getText(), this.guildId);
            return TTSUtils.roundText(saidText.getVoice(), this.guildId, sayText, false);
        }, this.getAsyncExecutor()).thenComposeAsync(sayText -> {
            VoiceTrackLoader vtl = saidText.getVoice().createVoiceTrackLoader((String)sayText);
            return vtl.load().thenApplyAsync(r -> new LoadedSaidText(saidText, (AudioTrack)r, vtl::dispose), this.getAsyncExecutor());
        }, this.getAsyncExecutor());
    }

    public void stop() {
        this.currentLoaded.set(null);
        this.audioPlayer.stopTrack();
    }

    public void play(LoadedSaidText loadedSaidText, Runnable playEndRun) {
        this.currentLoaded.set((Pair<LoadedSaidText, Runnable>)Pair.of((Object)loadedSaidText, (Object)playEndRun));
        this.audioPlayer.playTrack(loadedSaidText.getTrack());
    }

    public void onTrackEnd(AudioPlayer player, AudioTrack track, AudioTrackEndReason endReason) {
        Pair old = this.currentLoaded.getAndSet(null);
        if (old != null) {
            ((LoadedSaidText)old.getLeft()).setAlreadyUsed(true);
            ((Runnable)old.getRight()).run();
        }
    }

    public void test() {
        long st = System.currentTimeMillis();
        final AtomicReference trk = new AtomicReference();
        try {
            this.voiceAudioManager.getAudioPlayerManager().loadItem("./TEST.wav", new AudioLoadResultHandler(){

                public void trackLoaded(AudioTrack track) {
                    trk.set(track);
                }

                public void playlistLoaded(AudioPlaylist playlist) {
                }

                public void noMatches() {
                }

                public void loadFailed(FriendlyException exception) {
                }
            }).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        this.audioPlayer.startTrack((AudioTrack)trk.get(), false);
        System.out.println(System.currentTimeMillis() - st);
    }
}

