/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.audio.loader;

import com.google.common.hash.HashCode;
import com.sedmelluq.discord.lavaplayer.player.AudioLoadResultHandler;
import com.sedmelluq.discord.lavaplayer.tools.FriendlyException;
import com.sedmelluq.discord.lavaplayer.track.AudioPlaylist;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import dev.felnull.itts.core.ITTSRuntimeUse;
import dev.felnull.itts.core.audio.VoiceAudioManager;
import dev.felnull.itts.core.audio.loader.VoiceTrackLoader;
import dev.felnull.itts.core.cache.CacheUseEntry;
import dev.felnull.itts.core.cache.StreamOpener;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;

public class CachedVoiceTrackLoader
implements VoiceTrackLoader,
ITTSRuntimeUse {
    private final HashCode hash;
    private final StreamOpener streamOpener;
    private final AtomicReference<CacheUseEntry> cacheEntry = new AtomicReference();

    public CachedVoiceTrackLoader(HashCode hash, StreamOpener streamOpener) {
        this.hash = hash;
        this.streamOpener = streamOpener;
    }

    @Override
    public CompletableFuture<AudioTrack> load() {
        return this.getCacheManager().loadOrRestore(this.hash, this.streamOpener).thenApplyAsync(this::loadTack, this.getAsyncExecutor());
    }

    private AudioTrack loadTack(CacheUseEntry cacheUseEntry) {
        this.cacheEntry.set(cacheUseEntry);
        VoiceAudioManager vam = this.getVoiceAudioManager();
        final AtomicReference retTrack = new AtomicReference();
        try {
            vam.getAudioPlayerManager().loadItem(cacheUseEntry.file().getAbsolutePath(), new AudioLoadResultHandler(){

                public void trackLoaded(AudioTrack track) {
                    retTrack.set(track);
                }

                public void playlistLoaded(AudioPlaylist playlist) {
                }

                public void noMatches() {
                }

                public void loadFailed(FriendlyException exception) {
                }
            }).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        AudioTrack ret = (AudioTrack)retTrack.get();
        if (ret == null) {
            throw new RuntimeException("Failed to load track");
        }
        return ret;
    }

    @Override
    public void dispose() {
        CacheUseEntry ce = this.cacheEntry.get();
        if (ce != null) {
            ce.useLock().unlock();
        }
    }
}

