/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.dict;

import com.google.common.collect.ImmutableMap;
import dev.felnull.itts.core.dict.Dictionary;
import dev.felnull.itts.core.dict.RegexUtil;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class AbbreviationDictionary
implements Dictionary {
    private static final Pattern CODE_BLOCK_REGEX = Pattern.compile("```(.|\n)*```");
    private final RegexUtil regexUtil = new RegexUtil();

    @Override
    @NotNull
    public String apply(@NotNull String text, long guildId) {
        text = CODE_BLOCK_REGEX.matcher(text).replaceAll("\u30b3\u30fc\u30c9\u30d6\u30ed\u30c3\u30af\u30b7\u30e7\u30a6\u30ea\u30e3\u30af");
        return this.regexUtil.replaceText(text);
    }

    @Override
    public boolean isBuiltIn() {
        return true;
    }

    @Override
    @NotNull
    public String getName() {
        return "\u7701\u7565\u8f9e\u66f8";
    }

    @Override
    @NotNull
    public String getId() {
        return "abbreviation";
    }

    @Override
    @NotNull
    public @Unmodifiable Map<String, String> getShowInfo(long guildId) {
        return ImmutableMap.of((Object)"https://...", (Object)"URL\u7701\u7565", (Object)"``` \u30b3\u30fc\u30c9\u30d6\u30ed\u30c3\u30af ```", (Object)"\u30b3\u30fc\u30c9\u30d6\u30ed\u30c3\u30af\u7701\u7565");
    }

    @Override
    public int getPriority() {
        return 4;
    }
}

