/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.dict;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.felnull.itts.core.ITTSRuntimeUse;
import dev.felnull.itts.core.dict.AbbreviationDictionary;
import dev.felnull.itts.core.dict.Dictionary;
import dev.felnull.itts.core.dict.GlobalDictionary;
import dev.felnull.itts.core.dict.RomajiDictionary;
import dev.felnull.itts.core.dict.ServerDictionary;
import dev.felnull.itts.core.dict.UnitDictionary;
import dev.felnull.itts.core.savedata.DictData;
import dev.felnull.itts.core.savedata.DictUseData;
import dev.felnull.itts.core.savedata.SaveDataManager;
import dev.felnull.itts.core.util.JsonUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class DictionaryManager
implements ITTSRuntimeUse {
    private static final int FILE_VERSION = 0;
    private final Dictionary globalDictionary = new GlobalDictionary();
    private final Dictionary serverDictionary = new ServerDictionary();
    private final Dictionary abbreviationDictionary = new AbbreviationDictionary();
    private final Dictionary unitDictionary = new UnitDictionary();
    private final Dictionary romajiDictionary = new RomajiDictionary();
    private final List<Dictionary> dictionaries = ImmutableList.of((Object)this.globalDictionary, (Object)this.serverDictionary, (Object)this.abbreviationDictionary, (Object)this.unitDictionary, (Object)this.romajiDictionary);

    @Nullable
    public Dictionary getDictionary(@NotNull String id, long guildId) {
        return this.dictionaries.stream().filter(r -> id.equals(r.getId())).findAny().orElse(null);
    }

    public boolean isEnable(@NotNull Dictionary dictionary, long guildId) {
        SaveDataManager sdm = this.getSaveDataManager();
        DictUseData dud = sdm.getDictUseData(guildId, dictionary.getId());
        return dud != null;
    }

    public @Unmodifiable @NotNull List<Dictionary> getAllDictionaries(long guildId) {
        return this.dictionaries;
    }

    public String applyDict(String text, long guildId) {
        Stream<DictUseData> allDict = this.getSaveDataManager().getAllDictUseData(guildId).stream().sorted(Comparator.comparingInt(DictUseData::getPriority).reversed());
        AtomicReference<String> retText = new AtomicReference<String>(text);
        allDict.forEach(ud -> {
            Dictionary dict = this.getDictionary(ud.getDictId(), guildId);
            if (dict != null) {
                retText.set(dict.apply((String)retText.get(), guildId));
            }
        });
        return retText.get();
    }

    @NotNull
    public @Unmodifiable List<Pair<String, Integer>> getDefault() {
        return ImmutableList.of((Object)Pair.of((Object)this.globalDictionary.getId(), (Object)this.globalDictionary.getPriority()), (Object)Pair.of((Object)this.serverDictionary.getId(), (Object)this.serverDictionary.getPriority()), (Object)Pair.of((Object)this.abbreviationDictionary.getId(), (Object)this.abbreviationDictionary.getPriority()), (Object)Pair.of((Object)this.romajiDictionary.getId(), (Object)this.romajiDictionary.getPriority()));
    }

    public void serverDictSaveToJson(@NotNull JsonObject jo, long guildId) {
        jo.addProperty("version", (Number)0);
        JsonObject entry = new JsonObject();
        List<DictData> allDict = this.getSaveDataManager().getAllServerDictData(guildId);
        for (DictData dictData : allDict) {
            entry.addProperty(dictData.getTarget(), dictData.getRead());
        }
        jo.add("entry", (JsonElement)entry);
    }

    public List<DictData> serverDictLoadFromJson(@NotNull JsonObject jo, long guildId, boolean overwrite) {
        ArrayList<DictData> ret = new ArrayList<DictData>();
        int version = JsonUtils.getInt(jo, "version", -1);
        if (version != 0) {
            throw new RuntimeException("Unsupported dictionary file version.");
        }
        if (jo.get("entry").isJsonObject()) {
            JsonObject entry = jo.getAsJsonObject("entry");
            SaveDataManager sdm = this.getSaveDataManager();
            for (Map.Entry en : entry.entrySet()) {
                String target = (String)en.getKey();
                if (!((JsonElement)en.getValue()).isJsonPrimitive() || !((JsonElement)en.getValue()).getAsJsonPrimitive().isString()) continue;
                String read = ((JsonElement)en.getValue()).getAsString();
                DictData pre = sdm.getServerDictData(guildId, target);
                if (!overwrite && pre != null) continue;
                sdm.addServerDictData(guildId, target, read);
                DictData ndata = Objects.requireNonNull(sdm.getServerDictData(guildId, target));
                if (ndata.equals(pre)) continue;
                ret.add(ndata);
            }
        }
        return ret;
    }
}

