/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.dict;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RegexUtil {
    private final Pattern URL_REGEX = Pattern.compile("^(https?|ftp|file|s?ftp|ssh)://([\\w-]+\\.)+[\\w-]+(/[\\w\\- ./?%&=~#:,]*)?");
    private final Pattern DOMAIN_REGEX = Pattern.compile("^([a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9]*\\.)+[a-zA-Z]{2,}$");
    private final Pattern IPv4_Regex = Pattern.compile("([0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})");
    private final Pattern IPv6_Regex = Pattern.compile("((([0-9A-Fa-f]{1,4}:){1,6}:)|(([0-9A-Fa-f]{1,4}:){7}))([0-9A-Fa-f]{1,4})$");
    private final String URL_REPLACE_TEXT = "\u30e6\u30fc\u30a2\u30fc\u30eb\u30a8\u30eb\u30b7\u30e7\u30a6\u30ea\u30e3\u30af";
    private final String DOMAIN_REPLACE_TEXT = "\u30c9\u30e1\u30a4\u30f3\u30b7\u30e7\u30a6\u30ea\u30e3\u30af";
    private final String IPv4_REPLACE_TEXT = "\u30a2\u30a4\u30d4\u30fc\u30d6\u30a4\u30d5\u30a9\u30fc\u30b7\u30e7\u30a6\u30ea\u30e3\u30af";
    private final String IPv6_REPLACE_TEXT = "\u30a2\u30a4\u30d4\u30fc\u30d6\u30a4\u30ed\u30af\u30b7\u30e7\u30a6\u30ea\u30e3\u30af";
    private final Map<Pattern, String> DictMap = new HashMap<Pattern, String>();

    public RegexUtil() {
        this.DictMap.put(this.URL_REGEX, "\u30e6\u30fc\u30a2\u30fc\u30eb\u30a8\u30eb\u30b7\u30e7\u30a6\u30ea\u30e3\u30af");
        this.DictMap.put(this.DOMAIN_REGEX, "\u30c9\u30e1\u30a4\u30f3\u30b7\u30e7\u30a6\u30ea\u30e3\u30af");
        this.DictMap.put(this.IPv4_Regex, "\u30a2\u30a4\u30d4\u30fc\u30d6\u30a4\u30d5\u30a9\u30fc\u30b7\u30e7\u30a6\u30ea\u30e3\u30af");
        this.DictMap.put(this.IPv6_Regex, "\u30a2\u30a4\u30d4\u30fc\u30d6\u30a4\u30ed\u30af\u30b7\u30e7\u30a6\u30ea\u30e3\u30af");
    }

    public String replaceText(String text) {
        String[] dividedSpaceTexts;
        ArrayList<String> returnText = new ArrayList<String>();
        String replaceNewLine2SpaceText = text.replace("\n", " ");
        for (String dividedSpaceText : dividedSpaceTexts = replaceNewLine2SpaceText.split(" ")) {
            String replacedText = this.replacer(dividedSpaceText);
            returnText.add(replacedText);
        }
        return String.join((CharSequence)" ", returnText);
    }

    private String replacer(String text) {
        Set<Map.Entry<Pattern, String>> EntrySet2 = this.DictMap.entrySet();
        for (Map.Entry<Pattern, String> entries : EntrySet2) {
            Matcher matcher = entries.getKey().matcher(text);
            if (!matcher.find()) continue;
            return matcher.replaceAll(entries.getValue());
        }
        return text;
    }
}

