/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.dict;

import com.google.common.collect.ImmutableMap;
import dev.felnull.itts.core.dict.Dictionary;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class UnitDictionary
implements Dictionary {
    private static final Pattern UNIT_PREFIX = UnitDictionary.createPrefixAndUnitPattern();
    private static final Pattern NUMBERS = Pattern.compile("\\d+");

    @Override
    @NotNull
    public String apply(@NotNull String text, long guildId) {
        return UNIT_PREFIX.matcher(text).replaceAll(matchResult -> {
            String lst = null;
            if (matchResult.end() < text.length()) {
                lst = String.valueOf(text.charAt(matchResult.end()));
            }
            return this.replaceUnitAndPrefix(matchResult.group(), lst);
        });
    }

    @Override
    public boolean isBuiltIn() {
        return true;
    }

    @Override
    @NotNull
    public String getName() {
        return "\u5358\u4f4d\u8f9e\u66f8";
    }

    @Override
    @NotNull
    public String getId() {
        return "unit";
    }

    private static Pattern createPrefixAndUnitPattern() {
        Pattern alphabet = Pattern.compile("[a-zA-Z]+");
        StringBuilder lastUnits = new StringBuilder();
        StringBuilder preOrUnitMiddle = new StringBuilder();
        for (Unit unit : Unit.values()) {
            String lst = unit.word.substring(unit.word.length() - 1);
            lastUnits.append(lst.toLowerCase(Locale.ROOT)).append(lst.toUpperCase(Locale.ROOT));
            String middle = unit.word.substring(0, unit.word.length() - 1);
            preOrUnitMiddle.append(middle.toLowerCase(Locale.ROOT)).append(middle.toUpperCase(Locale.ROOT));
        }
        for (Enum enum_ : Prefix.values()) {
            if (((Prefix)enum_).word == null || ((Prefix)enum_).read == null) continue;
            Matcher mc = alphabet.matcher(((Prefix)enum_).word);
            if (mc.matches()) {
                preOrUnitMiddle.append(((Prefix)enum_).word.toLowerCase(Locale.ROOT)).append(((Prefix)enum_).word.toUpperCase(Locale.ROOT));
                continue;
            }
            preOrUnitMiddle.append(((Prefix)enum_).word);
        }
        return Pattern.compile("\\d+[" + preOrUnitMiddle + "]*[" + lastUnits + "]");
    }

    private String replaceUnitAndPrefix(String text, String after) {
        Pattern alphabets = Pattern.compile("[a-zA-Z-]+");
        if (after != null && alphabets.matcher(after).matches()) {
            return text;
        }
        Matcher nmc = NUMBERS.matcher(text);
        if (!nmc.find()) {
            return text;
        }
        String number = nmc.group();
        String only = text.substring(number.length());
        Unit unit = Unit.getEndUnit(only);
        if (unit == null) {
            return text;
        }
        String unitStr = only.substring(only.length() - unit.word.length());
        boolean big = Character.isUpperCase(unitStr.charAt(0));
        String prefixStr = only.substring(0, only.length() - unitStr.length());
        if (prefixStr.isEmpty()) {
            return number + unit.read;
        }
        Prefix prefix = Prefix.getPrefix(prefixStr, unit, big);
        if (prefix == null) {
            return text;
        }
        return number + prefix.read + unit.read;
    }

    @Override
    @NotNull
    public @Unmodifiable Map<String, String> getShowInfo(long guildId) {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        StringBuilder upsbw = new StringBuilder();
        StringBuilder upsbr = new StringBuilder();
        StringBuilder dosbw = new StringBuilder();
        StringBuilder dosbr = new StringBuilder();
        for (Prefix pre : Prefix.values()) {
            if (pre.getWord() == null || pre.getRead() == null) continue;
            if (pre.isUp()) {
                upsbw.append(pre.getWord()).append(",");
                upsbr.append(pre.getRead()).append(",");
                continue;
            }
            dosbw.append(pre.getWord()).append(",");
            dosbr.append(pre.getRead()).append(",");
        }
        upsbw.deleteCharAt(upsbw.length() - 1);
        upsbr.deleteCharAt(upsbr.length() - 1);
        dosbw.deleteCharAt(dosbw.length() - 1);
        dosbr.deleteCharAt(dosbr.length() - 1);
        builder.put((Object)upsbw.toString(), (Object)upsbr.toString());
        builder.put((Object)dosbw.toString(), (Object)dosbr.toString());
        StringBuilder unitsbw = new StringBuilder();
        StringBuilder unitsbr = new StringBuilder();
        for (Unit unit : Unit.values()) {
            unitsbw.append(unit.getWord()).append(",");
            unitsbr.append(unit.getRead()).append(",");
        }
        unitsbw.deleteCharAt(unitsbw.length() - 1);
        unitsbr.deleteCharAt(unitsbr.length() - 1);
        builder.put((Object)unitsbw.toString(), (Object)unitsbr.toString());
        return builder.build();
    }

    @Override
    public int getPriority() {
        return 1;
    }

    private static enum Unit {
        GRAM("g", "\u3050\u3089\u3080", Prefix.NORMAL_ALL),
        BYTE("b", "\u3070\u3044\u3068", Prefix.NORMAL_UP),
        METER("m", "\u3081\u30fc\u3068\u308b", Prefix.NORMAL_ALL),
        SECOND("s", "\u79d2", Prefix.NORMAL_DOWN),
        AMPERE("a", "\u3042\u3093\u307a\u3042", Prefix.NORMAL_ALL),
        MOLE("mol", "\u3082\u308b", Prefix.NORMAL_ALL),
        CANDELA("cd", "\u304b\u3093\u3067\u3089", Prefix.NORMAL_ALL),
        RADIAN("rad", "\u3089\u3058\u3042\u3093", Prefix.NORMAL_ALL),
        STERADIAN("sr", "\u3059\u3066\u3089\u3058\u3042\u3093", Prefix.NORMAL_ALL),
        HERTZ("Hz", "\u3059\u3066\u3089\u3058\u3042\u3093", (Prefix[])ArrayUtils.addAll((Object[])Prefix.NORMAL_ALL, (Object[])new Prefix[]{Prefix.DECA, Prefix.HECTO})),
        NEWTON("n", "\u306b\u3085\u30fc\u3068\u3093", Prefix.NORMAL_ALL),
        PASCAL("Pa", "\u3071\u3059\u304b\u308b", Prefix.NORMAL_ALL),
        JOULE("J", "\u3058\u3085\u30fc\u308b", Prefix.NORMAL_ALL),
        WATT("W", "\u308f\u3063\u3068", Prefix.NORMAL_ALL),
        COULOMB("C", "\u304f\u30fc\u308d\u3093", Prefix.NORMAL_ALL),
        VOLT("V", "\u307c\u308b\u3068", Prefix.NORMAL_ALL),
        FARAD("F", "\u3075\u3041\u3089\u3069", Prefix.NORMAL_ALL),
        OHM("\u03a9", "\u304a\u30fc\u3080", Prefix.NORMAL_ALL),
        SIEMENS("S", "\u3058\u30fc\u3081\u3093\u3059", Prefix.NORMAL_ALL),
        WEBER("Wb", "\u3046\u3047\u30fc\u3070", Prefix.NORMAL_ALL),
        TESLA("T", "\u3066\u3059\u3089", Prefix.NORMAL_ALL),
        HENRY("H", "\u3078\u3093\u308a\u30fc", Prefix.NORMAL_ALL),
        CELSIUS("\u00b0C", "\u3069", new Prefix[0]),
        LUMEN("lm", "\u308b\u30fc\u3081\u3093", Prefix.NORMAL_ALL),
        LUX("lx", "\u308b\u304f\u3059", Prefix.NORMAL_ALL),
        BECQUEREL("Bq", "\u3079\u304f\u308c\u308b", Prefix.NORMAL_ALL),
        GRAY("Gy", "\u3050\u308c\u3044", Prefix.NORMAL_ALL),
        SIEVERT("Sv", "\u3057\u30fc\u3079\u308b\u3068", Prefix.NORMAL_ALL),
        KATAL("kat", "\u304b\u305f\u30fc\u308b", Prefix.NORMAL_ALL),
        KELVIN("k", "\u3051\u308b\u3073\u3093", new Prefix[0]),
        TONS("t", "\u3068\u3093", new Prefix[0]),
        LITER("l", "\u308a\u3063\u3068\u308b", (Prefix[])ArrayUtils.addAll((Object[])Prefix.NORMAL_ALL, (Object[])new Prefix[]{Prefix.DECA, Prefix.DECI}));

        private final String word;
        private final String read;
        private final Prefix[] prefixes;
        private final Pattern pattern;

        private Unit(String word, String read, Prefix ... prefixes) {
            this.word = word;
            this.read = read;
            this.prefixes = prefixes;
            this.pattern = Pattern.compile(word);
        }

        public String getWord() {
            return this.word;
        }

        public String getRead() {
            return this.read;
        }

        public Prefix[] getPrefixes() {
            return this.prefixes;
        }

        public boolean isEndMache(String text) {
            if (this.findPrefix(text)) {
                return true;
            }
            Pattern alphabet = Pattern.compile("[a-zA-Z]+");
            text = alphabet.matcher(text).replaceAll(n -> n.group().toLowerCase(Locale.ROOT));
            if (this.findPrefix(text)) {
                return true;
            }
            text = alphabet.matcher(text).replaceAll(n -> n.group().toUpperCase(Locale.ROOT));
            return this.findPrefix(text);
        }

        private boolean findPrefix(String text) {
            Matcher m = this.pattern.matcher(text);
            int lstm = -1;
            while (m.find()) {
                lstm = m.end();
            }
            return lstm == text.length();
        }

        public static Unit getEndUnit(String text) {
            ArrayList<Unit> maches = new ArrayList<Unit>();
            for (Unit unit : Unit.values()) {
                if (!unit.isEndMache(text)) continue;
                maches.add(unit);
            }
            if (maches.isEmpty()) {
                return null;
            }
            if (maches.size() == 1) {
                return (Unit)((Object)maches.get(0));
            }
            for (Unit unit : maches) {
                if (!unit.word.equals(text)) continue;
                return unit;
            }
            return (Unit)((Object)maches.get(0));
        }
    }

    private static enum Prefix {
        DECI("d", "\u3067\u3057"),
        CENTI("c", "\u305b\u3093\u3061"),
        MILLI("m", "\u307f\u308a"),
        MICRO("\u03bc", "\u307e\u3044\u304f\u308d"),
        NANO("n", "\u306a\u306e"),
        PICO("p", "\u3074\u3053"),
        FEMTO("f", "\u3075\u3047\u3080\u3068"),
        ATTO("a", "\u3042\u3068"),
        ZEPTO("z", "\u305b\u3077\u3068"),
        YOCTO("y", "\u3088\u304f\u3068"),
        RONTO("r", "\u308d\u3093\u3068"),
        QUECTO("q", "\u304f\u3048\u304f\u3068"),
        DECA("da", "\u3067\u304b", true),
        HECTO("h", "\u3078\u304f\u3068", true),
        KILO("k", "\u304d\u308d", true),
        MEGA("m", "\u3081\u304c", true),
        GIGA("g", "\u304e\u304c", true),
        TERA("t", "\u3066\u3089", true),
        PETA("p", "\u307a\u305f", true),
        EXA("e", "\u3048\u304f\u3055", true),
        ZETTA("y", "\u3088\u305f", true),
        YOTTA("z", "\u305c\u305f", true),
        RONNA("r", "\u308d\u306a", true),
        QUETTA("q", "\u304f\u3048\u305f", true);

        private static final Prefix[] NORMAL_UP;
        private static final Prefix[] NORMAL_DOWN;
        private static final Prefix[] NORMAL_ALL;
        private final String word;
        private final String read;
        private final boolean up;

        private Prefix(String word, String read, boolean up) {
            this.word = word;
            this.read = read;
            this.up = up;
        }

        private Prefix(String word, String read) {
            this(word, read, false);
        }

        public String getRead() {
            return this.read;
        }

        public String getWord() {
            return this.word;
        }

        public boolean isUp() {
            return this.up;
        }

        public boolean isMache(String text) {
            return this.word.equalsIgnoreCase(text);
        }

        public static Prefix getPrefix(String text, Unit unit, boolean big) {
            ArrayList<Prefix> prefixes = new ArrayList<Prefix>();
            for (Prefix prefix : unit.getPrefixes()) {
                if (!prefix.isMache(text)) continue;
                prefixes.add(prefix);
            }
            if (prefixes.isEmpty()) {
                return null;
            }
            if (prefixes.size() == 1) {
                return (Prefix)((Object)prefixes.get(0));
            }
            boolean pbig = Character.isUpperCase(text.charAt(0));
            Prefix up = prefixes.stream().filter(Prefix::isUp).findFirst().get();
            Prefix don = prefixes.stream().filter(n -> !n.isUp()).findFirst().get();
            if (!big && pbig) {
                return up;
            }
            return don;
        }

        static {
            NORMAL_UP = new Prefix[]{KILO, MEGA, GIGA, TERA, PETA, EXA, ZETTA, YOTTA, RONNA, QUETTA};
            NORMAL_DOWN = new Prefix[]{CENTI, MILLI, MICRO, NANO, PICO, FEMTO, ATTO, ZEPTO, YOCTO, RONTO, QUECTO};
            NORMAL_ALL = (Prefix[])ArrayUtils.addAll((Object[])NORMAL_UP, (Object[])NORMAL_DOWN);
        }
    }
}

