/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.discord;

import dev.felnull.itts.core.ITTSRuntimeUse;
import dev.felnull.itts.core.discord.DCEventListener;
import dev.felnull.itts.core.discord.command.AdminCommand;
import dev.felnull.itts.core.discord.command.BaseCommand;
import dev.felnull.itts.core.discord.command.ConfigCommand;
import dev.felnull.itts.core.discord.command.DenyCommand;
import dev.felnull.itts.core.discord.command.DictCommand;
import dev.felnull.itts.core.discord.command.InfoCommand;
import dev.felnull.itts.core.discord.command.JoinCommand;
import dev.felnull.itts.core.discord.command.LeaveCommand;
import dev.felnull.itts.core.discord.command.ReconnectCommand;
import dev.felnull.itts.core.discord.command.SkipCommand;
import dev.felnull.itts.core.discord.command.VnickCommand;
import dev.felnull.itts.core.discord.command.VoiceCommand;
import dev.felnull.itts.core.savedata.BotStateData;
import dev.felnull.itts.core.tts.TTSInstance;
import dev.felnull.itts.core.tts.saidtext.StartupSaidText;
import dev.felnull.itts.core.voice.Voice;
import dev.felnull.itts.core.voice.VoiceType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.OnlineStatus;
import net.dv8tion.jda.api.entities.Activity;
import net.dv8tion.jda.api.entities.Guild;
import net.dv8tion.jda.api.entities.channel.middleman.AudioChannel;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.managers.Presence;
import net.dv8tion.jda.api.requests.GatewayIntent;

public class Bot
implements ITTSRuntimeUse {
    protected final List<BaseCommand> baseCommands = new ArrayList<BaseCommand>();
    private JDA jda;

    public void start() {
        this.registeringCommands();
        this.jda = JDABuilder.createDefault((String)this.getConfigManager().getConfig().getBotToken()).enableIntents(GatewayIntent.MESSAGE_CONTENT, new GatewayIntent[0]).addEventListeners(new Object[]{new DCEventListener(this)}).build();
        this.updateCommands(this.jda);
        this.jda.getPresence().setStatus(OnlineStatus.ONLINE);
        this.updateActivity(this.jda.getPresence());
        this.getITTSTimer().schedule(new TimerTask(){

            @Override
            public void run() {
                Bot.this.updateActivityAsync();
            }
        }, 0L, 10000L);
        try {
            this.jda.awaitReady();
            this.reconnect();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void reconnect() {
        CompletableFuture.runAsync(() -> {
            Map<Long, BotStateData> allData = this.getSaveDataManager().getAllBotStateData();
            long selfId = this.getJDA().getSelfUser().getIdLong();
            allData.forEach((guildId, data) -> {
                Guild guild = this.getJDA().getGuildById(guildId.longValue());
                if (guild != null && data.getConnectedAudioChannel() >= 0L && data.getReadAroundTextChannel() >= 0L) {
                    try {
                        AudioChannel audioChannel = (AudioChannel)guild.getChannelById(AudioChannel.class, data.getConnectedAudioChannel());
                        if (audioChannel == null) {
                            return;
                        }
                        MessageChannel chatChannel = (MessageChannel)guild.getChannelById(MessageChannel.class, data.getReadAroundTextChannel());
                        if (chatChannel == null) {
                            return;
                        }
                        this.getTTSManager().setReadAroundChannel(guild, chatChannel);
                        guild.getAudioManager().openAudioConnection(audioChannel);
                        this.getTTSManager().connect(guild, audioChannel);
                        TTSInstance ti = this.getTTSManager().getTTSInstance((long)guildId);
                        VoiceType vt = this.getVoiceManager().getVoiceType((long)guildId, selfId);
                        if (ti != null && vt != null) {
                            Voice voice = vt.createVoice((long)guildId, selfId);
                            ti.sayText(new StartupSaidText(voice));
                        }
                        this.getITTSLogger().info("Reconnected: {}", (Object)guild.getName());
                    }
                    catch (Exception ex) {
                        this.getITTSLogger().error("Failed to reconnect: {}", (Object)guild.getName(), (Object)ex);
                    }
                }
            });
        }, this.getAsyncExecutor());
    }

    private void registeringCommands() {
        this.registerCommand(new JoinCommand());
        this.registerCommand(new LeaveCommand());
        this.registerCommand(new ReconnectCommand());
        this.registerCommand(new VoiceCommand());
        this.registerCommand(new VnickCommand());
        this.registerCommand(new InfoCommand());
        this.registerCommand(new ConfigCommand());
        this.registerCommand(new DenyCommand());
        this.registerCommand(new AdminCommand());
        this.registerCommand(new DictCommand());
        this.registerCommand(new SkipCommand());
    }

    private void registerCommand(BaseCommand command) {
        this.baseCommands.add(command);
    }

    private void updateCommands(JDA jda) {
        jda.updateCommands().addCommands(this.baseCommands.stream().map(BaseCommand::createSlashCommand).toList()).queue();
    }

    public void updateActivityAsync() {
        CompletableFuture.runAsync(() -> this.updateActivity(this.jda.getPresence()), this.getAsyncExecutor());
    }

    public void updateActivity(Presence presence) {
        String vstr = this.getITTSRuntime().getVersionText();
        int ct = this.getTTSManager().getTTSCount();
        if (ct > 0) {
            presence.setActivity(Activity.listening((String)(vstr + " - " + ct + "\u500b\u306e\u30b5\u30fc\u30d0\u30fc\u3067\u8aad\u307f\u4e0a\u3052")));
        } else {
            presence.setActivity(Activity.playing((String)(vstr + " - \u5f85\u6a5f")));
        }
    }

    public JDA getJDA() {
        return this.jda;
    }
}

