/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.discord;

import dev.felnull.itts.core.ITTSRuntimeUse;
import dev.felnull.itts.core.discord.Bot;
import net.dv8tion.jda.api.entities.channel.middleman.AudioChannel;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.entities.channel.unions.AudioChannelUnion;
import net.dv8tion.jda.api.events.guild.voice.GuildVoiceUpdateEvent;
import net.dv8tion.jda.api.events.interaction.command.CommandAutoCompleteInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import org.jetbrains.annotations.NotNull;

public class DCEventListener
extends ListenerAdapter
implements ITTSRuntimeUse {
    private final Bot bot;

    public DCEventListener(@NotNull Bot bot) {
        this.bot = bot;
    }

    public void onSlashCommandInteraction(SlashCommandInteractionEvent event) {
        this.bot.baseCommands.stream().filter(n -> n.isCommandMatch(event)).limit(1L).forEach(r -> r.commandInteraction(event));
    }

    public void onCommandAutoCompleteInteraction(CommandAutoCompleteInteractionEvent event) {
        this.bot.baseCommands.stream().filter(n -> n.isAutoCompleteMatch(event)).limit(1L).forEach(r -> r.autoCompleteInteraction(event));
    }

    public void onMessageReceived(@NotNull MessageReceivedEvent event) {
        this.getTTSManager().sayChat(event.getGuild(), (MessageChannel)event.getChannel(), event.getMember(), event.getMessage().getContentDisplay());
        this.getTTSManager().sayUploadFile(event.getGuild(), (MessageChannel)event.getChannel(), event.getMember(), event.getMessage().getAttachments());
    }

    public void onGuildVoiceUpdate(@NotNull GuildVoiceUpdateEvent event) {
        AudioChannelUnion join = event.getChannelJoined();
        AudioChannelUnion left = event.getChannelLeft();
        if (event.getMember().getUser().getIdLong() == this.bot.getJDA().getSelfUser().getIdLong()) {
            if (left != null) {
                this.getTTSManager().disconnect(event.getGuild());
            }
            if (join != null) {
                this.getTTSManager().connect(event.getGuild(), (AudioChannel)join);
            }
        }
        this.getTTSManager().onVCEvent(event.getGuild(), event.getMember(), join, left);
    }
}

