/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.discord.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.felnull.itts.core.dict.Dictionary;
import dev.felnull.itts.core.dict.DictionaryManager;
import dev.felnull.itts.core.discord.command.BaseCommand;
import dev.felnull.itts.core.savedata.DictData;
import dev.felnull.itts.core.savedata.DictUseData;
import dev.felnull.itts.core.savedata.SaveDataManager;
import dev.felnull.itts.core.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.events.interaction.command.CommandAutoCompleteInteractionEvent;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.interactions.AutoCompleteQuery;
import net.dv8tion.jda.api.interactions.commands.Command;
import net.dv8tion.jda.api.interactions.commands.CommandAutoCompleteInteraction;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.api.interactions.commands.build.Commands;
import net.dv8tion.jda.api.interactions.commands.build.SlashCommandData;
import net.dv8tion.jda.api.interactions.commands.build.SubcommandData;
import net.dv8tion.jda.api.requests.restaction.WebhookMessageCreateAction;
import net.dv8tion.jda.api.requests.restaction.interactions.ReplyCallbackAction;
import net.dv8tion.jda.api.utils.FileUpload;
import org.jetbrains.annotations.NotNull;

public class DictCommand
extends BaseCommand {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public DictCommand() {
        super("dict");
    }

    @Override
    @NotNull
    public SlashCommandData createSlashCommand() {
        return Commands.slash((String)"dict", (String)"\u8aad\u307f\u4e0a\u3052\u8f9e\u66f8").setGuildOnly(true).setDefaultPermissions(OWNERS_PERMISSIONS).addSubcommands(new SubcommandData[]{new SubcommandData("toggle", "\u8f9e\u66f8\u3054\u3068\u306e\u6709\u52b9\u7121\u52b9\u306e\u5207\u308a\u66ff\u3048").addOption(OptionType.STRING, "name", "\u8f9e\u66f8", true, true).addOption(OptionType.BOOLEAN, "enable", "True: \u6709\u52b9\u3001False: \u7121\u52b9", true)}).addSubcommands(new SubcommandData[]{new SubcommandData("toggle-show", "\u8f9e\u66f8\u3054\u3068\u306e\u6709\u52b9\u7121\u52b9\u306e\u8868\u793a")}).addSubcommands(new SubcommandData[]{new SubcommandData("show", "\u30b5\u30fc\u30d0\u30fc\u8aad\u307f\u4e0a\u3052\u8f9e\u66f8\u306e\u5185\u5bb9\u3092\u8868\u793a").addOption(OptionType.STRING, "name", "\u8868\u793a\u3059\u308b\u8f9e\u66f8", true, true)}).addSubcommands(new SubcommandData[]{new SubcommandData("add", "\u30b5\u30fc\u30d0\u30fc\u8aad\u307f\u4e0a\u3052\u8f9e\u66f8\u306b\u5358\u8a9e\u3092\u767b\u9332").addOption(OptionType.STRING, "word", "\u5bfe\u8c61\u306e\u5358\u8a9e", true).addOption(OptionType.STRING, "reading", "\u5bfe\u8c61\u306e\u8aad\u307f", true)}).addSubcommands(new SubcommandData[]{new SubcommandData("remove", "\u30b5\u30fc\u30d0\u30fc\u8aad\u307f\u4e0a\u3052\u8f9e\u66f8\u304b\u3089\u5358\u8a9e\u3092\u524a\u9664").addOption(OptionType.STRING, "word", "\u5bfe\u8c61\u306e\u5358\u8a9e", true, true)}).addSubcommands(new SubcommandData[]{new SubcommandData("download", "\u73fe\u5728\u306e\u8aad\u307f\u4e0a\u3052\u8f9e\u66f8\u3092\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9")}).addSubcommands(new SubcommandData[]{new SubcommandData("upload", "\u8aad\u307f\u4e0a\u3052\u8f9e\u66f8\u3092\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9").addOption(OptionType.ATTACHMENT, "file", "\u8f9e\u66f8\u30d5\u30a1\u30a4\u30eb", true).addOption(OptionType.BOOLEAN, "overwrite", "\u4e0a\u66f8\u304d", true)});
    }

    @Override
    public void commandInteraction(SlashCommandInteractionEvent event) {
        switch (Objects.requireNonNull(event.getSubcommandName())) {
            case "toggle": {
                this.toggle(event);
                break;
            }
            case "toggle-show": {
                this.toggleShow(event);
                break;
            }
            case "add": {
                this.add(event);
                break;
            }
            case "remove": {
                this.remove(event);
                break;
            }
            case "download": {
                this.download(event);
                break;
            }
            case "upload": {
                this.upload(event);
                break;
            }
            case "show": {
                this.show(event);
            }
        }
    }

    private void show(SlashCommandInteractionEvent event) {
        String dictId = Objects.requireNonNull((String)event.getOption("name", OptionMapping::getAsString));
        long guildId = event.getGuild().getIdLong();
        DictionaryManager dm = this.getDictionaryManager();
        Dictionary dic = dm.getDictionary(dictId, guildId);
        if (dic == null) {
            event.reply("\u5b58\u5728\u3057\u306a\u3044\u8f9e\u66f8\u3067\u3059\u3002").setEphemeral(true).queue();
            return;
        }
        EmbedBuilder replayEmbedBuilder = new EmbedBuilder();
        replayEmbedBuilder.setColor(this.getConfigManager().getConfig().getThemeColor());
        Object title = dic.getName();
        if (dic.isBuiltIn()) {
            title = (String)title + " [\u7d44\u307f\u8fbc\u307f]";
        }
        title = (String)title + " (\u512a\u5148\u5ea6: " + dic.getPriority() + ")";
        replayEmbedBuilder.setTitle((String)title);
        Map<String, String> show = dic.getShowInfo(guildId);
        if (show.isEmpty()) {
            replayEmbedBuilder.addField("\u767b\u9332\u306a\u3057", "", false);
        } else {
            show.forEach((k, v) -> this.addDictWordAndReadingField(replayEmbedBuilder, (String)k, (String)v));
        }
        if (show.size() >= 2) {
            replayEmbedBuilder.setFooter("\u8a08" + show.size() + "\u500b");
        }
        event.replyEmbeds(replayEmbedBuilder.build(), new MessageEmbed[0]).setEphemeral(true).queue();
    }

    private void upload(SlashCommandInteractionEvent event) {
        long guildId = event.getGuild().getIdLong();
        Message.Attachment file = Objects.requireNonNull((Message.Attachment)event.getOption("file", OptionMapping::getAsAttachment));
        boolean overwrite = Objects.requireNonNull((Boolean)event.getOption("overwrite", OptionMapping::getAsBoolean));
        event.deferReply().queue();
        ((CompletableFuture)((CompletableFuture)file.getProxy().download().thenApplyAsync(stream -> {
            try (BufferedInputStream st = new BufferedInputStream((InputStream)stream);){
                JsonObject jsonObject;
                try (InputStreamReader reader = new InputStreamReader(st);){
                    jsonObject = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                }
                return jsonObject;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, this.getHeavyExecutor())).thenApplyAsync(jo -> this.getDictionaryManager().serverDictLoadFromJson((JsonObject)jo, guildId, overwrite), this.getHeavyExecutor())).whenCompleteAsync((ret, error) -> {
            if (error == null) {
                if (ret.isEmpty()) {
                    event.getHook().sendMessage("\u65b0\u3057\u304f\u5358\u8a9e\u306f\u767b\u9332\u3055\u308c\u307e\u305b\u3093\u3067\u3057\u305f").queue();
                    return;
                }
                EmbedBuilder replayEmbedBuilder = new EmbedBuilder();
                replayEmbedBuilder.setColor(this.getConfigManager().getConfig().getThemeColor());
                replayEmbedBuilder.setTitle("\u767b\u9332\u3055\u308c\u305f\u5358\u8a9e\u3068\u8aad\u307f");
                for (DictData dictData : ret) {
                    this.addDictWordAndReadingField(replayEmbedBuilder, dictData.getTarget(), dictData.getRead());
                }
                ((WebhookMessageCreateAction)event.getHook().sendMessageEmbeds(replayEmbedBuilder.build(), new MessageEmbed[0]).addContent(overwrite ? "\u4ee5\u4e0b\u306e\u5358\u8a9e\u306e\u8aad\u307f\u3092\u4e0a\u66f8\u304d\u767b\u9332\u3057\u307e\u3057\u305f" : "\u4ee5\u4e0b\u306e\u5358\u8a9e\u306e\u8aad\u307f\u3092\u767b\u9332\u3057\u307e\u3057\u305f")).queue();
            } else {
                this.getITTSLogger().error("Dictionary registration failure", error);
                event.getHook().sendMessage("\u8f9e\u66f8\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u307f\u8fbc\u307f\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f").queue();
            }
        }, this.getAsyncExecutor());
    }

    private void download(SlashCommandInteractionEvent event) {
        long guildId = event.getGuild().getIdLong();
        if (this.getSaveDataManager().getAllServerDictData(guildId).isEmpty()) {
            event.reply("\u8f9e\u66f8\u306f\u7a7a\u3067\u3059").setEphemeral(true).queue();
            return;
        }
        event.deferReply(true).queue();
        CompletableFuture.supplyAsync(() -> {
            JsonObject jo = new JsonObject();
            this.getDictionaryManager().serverDictSaveToJson(jo, guildId);
            return GSON.toJson((JsonElement)jo).getBytes(StandardCharsets.UTF_8);
        }, this.getHeavyExecutor()).thenAcceptAsync(data -> event.getHook().sendFiles(new FileUpload[]{FileUpload.fromData((byte[])data, (String)(guildId + "_dict.json"))}).setEphemeral(true).queue(), this.getAsyncExecutor());
    }

    private void remove(SlashCommandInteractionEvent event) {
        String word = Objects.requireNonNull((String)event.getOption("word", OptionMapping::getAsString));
        long guildId = event.getGuild().getIdLong();
        DictData dictData = this.getSaveDataManager().getServerDictData(guildId, word);
        if (dictData == null) {
            event.reply("\u672a\u767b\u9332\u306e\u5358\u8a9e\u3067\u3059").setEphemeral(true).queue();
            return;
        }
        this.getSaveDataManager().removeServerDictData(guildId, word);
        EmbedBuilder replayEmbedBuilder = new EmbedBuilder();
        replayEmbedBuilder.setColor(this.getConfigManager().getConfig().getThemeColor());
        replayEmbedBuilder.setTitle("\u524a\u9664\u3055\u308c\u305f\u5358\u8a9e\u3068\u8aad\u307f");
        this.addDictWordAndReadingField(replayEmbedBuilder, word, dictData.getRead());
        ((ReplyCallbackAction)event.replyEmbeds(replayEmbedBuilder.build(), new MessageEmbed[0]).addContent("\u4ee5\u4e0b\u306e\u5358\u8a9e\u3092\u8f9e\u66f8\u304b\u3089\u524a\u9664\u3057\u307e\u3057\u305f")).queue();
    }

    private void add(SlashCommandInteractionEvent event) {
        String word = Objects.requireNonNull((String)event.getOption("word", OptionMapping::getAsString));
        String reading = Objects.requireNonNull((String)event.getOption("reading", OptionMapping::getAsString));
        if (word.length() > 1000 || reading.length() > 1000) {
            event.reply("\u767b\u9332\u53ef\u80fd\u306a\u6700\u5927\u6587\u5b57\u6570\u306f1000\u6587\u5b57\u3067\u3059").queue();
            return;
        }
        long guildId = event.getGuild().getIdLong();
        boolean overwrite = this.getSaveDataManager().getServerDictData(guildId, word) != null;
        this.getSaveDataManager().addServerDictData(guildId, word, reading);
        EmbedBuilder replayEmbedBuilder = new EmbedBuilder();
        replayEmbedBuilder.setColor(this.getConfigManager().getConfig().getThemeColor());
        replayEmbedBuilder.setTitle("\u767b\u9332\u3055\u308c\u305f\u5358\u8a9e\u3068\u8aad\u307f");
        this.addDictWordAndReadingField(replayEmbedBuilder, word, reading);
        ((ReplyCallbackAction)event.replyEmbeds(replayEmbedBuilder.build(), new MessageEmbed[0]).addContent(overwrite ? "\u4ee5\u4e0b\u306e\u5358\u8a9e\u306e\u8aad\u307f\u3092\u4e0a\u66f8\u304d\u767b\u9332\u3057\u307e\u3057\u305f" : "\u4ee5\u4e0b\u306e\u5358\u8a9e\u306e\u8aad\u307f\u3092\u767b\u9332\u3057\u307e\u3057\u305f")).queue();
    }

    private void addDictWordAndReadingField(EmbedBuilder builder, String word, String reading) {
        String w = "` " + word.replace("\n", "\\n") + " `";
        String r = "```" + reading.replace("```", "\\```") + "```";
        builder.addField(w, r, false);
    }

    private void toggleShow(SlashCommandInteractionEvent event) {
        EmbedBuilder replayEmbedBuilder = new EmbedBuilder();
        replayEmbedBuilder.setColor(this.getConfigManager().getConfig().getThemeColor());
        replayEmbedBuilder.setTitle("\u73fe\u5728\u306e\u8f9e\u66f8\u306e\u5207\u308a\u66ff\u3048\u72b6\u6cc1");
        long guildId = event.getGuild().getIdLong();
        DictionaryManager dictManager = this.getDictionaryManager();
        List<Dictionary> dicts = dictManager.getAllDictionaries(guildId);
        for (Dictionary dict : dicts) {
            replayEmbedBuilder.addField(dict.getName(), dictManager.isEnable(dict, guildId) ? "\u6709\u52b9" : "\u7121\u52b9", false);
        }
        event.replyEmbeds(replayEmbedBuilder.build(), new MessageEmbed[0]).setEphemeral(true).queue();
    }

    private void toggle(SlashCommandInteractionEvent event) {
        String dictId = Objects.requireNonNull((String)event.getOption("name", OptionMapping::getAsString));
        boolean enabled = Boolean.TRUE.equals(event.getOption("enable", OptionMapping::getAsBoolean));
        String enStr = enabled ? "\u6709\u52b9" : "\u7121\u52b9";
        long guildId = event.getGuild().getIdLong();
        DictionaryManager dm = this.getDictionaryManager();
        SaveDataManager sm = this.getSaveDataManager();
        Dictionary dic = dm.getDictionary(dictId, guildId);
        if (dic == null) {
            event.reply("\u5b58\u5728\u3057\u306a\u3044\u8f9e\u66f8\u3067\u3059\u3002").setEphemeral(true).queue();
            return;
        }
        DictUseData dud = sm.getDictUseData(guildId, dictId);
        if (dud == null && !enabled || dud != null && enabled) {
            event.reply(dic.getName() + "\u306f\u65e2\u306b" + enStr + "\u3067\u3059\u3002").setEphemeral(true).queue();
            return;
        }
        if (enabled) {
            sm.addDictUseData(guildId, dictId, dic.getPriority());
        } else {
            sm.removeDictUseData(guildId, dictId);
        }
        event.reply(dic.getName() + "\u3092" + enStr + "\u306b\u3057\u307e\u3057\u305f\u3002").queue();
    }

    @Override
    public void autoCompleteInteraction(CommandAutoCompleteInteractionEvent event) {
        Objects.requireNonNull(event.getGuild());
        CommandAutoCompleteInteraction interact = event.getInteraction();
        AutoCompleteQuery fcs = interact.getFocusedOption();
        long guildId = event.getGuild().getIdLong();
        if (("toggle".equals(interact.getSubcommandName()) || "show".equals(interact.getSubcommandName())) && "name".equals(fcs.getName())) {
            DictionaryManager dm = this.getDictionaryManager();
            event.replyChoices(dm.getAllDictionaries(guildId).stream().sorted(Comparator.comparingInt(d -> -StringUtils.getComplementPoint(d.getName(), fcs.getValue()))).limit(25L).map(n -> new Command.Choice(n.getName(), n.getId())).toList()).queue();
        } else if ("remove".equals(interact.getSubcommandName()) && "word".equals(fcs.getName())) {
            event.replyChoices(this.getSaveDataManager().getAllServerDictData(guildId).stream().sorted(Comparator.comparingInt(d -> -StringUtils.getComplementPoint(d.getTarget(), fcs.getValue()))).limit(25L).map(it -> new Command.Choice(it.getTarget() + " -> " + it.getRead(), it.getTarget())).toList()).queue();
        }
    }
}

