/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.discord.command;

import dev.felnull.itts.core.discord.command.BaseCommand;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.GuildVoiceState;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.channel.ChannelType;
import net.dv8tion.jda.api.entities.channel.middleman.AudioChannel;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.events.interaction.command.SlashCommandInteractionEvent;
import net.dv8tion.jda.api.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.api.interactions.commands.OptionMapping;
import net.dv8tion.jda.api.interactions.commands.OptionType;
import net.dv8tion.jda.api.interactions.commands.build.Commands;
import net.dv8tion.jda.api.interactions.commands.build.OptionData;
import net.dv8tion.jda.api.interactions.commands.build.SlashCommandData;
import net.dv8tion.jda.api.managers.AudioManager;
import org.jetbrains.annotations.NotNull;

public class JoinCommand
extends BaseCommand {
    public JoinCommand() {
        super("join");
    }

    @Override
    @NotNull
    public SlashCommandData createSlashCommand() {
        return Commands.slash((String)"join", (String)"\u8aad\u307f\u4e0a\u3052BOT\u3092VC\u306b\u547c\u3073\u51fa\u3059").addOptions(new OptionData[]{new OptionData(OptionType.CHANNEL, "channel", "\u30c1\u30e3\u30f3\u30cd\u30eb\u6307\u5b9a").setChannelTypes(new ChannelType[]{ChannelType.VOICE, ChannelType.STAGE})}).setGuildOnly(true).setDefaultPermissions(MEMBERS_PERMISSIONS);
    }

    @Override
    public void commandInteraction(SlashCommandInteractionEvent event) {
        OptionMapping interactionChannel = event.getInteraction().getOption("channel");
        AudioChannel joinTargetChannel = null;
        if (interactionChannel != null) {
            joinTargetChannel = interactionChannel.getAsChannel().asAudioChannel();
        } else {
            Member member = event.getMember();
            GuildVoiceState vs = member.getVoiceState();
            if (vs != null) {
                joinTargetChannel = vs.getChannel();
            }
        }
        if (joinTargetChannel == null) {
            event.reply("VC\u306b\u53c2\u52a0\u3057\u3066\u3044\u308b\u72b6\u614b\u3067\u4f7f\u7528\u3059\u308b\u304b\u3001\u30c1\u30e3\u30f3\u30cd\u30eb\u3092\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002").setEphemeral(true).queue();
            return;
        }
        AudioManager audioManager = event.getGuild().getAudioManager();
        if (audioManager.isConnected() && audioManager.getConnectedChannel() != null && audioManager.getConnectedChannel().getIdLong() == joinTargetChannel.getIdLong()) {
            event.reply("\u3059\u3067\u306b\u63a5\u7d9a\u3057\u3066\u3044\u307e\u3059").setEphemeral(true).queue();
            return;
        }
        this.getTTSManager().setReadAroundChannel(event.getGuild(), (MessageChannel)event.getChannel());
        try {
            audioManager.openAudioConnection(joinTargetChannel);
        }
        catch (InsufficientPermissionException ex) {
            if (ex.getPermission() == Permission.VOICE_CONNECT) {
                event.reply(joinTargetChannel.getAsMention() + "\u306b\u63a5\u7d9a\u3059\u308b\u6a29\u9650\u304c\u3042\u308a\u307e\u305b\u3093\u3002").setEphemeral(true).queue();
            } else {
                event.reply(joinTargetChannel.getAsMention() + "\u63a5\u7d9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002").setEphemeral(true).queue();
            }
            return;
        }
        event.reply(joinTargetChannel.getAsMention() + "\u306b\u63a5\u7d9a\u3057\u307e\u3057\u305f\u3002").queue();
    }
}

