/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.savedata;

import dev.felnull.itts.core.ITTSBaseManager;
import dev.felnull.itts.core.savedata.BotStateData;
import dev.felnull.itts.core.savedata.DictData;
import dev.felnull.itts.core.savedata.DictUseData;
import dev.felnull.itts.core.savedata.SaveDataAccess;
import dev.felnull.itts.core.savedata.ServerData;
import dev.felnull.itts.core.savedata.ServerUserData;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class SaveDataManager
implements ITTSBaseManager {
    private final SaveDataAccess saveDataAccess;

    public SaveDataManager(SaveDataAccess saveDataAccess) {
        this.saveDataAccess = saveDataAccess;
    }

    @Override
    @NotNull
    public CompletableFuture<?> init() {
        return CompletableFuture.runAsync(() -> {
            if (!this.saveDataAccess.init()) {
                throw new RuntimeException("Failed to initialize");
            }
            this.getITTSLogger().info("Save data setup complete");
        }, this.getAsyncExecutor());
    }

    @NotNull
    public ServerData getServerData(long guildId) {
        return this.saveDataAccess.getServerData(guildId);
    }

    @NotNull
    public ServerUserData getServerUserData(long guildId, long userId) {
        return this.saveDataAccess.getServerUserData(guildId, userId);
    }

    @NotNull
    public @Unmodifiable List<DictUseData> getAllDictUseData(long guildId) {
        return this.saveDataAccess.getAllDictUseData(guildId);
    }

    @Nullable
    public DictUseData getDictUseData(long guildId, @NotNull String dictId) {
        return this.saveDataAccess.getDictUseData(guildId, dictId);
    }

    public void addDictUseData(long guildId, @NotNull String dictId, int priority) {
        this.saveDataAccess.addDictUseData(guildId, dictId, priority);
    }

    public void removeDictUseData(long guildId, @NotNull String dictId) {
        this.saveDataAccess.removeDictUseData(guildId, dictId);
    }

    @NotNull
    public BotStateData getBotStateData(long guildId) {
        return this.saveDataAccess.getBotStateData(guildId);
    }

    @NotNull
    public @Unmodifiable Map<Long, BotStateData> getAllBotStateData() {
        return this.saveDataAccess.getAllBotStateData();
    }

    @NotNull
    public @Unmodifiable List<DictData> getAllServerDictData(long guildId) {
        return this.saveDataAccess.getAllServerDictData(guildId);
    }

    @Nullable
    public DictData getServerDictData(long guildId, @NotNull String target) {
        return this.saveDataAccess.getServerDictData(guildId, target);
    }

    public void addServerDictData(long guildId, @NotNull String target, @NotNull String read) {
        this.saveDataAccess.addServerDictData(guildId, target, read);
    }

    public void removeServerDictData(long guildId, @NotNull String target) {
        this.saveDataAccess.removeServerDictData(guildId, target);
    }

    @NotNull
    public @Unmodifiable List<DictData> getAllGlobalDictData() {
        return this.saveDataAccess.getAllGlobalDictData();
    }

    @Nullable
    public DictData getGlobalDictData(@NotNull String target) {
        return this.saveDataAccess.getGlobalDictData(target);
    }

    public void addGlobalDictData(@NotNull String target, @NotNull String read) {
        this.saveDataAccess.addGlobalDictData(target, read);
    }

    public void removeGlobalDictData(@NotNull String target) {
        this.saveDataAccess.removeGlobalDictData(target);
    }

    @NotNull
    public @Unmodifiable List<Long> getAllDenyUser(long guildId) {
        return this.saveDataAccess.getAllDenyUser(guildId);
    }
}

