/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.tts;

import dev.felnull.itts.core.ITTSRuntimeUse;
import dev.felnull.itts.core.audio.LoadedSaidText;
import dev.felnull.itts.core.audio.VoiceAudioScheduler;
import dev.felnull.itts.core.tts.VCEventSaidRegulator;
import dev.felnull.itts.core.tts.saidtext.SaidText;
import dev.felnull.itts.core.tts.saidtext.VCEventSaidText;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.dv8tion.jda.api.entities.Guild;

public final class TTSInstance
implements ITTSRuntimeUse {
    private static final int MAX_COUNT = 150;
    private static final int LOAD_COUNT = 10;
    private static final int NEXT_WAIT_TIME = 500;
    private final ConcurrentLinkedQueue<SaidText> saidTextQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<LoadedSaidTextEntry> loadSaidTextQueue = new ConcurrentLinkedQueue();
    private final AtomicReference<LoadedSaidTextEntry> currentSaidText = new AtomicReference();
    private final VCEventSaidRegulator vcEventSaidRegulator = new VCEventSaidRegulator(this);
    private final AtomicBoolean next = new AtomicBoolean(true);
    private final AtomicBoolean destroyed = new AtomicBoolean();
    private final Object updateLock = new Object();
    private final VoiceAudioScheduler voiceAudioScheduler;
    private final AtomicReference<UUID> currentReadAloudUUID = new AtomicReference();
    private final long audioChannel;
    private final long textChannel;
    private final boolean overwriteAloud;

    public TTSInstance(Guild guild, long audioChannel, long textChannel, boolean overwriteAloud) {
        this.voiceAudioScheduler = new VoiceAudioScheduler(guild.getAudioManager(), this.getVoiceAudioManager(), guild.getIdLong());
        this.audioChannel = audioChannel;
        this.textChannel = textChannel;
        this.overwriteAloud = overwriteAloud;
    }

    public long getAudioChannel() {
        return this.audioChannel;
    }

    public long getTextChannel() {
        return this.textChannel;
    }

    public void dispose() {
        this.destroyed.set(true);
        this.vcEventSaidRegulator.dispose();
        this.saidTextQueue.clear();
        while (!this.loadSaidTextQueue.isEmpty()) {
            this.loadSaidTextQueue.poll().dispose();
        }
        LoadedSaidTextEntry cst = this.currentSaidText.get();
        if (cst != null) {
            cst.dispose();
        }
        this.voiceAudioScheduler.dispose();
    }

    public void sayText(SaidText saidText) {
        if (this.saidTextQueue.size() >= 150) {
            return;
        }
        if (this.overwriteAloud) {
            this.updateAloud(saidText);
        } else {
            VCEventSaidText vst;
            if (saidText instanceof VCEventSaidText && this.vcEventSaidRegulator.restrict((vst = (VCEventSaidText)saidText).getMember().getUser().getIdLong(), vst)) {
                return;
            }
            this.saidTextQueue.add(saidText);
            this.updateQueue();
        }
    }

    public int skipAll() {
        this.currentReadAloudUUID.set(UUID.randomUUID());
        this.voiceAudioScheduler.stop();
        if (this.overwriteAloud) {
            LoadedSaidTextEntry lste = this.currentSaidText.getAndSet(null);
            if (lste != null) {
                lste.dispose();
                return 1;
            }
        } else {
            int ct = 0;
            ct += this.saidTextQueue.size();
            this.saidTextQueue.clear();
            ct += this.loadSaidTextQueue.size();
            while (!this.loadSaidTextQueue.isEmpty()) {
                this.loadSaidTextQueue.poll().dispose();
            }
            LoadedSaidTextEntry lste = this.currentSaidText.getAndSet(null);
            if (lste != null) {
                lste.dispose();
                ++ct;
            }
            this.next.compareAndSet(false, true);
            this.updateQueue();
            return ct;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAloud(SaidText saidText) {
        Object object = this.updateLock;
        synchronized (object) {
            if (this.destroyed.get()) {
                return;
            }
            this.voiceAudioScheduler.stop();
            LoadedSaidTextEntry cst = this.currentSaidText.getAndSet(new LoadedSaidTextEntry(saidText));
            if (cst != null) {
                cst.dispose();
            }
            this.sayStart();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateQueue() {
        Object object = this.updateLock;
        synchronized (object) {
            if (this.destroyed.get() || this.overwriteAloud) {
                return;
            }
            this.loadSaidTextQueue.removeIf(r -> {
                if (r.isFailure()) {
                    r.dispose();
                    return true;
                }
                return false;
            });
            while (this.loadSaidTextQueue.size() < 10 && !this.saidTextQueue.isEmpty()) {
                this.loadSaidTextQueue.add(new LoadedSaidTextEntry(this.saidTextQueue.poll()));
            }
            LoadedSaidTextEntry cst = this.currentSaidText.get();
            if ((cst == null || cst.isFailure() || cst.isAlreadyUsed()) && this.next.get()) {
                if (cst != null) {
                    cst.dispose();
                }
                if (!this.loadSaidTextQueue.isEmpty()) {
                    this.currentSaidText.set(this.loadSaidTextQueue.poll());
                    this.sayStart();
                } else {
                    this.currentSaidText.set(null);
                }
                while (!this.saidTextQueue.isEmpty()) {
                    this.loadSaidTextQueue.add(new LoadedSaidTextEntry(this.saidTextQueue.poll()));
                }
            }
        }
    }

    private void sayStart() {
        final UUID uuid = UUID.randomUUID();
        this.currentReadAloudUUID.set(uuid);
        this.currentSaidText.get().completableFuture.whenCompleteAsync((loadedSaidText, throwable) -> {
            if (!uuid.equals(this.currentReadAloudUUID.get())) {
                return;
            }
            if (throwable != null) {
                if (!(throwable instanceof CancellationException)) {
                    this.getITTSLogger().error("Failed to load voice audio", throwable);
                }
                if (!this.overwriteAloud) {
                    this.updateQueue();
                }
                return;
            }
            if (loadedSaidText.isFailure()) {
                this.updateQueue();
            } else {
                this.next.set(false);
                this.voiceAudioScheduler.play((LoadedSaidText)loadedSaidText, () -> {
                    if (!uuid.equals(this.currentReadAloudUUID.get())) {
                        return;
                    }
                    if (this.overwriteAloud) {
                        loadedSaidText.dispose();
                    }
                    if (!this.overwriteAloud) {
                        this.updateQueue();
                        this.getITTSTimer().schedule(new TimerTask(){

                            @Override
                            public void run() {
                                CompletableFuture.runAsync(() -> {
                                    if (!uuid.equals(TTSInstance.this.currentReadAloudUUID.get())) {
                                        return;
                                    }
                                    TTSInstance.this.next.set(true);
                                    TTSInstance.this.updateQueue();
                                }, TTSInstance.this.getAsyncExecutor());
                            }
                        }, 500L);
                    }
                });
            }
        }, this.getAsyncExecutor());
    }

    private class LoadedSaidTextEntry {
        private final SaidText saidText;
        private final CompletableFuture<LoadedSaidText> completableFuture;
        private final AtomicBoolean failure = new AtomicBoolean();

        private LoadedSaidTextEntry(SaidText saidText) {
            this.saidText = saidText;
            this.completableFuture = TTSInstance.this.voiceAudioScheduler.load(saidText);
            this.completableFuture.whenCompleteAsync((loadedSaidText, throwable) -> this.failure.set(throwable != null), TTSInstance.this.getAsyncExecutor());
        }

        private void dispose() {
            this.completableFuture.thenAcceptAsync(LoadedSaidText::dispose, TTSInstance.this.getAsyncExecutor());
        }

        public SaidText getSaidText() {
            return this.saidText;
        }

        private boolean isFailure() {
            if (this.completableFuture.isDone()) {
                try {
                    return this.completableFuture.get().isFailure();
                }
                catch (InterruptedException | ExecutionException exception) {
                    // empty catch block
                }
            }
            return this.failure.get();
        }

        private boolean isAlreadyUsed() {
            if (this.completableFuture.isDone()) {
                try {
                    return this.completableFuture.get().isAlreadyUsed();
                }
                catch (InterruptedException | ExecutionException exception) {
                    // empty catch block
                }
            }
            return false;
        }
    }
}

