/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.util;

import dev.felnull.itts.core.ITTSRuntime;
import dev.felnull.itts.core.savedata.ServerData;
import dev.felnull.itts.core.savedata.ServerUserData;
import dev.felnull.itts.core.util.DiscordUtils;
import dev.felnull.itts.core.voice.Voice;
import java.util.Objects;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.channel.middleman.StandardGuildChannel;
import org.jetbrains.annotations.NotNull;

public final class TTSUtils {
    @NotNull
    public static String getTTSName(Voice voice, @NotNull Member member) {
        User user = member.getUser();
        ServerUserData sud = ITTSRuntime.getInstance().getSaveDataManager().getServerUserData(member.getGuild().getIdLong(), user.getIdLong());
        String nick = sud.getNickName();
        String ret = Objects.requireNonNullElseGet(nick, () -> DiscordUtils.getName(member));
        return TTSUtils.roundText(voice, member.getGuild().getIdLong(), ret, true);
    }

    public static String roundText(Voice voice, long guildId, String text, boolean name) {
        int max;
        ServerData sud = ITTSRuntime.getInstance().getSaveDataManager().getServerData(guildId);
        int n = max = name ? sud.getNameReadLimit() : Math.min(sud.getReadLimit(), voice.getReadLimit());
        if (text.length() <= max) {
            return text;
        }
        String st = text.substring(0, max);
        if (name) {
            return st + "\u4ee5\u4e0b\u7565";
        }
        int r = text.length() - max;
        return st + "\u4ee5\u4e0b" + r + "\u6587\u5b57\u3092\u7701\u7565";
    }

    @NotNull
    public static String getTTSChannelName(@NotNull StandardGuildChannel channel) {
        if (channel.getPermissionOverrides().isEmpty()) {
            return channel.getName();
        }
        return "\u5225\u306e\u30c1\u30e3\u30f3\u30cd\u30eb";
    }
}

