/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.voice;

import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import dev.felnull.itts.core.audio.loader.CachedVoiceTrackLoader;
import dev.felnull.itts.core.audio.loader.VoiceTrackLoader;
import dev.felnull.itts.core.voice.BaseVoice;
import dev.felnull.itts.core.voice.VoiceType;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public abstract class CachedVoice
extends BaseVoice {
    protected CachedVoice(VoiceType voiceType) {
        super(voiceType);
    }

    protected abstract InputStream openVoiceStream(String var1) throws IOException, InterruptedException;

    protected abstract String createHashCodeChars();

    @Override
    public VoiceTrackLoader createVoiceTrackLoader(String text) {
        HashCode hash = Hashing.murmur3_128().newHasher().putString((CharSequence)this.voiceType.getId(), StandardCharsets.UTF_8).putString((CharSequence)text, StandardCharsets.UTF_8).putString((CharSequence)this.createHashCodeChars(), StandardCharsets.UTF_8).hash();
        return new CachedVoiceTrackLoader(hash, () -> {
            if (!this.isAvailable()) {
                throw new RuntimeException("Voice is not available");
            }
            return this.openVoiceStream(text);
        });
    }
}

