/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.voice.voicetext;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import dev.felnull.fnjl.util.FNStringUtil;
import dev.felnull.itts.core.ITTSRuntimeUse;
import dev.felnull.itts.core.voice.VoiceType;
import dev.felnull.itts.core.voice.voicetext.VoiceTextSpeaker;
import dev.felnull.itts.core.voice.voicetext.VoiceTextVoiceCategory;
import dev.felnull.itts.core.voice.voicetext.VoiceTextVoiceType;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class VoiceTextManager
implements ITTSRuntimeUse {
    private static final String API_URL = "https://api.voicetext.jp/v1/tts";
    private static final Gson GSON = new Gson();
    private final VoiceTextVoiceCategory category = new VoiceTextVoiceCategory();
    private final List<VoiceType> voiceTypes = Arrays.stream(VoiceTextSpeaker.values()).map(VoiceTextVoiceType::new).map(t -> t).toList();

    public VoiceTextVoiceCategory getCategory() {
        return this.category;
    }

    public List<VoiceType> getVoiceTypes() {
        return this.voiceTypes;
    }

    private String getApiKey() {
        return this.getConfigManager().getConfig().getVoiceTextConfig().getApiKey();
    }

    public boolean isAvailable() {
        return this.getConfigManager().getConfig().getVoiceTextConfig().isEnable();
    }

    public InputStream openVoiceStream(@NotNull VoiceTextSpeaker speaker, @NotNull String text) throws IOException, InterruptedException {
        text = URLEncoder.encode(text, StandardCharsets.UTF_8);
        HttpClient hc = HttpClient.newHttpClient();
        String basic = "Basic " + FNStringUtil.encodeBase64((String)(this.getApiKey() + ":"));
        HttpRequest request = HttpRequest.newBuilder(URI.create(API_URL)).header("Authorization", basic).header("Content-Type", "application/x-www-form-urlencoded; charset=utf-8").POST(HttpRequest.BodyPublishers.ofString(String.format("text=%s&speaker=%s", text, speaker.getId()))).version(HttpClient.Version.HTTP_1_1).build();
        HttpResponse<InputStream> res = hc.send(request, HttpResponse.BodyHandlers.ofInputStream());
        Optional<String> content = res.headers().firstValue("content-type");
        int code = res.statusCode();
        if (content.isEmpty()) {
            throw new IOException("Content Type does not exist: " + code);
        }
        if (content.get().startsWith("audio/")) {
            return res.body();
        }
        if ("application/json".equals(content.get())) {
            try {
                BufferedInputStream stream = new BufferedInputStream(res.body());
                try {
                    InputStreamReader reader = new InputStreamReader(stream);
                    try {
                        JsonObject jo = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                        JsonObject ejo = jo.getAsJsonObject("error");
                        throw new IOException("VoiceText error (" + ejo.get("message").getAsString() + "): " + code);
                    }
                    catch (Throwable throwable) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        ((InputStream)stream).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (JsonSyntaxException jsonSyntaxException) {
                // empty catch block
            }
        }
        throw new IOException("Not audio data: " + code);
    }
}

