/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.voice.voicetext;

import com.google.common.base.CaseFormat;
import dev.felnull.itts.core.ITTSRuntime;
import dev.felnull.itts.core.voice.Voice;
import dev.felnull.itts.core.voice.VoiceCategory;
import dev.felnull.itts.core.voice.VoiceType;
import dev.felnull.itts.core.voice.voicetext.VoiceTextManager;
import dev.felnull.itts.core.voice.voicetext.VoiceTextSpeaker;
import dev.felnull.itts.core.voice.voicetext.VoiceTextVoice;

public class VoiceTextVoiceType
implements VoiceType {
    private final VoiceTextSpeaker speakers;

    public VoiceTextVoiceType(VoiceTextSpeaker speakers) {
        this.speakers = speakers;
    }

    @Override
    public String getName() {
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.speakers.getId()) + " (" + this.speakers.getName() + ")";
    }

    @Override
    public String getId() {
        return this.speakers.getId();
    }

    @Override
    public boolean isAvailable() {
        return this.getCategory().isAvailable();
    }

    @Override
    public VoiceCategory getCategory() {
        return this.getVoiceTextManager().getCategory();
    }

    @Override
    public Voice createVoice(long guildId, long userId) {
        return new VoiceTextVoice(this, this.speakers);
    }

    private VoiceTextManager getVoiceTextManager() {
        return ITTSRuntime.getInstance().getVoiceManager().getVoiceTextManager();
    }
}

