/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.voice.voicevox;

import com.google.common.collect.ImmutableList;
import dev.felnull.itts.core.ITTSRuntimeUse;
import dev.felnull.itts.core.voice.voicevox.VVURL;
import dev.felnull.itts.core.voice.voicevox.VoicevoxManager;
import dev.felnull.itts.core.voice.voicevox.VoicevoxSpeaker;
import dev.felnull.itts.core.voice.voicevox.VoicevoxUseURL;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.Pair;

public class VoicevoxBalancer
implements ITTSRuntimeUse {
    private final VoicevoxManager manager;
    private final Supplier<List<String>> enginUrls;
    private final Object checkLock = new Object();
    private final Map<VVURL, AtomicInteger> useCounter = new ConcurrentHashMap<VVURL, AtomicInteger>();
    private List<VVURL> availableUrls;
    private List<VoicevoxSpeaker> availableSpeakers;

    public VoicevoxBalancer(VoicevoxManager manager, Supplier<List<String>> enginUrls) {
        this.manager = manager;
        this.enginUrls = enginUrls;
    }

    private AtomicInteger getUseCounter(VVURL vvurl) {
        return this.useCounter.computeIfAbsent(vvurl, k -> new AtomicInteger());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<VoicevoxSpeaker> getAvailableSpeakers() {
        Object object = this.checkLock;
        synchronized (object) {
            if (this.availableSpeakers == null) {
                return ImmutableList.of();
            }
            return this.availableSpeakers;
        }
    }

    public CompletableFuture<?> init() {
        return CompletableFuture.runAsync(this::check, this.getAsyncExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check() {
        Object object = this.checkLock;
        synchronized (object) {
            Pair<List<VVURL>, List<VoicevoxSpeaker>> cr = this.checkAndGet();
            this.availableUrls = (List)cr.getLeft();
            this.availableSpeakers = (List)cr.getRight();
        }
        this.getITTSTimer().schedule(new TimerTask(){

            @Override
            public void run() {
                CompletableFuture.runAsync(() -> VoicevoxBalancer.this.check(), VoicevoxBalancer.this.getAsyncExecutor());
            }
        }, this.manager.getConfig().getCheckTime());
    }

    private Pair<List<VVURL>, List<VoicevoxSpeaker>> checkAndGet() {
        List<Pair> urls = this.enginUrls.get().stream().map(VVURL::new).map(n -> Pair.of((Object)n, CompletableFuture.supplyAsync(() -> {
            try {
                return this.manager.requestSpeakers((VVURL)n);
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
        }, this.getAsyncExecutor()))).toList();
        ArrayList<VVURL> rurls = new ArrayList<VVURL>();
        List rspeakers = null;
        for (Pair ret : urls) {
            VVURL vu = (VVURL)ret.getLeft();
            CompletableFuture cf = (CompletableFuture)ret.getRight();
            try {
                List r = (List)cf.get();
                if (rspeakers == null) {
                    rspeakers = r;
                }
                rurls.add(vu);
                if (this.availableUrls != null && this.availableUrls.contains(vu)) continue;
                this.getITTSLogger().info("Available {} URL: {}", (Object)this.manager.getName(), (Object)vu.url());
            }
            catch (InterruptedException | ExecutionException e) {
                if (this.availableUrls != null && !this.availableUrls.contains(vu)) continue;
                this.getITTSLogger().warn("Unavailable {} URL: {}", (Object)this.manager.getName(), (Object)vu.url());
            }
        }
        return Pair.of(rurls, rspeakers);
    }

    public boolean isAvailable() {
        return this.enginUrls != null && !this.enginUrls.get().isEmpty();
    }

    protected VoicevoxUseURL getUseURL() {
        if (this.availableUrls == null || this.availableUrls.isEmpty()) {
            throw new RuntimeException("No URL available.");
        }
        final VVURL vvurl = this.availableUrls.stream().min(Comparator.comparingInt(r -> this.getUseCounter((VVURL)r).get())).get();
        this.getUseCounter(vvurl).incrementAndGet();
        return new VoicevoxUseURL(){

            @Override
            public VVURL getVVURL() {
                return vvurl;
            }

            @Override
            public void close() {
                VoicevoxBalancer.this.getUseCounter(vvurl).decrementAndGet();
            }
        };
    }
}

