/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.voice.voicevox;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.felnull.itts.core.config.voicetype.VoicevoxConfig;
import dev.felnull.itts.core.voice.VoiceType;
import dev.felnull.itts.core.voice.voicevox.VVURL;
import dev.felnull.itts.core.voice.voicevox.VoicevoxBalancer;
import dev.felnull.itts.core.voice.voicevox.VoicevoxSpeaker;
import dev.felnull.itts.core.voice.voicevox.VoicevoxUseURL;
import dev.felnull.itts.core.voice.voicevox.VoicevoxVoiceCategory;
import dev.felnull.itts.core.voice.voicevox.VoicevoxVoiceType;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public class VoicevoxManager {
    private static final Gson GSON = new Gson();
    private final VoicevoxVoiceCategory category = new VoicevoxVoiceCategory(this);
    private final VoicevoxBalancer balancer;
    private final String name;
    private final Supplier<VoicevoxConfig> configSupplier;

    public VoicevoxManager(String name, Supplier<List<String>> enginUrls, Supplier<VoicevoxConfig> configSupplier) {
        this.name = name;
        this.configSupplier = configSupplier;
        this.balancer = new VoicevoxBalancer(this, enginUrls);
    }

    protected VoicevoxConfig getConfig() {
        return this.configSupplier.get();
    }

    public CompletableFuture<?> init() {
        return this.balancer.init();
    }

    public VoicevoxVoiceCategory getCategory() {
        return this.category;
    }

    public String getName() {
        return this.name;
    }

    public boolean isAvailable() {
        return this.getConfig().isEnable() && this.balancer.isAvailable();
    }

    public List<VoiceType> getAvailableVoiceTypes() {
        return this.balancer.getAvailableSpeakers().stream().map(r -> new VoicevoxVoiceType((VoicevoxSpeaker)r, this)).toList();
    }

    protected VoicevoxBalancer getBalancer() {
        return this.balancer;
    }

    protected List<VoicevoxSpeaker> requestSpeakers(VVURL vvurl) throws IOException, InterruptedException {
        JsonArray ja;
        HttpClient hc = HttpClient.newHttpClient();
        HttpRequest req = HttpRequest.newBuilder(vvurl.createURI("speakers")).version(HttpClient.Version.HTTP_1_1).timeout(Duration.of(3000L, ChronoUnit.MILLIS)).build();
        HttpResponse<InputStream> rep = hc.send(req, HttpResponse.BodyHandlers.ofInputStream());
        try (BufferedInputStream stream = new BufferedInputStream(rep.body());
             InputStreamReader reader = new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8);){
            ja = (JsonArray)GSON.fromJson((Reader)reader, JsonArray.class);
        }
        ImmutableList.Builder speakerBuilder = new ImmutableList.Builder();
        for (JsonElement je : ja) {
            speakerBuilder.add((Object)VoicevoxSpeaker.of(je.getAsJsonObject()));
        }
        return speakerBuilder.build();
    }

    /*
     * Exception decompiling
     */
    private JsonObject getQuery(String text, int speakerId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected InputStream openVoiceStream(String text, int speakerId) throws IOException, InterruptedException {
        JsonObject qry = this.getQuery(text, speakerId);
        try (VoicevoxUseURL urlUse = this.balancer.getUseURL();){
            HttpClient hc = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder(urlUse.getVVURL().createURI(String.format("synthesis?speaker=%d", speakerId))).timeout(Duration.of(10L, ChronoUnit.SECONDS)).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(GSON.toJson((JsonElement)qry))).version(HttpClient.Version.HTTP_1_1).build();
            HttpResponse<InputStream> res = hc.send(request, HttpResponse.BodyHandlers.ofInputStream());
            Optional<String> content = res.headers().firstValue("content-type");
            int code = res.statusCode();
            if (content.isEmpty()) {
                throw new IOException("Content Type does not exist: " + code);
            }
            if (!content.get().startsWith("audio/")) throw new IOException("Not audio data: " + code);
            InputStream inputStream = res.body();
            return inputStream;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

