/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core;

import com.google.common.base.Suppliers;
import dev.felnull.itts.core.ITTSRuntime;
import java.net.http.HttpClient;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class ITTSNetworkManager {
    private final Supplier<HttpClient> httpClient = Suppliers.memoize(ITTSNetworkManager::createHttpClient);

    @NotNull
    private static HttpClient createHttpClient() {
        ITTSRuntime runtime = ITTSRuntime.getInstance();
        HttpClient.Builder builder = HttpClient.newBuilder().version(HttpClient.Version.HTTP_1_1).connectTimeout(Duration.of(3L, ChronoUnit.SECONDS)).executor(runtime.getHttpWorkerExecutor());
        return builder.build();
    }

    @NotNull
    public HttpClient getHttpClient() {
        return this.httpClient.get();
    }
}

