/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core;

import com.google.common.collect.ImmutableList;
import dev.felnull.itts.core.DirectoryLock;
import dev.felnull.itts.core.ITTSBaseManager;
import dev.felnull.itts.core.ITTSNetworkManager;
import dev.felnull.itts.core.ITTSRuntimeContext;
import dev.felnull.itts.core.ImmortalityTimer;
import dev.felnull.itts.core.audio.VoiceAudioManager;
import dev.felnull.itts.core.cache.CacheManager;
import dev.felnull.itts.core.config.ConfigManager;
import dev.felnull.itts.core.dict.DictionaryManager;
import dev.felnull.itts.core.discord.Bot;
import dev.felnull.itts.core.savedata.SaveDataManager;
import dev.felnull.itts.core.tts.TTSManager;
import dev.felnull.itts.core.voice.VoiceManager;
import java.util.List;
import java.util.Objects;
import java.util.Timer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ITTSRuntime {
    private static ITTSRuntime instance;
    private final Logger logger;
    private final ExecutorService asyncWorkerExecutor = Executors.newCachedThreadPool((ThreadFactory)new BasicThreadFactory.Builder().namingPattern("async-worker-%d").daemon(true).build());
    private final ExecutorService httpWorkerExecutor = Executors.newCachedThreadPool((ThreadFactory)new BasicThreadFactory.Builder().namingPattern("http-worker-%d").daemon(true).build());
    private final ExecutorService heavyWorkerExecutor = Executors.newFixedThreadPool(Math.max(Runtime.getRuntime().availableProcessors(), 1), (ThreadFactory)new BasicThreadFactory.Builder().namingPattern("heavy-worker-thread-%d").daemon(true).build());
    private final ImmortalityTimer immortalityTimer = new ImmortalityTimer(new Timer("immortality-timer", true));
    private final DirectoryLock directoryLock = new DirectoryLock();
    private final String version;
    private final boolean developmentEnvironment;
    private final ConfigManager configManager;
    private final TTSManager ttsManager = new TTSManager();
    private final VoiceManager voiceManager = new VoiceManager();
    private final VoiceAudioManager voiceAudioManager = new VoiceAudioManager();
    private final DictionaryManager dictionaryManager = new DictionaryManager();
    private final ITTSNetworkManager networkManager = new ITTSNetworkManager();
    private final CacheManager cacheManager;
    private final Bot bot;
    private final List<ITTSBaseManager> managers;
    private long startupTime;

    private ITTSRuntime(ITTSRuntimeContext runtimeContext) {
        if (instance != null) {
            throw new IllegalStateException("ITTSRuntime must be a singleton instance");
        }
        instance = this;
        this.directoryLock.lock();
        this.logger = runtimeContext.getLogContext().getLogger();
        String v = ITTSRuntime.class.getPackage().getImplementationVersion();
        this.developmentEnvironment = v == null;
        this.version = Objects.requireNonNullElse(v, "None");
        this.bot = new Bot();
        this.configManager = new ConfigManager(runtimeContext.getConfigContext());
        this.cacheManager = new CacheManager(runtimeContext.getGlobalCacheAccessFactory());
        this.managers = ImmutableList.of((Object)this.configManager, (Object)this.voiceManager);
    }

    public static ITTSRuntime getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Instance does not exist");
        }
        return instance;
    }

    public static ITTSRuntime newRuntime(@NotNull ITTSRuntimeContext runtimeContext) {
        return new ITTSRuntime(runtimeContext);
    }

    public void execute() {
        this.startupTime = System.currentTimeMillis();
        this.logger.info("The Ikisugi-TTS ({})", (Object)this.getVersionText());
        this.logger.info("--System info--");
        this.logger.info("Java runtime: {}", (Object)System.getProperty("java.runtime.name"));
        this.logger.info("Java version: {}", (Object)System.getProperty("java.version"));
        this.logger.info("Java vm name: {}", (Object)System.getProperty("java.vm.name"));
        this.logger.info("Java vm version: {}", (Object)System.getProperty("java.vm.version"));
        this.logger.info("OS: {}", (Object)System.getProperty("os.name"));
        this.logger.info("Arch: {}", (Object)System.getProperty("os.arch"));
        this.logger.info("Available Processors: {}", (Object)Runtime.getRuntime().availableProcessors());
        this.logger.info("---------------");
        this.logger.info("Start setup");
        this.managers.stream().map(ITTSBaseManager::init).forEach(CompletableFuture::join);
        SaveDataManager.getInstance().init();
        this.logger.info("Setup complete");
        this.bot.start();
    }

    public long getStartupTime() {
        return this.startupTime;
    }

    public Executor getAsyncWorkerExecutor() {
        return this.asyncWorkerExecutor;
    }

    public ExecutorService getHeavyWorkerExecutor() {
        return this.heavyWorkerExecutor;
    }

    public ExecutorService getHttpWorkerExecutor() {
        return this.httpWorkerExecutor;
    }

    public ImmortalityTimer getImmortalityTimer() {
        return this.immortalityTimer;
    }

    public boolean isDevelopmentEnvironment() {
        return this.developmentEnvironment;
    }

    public String getVersion() {
        return this.version;
    }

    public String getVersionText() {
        return this.isDevelopmentEnvironment() ? "\u958b\u767a\u74b0\u5883" : "v" + this.getVersion();
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public TTSManager getTTSManager() {
        return this.ttsManager;
    }

    public VoiceAudioManager getVoiceAudioManager() {
        return this.voiceAudioManager;
    }

    public VoiceManager getVoiceManager() {
        return this.voiceManager;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public DictionaryManager getDictionaryManager() {
        return this.dictionaryManager;
    }

    public ITTSNetworkManager getNetworkManager() {
        return this.networkManager;
    }

    public Bot getBot() {
        return this.bot;
    }
}

