/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.cache;

import com.google.common.hash.HashCode;
import dev.felnull.fnjl.util.FNDataUtil;
import dev.felnull.itts.core.ITTSRuntimeUse;
import dev.felnull.itts.core.cache.CacheUseEntry;
import dev.felnull.itts.core.cache.GlobalCacheAccess;
import dev.felnull.itts.core.cache.LocalCache;
import dev.felnull.itts.core.cache.StreamOpener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CacheManager
implements ITTSRuntimeUse {
    private static final File LOCAL_CACHE_FOLDER = new File("./tmp");
    private final Map<HashCode, CompletableFuture<LocalCache>> localCaches = new ConcurrentHashMap<HashCode, CompletableFuture<LocalCache>>();
    private final Supplier<GlobalCacheAccess> globalCacheAccessFactory;

    public CacheManager(@Nullable Supplier<GlobalCacheAccess> globalCacheAccessFactory) {
        try {
            FileUtils.deleteDirectory((File)LOCAL_CACHE_FOLDER);
            FNDataUtil.wishMkdir((File)LOCAL_CACHE_FOLDER);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.globalCacheAccessFactory = globalCacheAccessFactory;
    }

    public CompletableFuture<CacheUseEntry> loadOrRestore(@NotNull HashCode key, @NotNull StreamOpener loadOpener) {
        return this.localCaches.computeIfAbsent(key, ky -> this.createLocalCache((HashCode)ky, loadOpener)).thenApplyAsync(LocalCache::restore, this.getAsyncExecutor());
    }

    private CompletableFuture<LocalCache> createLocalCache(HashCode key, StreamOpener loadOpener) {
        File lcFile = this.getLocalCacheFile(key);
        CompletableFuture<File> cf = this.globalCacheAccessFactory != null ? CompletableFuture.supplyAsync(() -> {
            File file;
            block16: {
                GlobalCacheAccess gca = this.globalCacheAccessFactory.get();
                try {
                    byte[] data = gca.get(key);
                    if (data == null) {
                        gca.lock(key);
                        data = gca.get(key);
                        if (data == null) {
                            try (BufferedInputStream in = new BufferedInputStream(loadOpener.openStream());){
                                data = in.readAllBytes();
                            }
                            gca.set(key, data);
                        }
                        gca.unlock(key);
                    }
                    Files.write(lcFile.toPath(), data, new OpenOption[0]);
                    file = lcFile;
                    if (gca == null) break block16;
                }
                catch (Throwable throwable) {
                    try {
                        if (gca != null) {
                            try {
                                gca.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
                gca.close();
            }
            return file;
        }, this.getAsyncExecutor()) : CompletableFuture.supplyAsync(() -> {
            try (InputStream in = loadOpener.openStream();
                 FileOutputStream out = new FileOutputStream(lcFile);){
                FNDataUtil.inputToOutputBuff((InputStream)in, (OutputStream)out);
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException(e);
            }
            return lcFile;
        }, this.getAsyncExecutor());
        return cf.thenApplyAsync(file -> new LocalCache(key, (File)file), this.getAsyncExecutor());
    }

    private File getLocalCacheFile(HashCode hashCode) {
        return new File(LOCAL_CACHE_FOLDER, hashCode.toString());
    }

    protected void disposeCache(HashCode hashCode) {
        CompletableFuture<LocalCache> lc = this.localCaches.remove(hashCode);
        if (lc != null) {
            lc.thenAcceptAsync(LocalCache::dispose, this.getAsyncExecutor());
        }
    }
}

