/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.cache;

import com.google.common.hash.HashCode;
import dev.felnull.itts.core.ITTSRuntimeUse;
import dev.felnull.itts.core.ImmortalityTimer;
import dev.felnull.itts.core.cache.CacheUseEntry;
import dev.felnull.itts.core.cache.UseLock;
import java.io.File;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class LocalCache
implements ITTSRuntimeUse {
    private final AtomicLong lastUseTime = new AtomicLong(System.currentTimeMillis());
    private final AtomicInteger useLockCount = new AtomicInteger();
    private final AtomicBoolean runningTimer = new AtomicBoolean();
    private final AtomicBoolean destroy = new AtomicBoolean();
    private final HashCode hashCode;
    private final File file;

    public LocalCache(HashCode hashCode, File file) {
        this.hashCode = hashCode;
        this.file = file;
    }

    public CacheUseEntry restore() {
        if (this.isDestroy()) {
            throw new IllegalStateException("Already destroyed");
        }
        this.useLockCount.incrementAndGet();
        AtomicBoolean unlocked = new AtomicBoolean();
        UseLock ul = () -> {
            if (!unlocked.compareAndSet(false, true)) {
                return;
            }
            if (this.useLockCount.decrementAndGet() <= 0) {
                this.lastUseTime.set(System.currentTimeMillis());
                this.scheduleCheckTimer(this::check, this.getCacheTime() + 300L);
            }
        };
        return new CacheUseEntry(this.file, ul);
    }

    protected void dispose() {
        this.destroy.set(true);
        if (this.file.exists() && this.file.delete()) {
            throw new RuntimeException("Failed to delete file");
        }
    }

    public boolean isDestroy() {
        return this.destroy.get();
    }

    private void check() {
        long lastTime;
        if (this.isDestroy()) {
            return;
        }
        if (this.useLockCount.get() > 0) {
            return;
        }
        long now = System.currentTimeMillis();
        long eqTime = now - (lastTime = this.lastUseTime.get());
        if (eqTime >= this.getCacheTime()) {
            this.getCacheManager().disposeCache(this.hashCode);
            return;
        }
        this.scheduleCheckTimer(this::check, this.getCacheTime() - eqTime + 300L);
    }

    private long getCacheTime() {
        return this.getConfigManager().getConfig().getCacheTime();
    }

    private void scheduleCheckTimer(final Runnable runnable, long delay) {
        if (!this.runningTimer.compareAndSet(false, true)) {
            return;
        }
        this.getImmortalityTimer().schedule(new ImmortalityTimer.ImmortalityTimerTask(){

            @Override
            public void run() {
                LocalCache.this.runningTimer.set(false);
                CompletableFuture.runAsync(runnable, LocalCache.this.getAsyncExecutor());
            }
        }, delay);
    }
}

