/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.config;

import dev.felnull.itts.core.ITTSBaseManager;
import dev.felnull.itts.core.config.Config;
import dev.felnull.itts.core.config.ConfigContext;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.NotNull;

public class ConfigManager
implements ITTSBaseManager {
    private final ConfigContext configAccess;
    private Config config;

    public ConfigManager(ConfigContext configContext) {
        this.configAccess = configContext;
    }

    @Override
    @NotNull
    public CompletableFuture<?> init() {
        return CompletableFuture.supplyAsync(this.configAccess::loadConfig, this.getAsyncExecutor()).thenAcceptAsync(cfg -> {
            this.config = cfg;
            if (this.config == null) {
                throw new RuntimeException("config access does not exist");
            }
            if (this.config.getBotToken().isEmpty()) {
                throw new RuntimeException("Bot token is empty/Bot\u30c8\u30fc\u30af\u30f3\u304c\u7a7a\u3067\u3059");
            }
            this.getITTSLogger().info("Configuration setup completed");
        }, this.getAsyncExecutor());
    }

    public Config getConfig() {
        return this.config;
    }
}

