/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.config;

import dev.felnull.itts.core.util.NameSerializableEnum;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public interface DataBaseConfig {
    public static final DataBaseType DEFAULT_TYPE = DataBaseType.SQLITE;
    public static final String DEFAULT_HOST = "";
    public static final int DEFAULT_PORT = 0;
    public static final String DEFAULT_DATABASE_NAME = "";
    public static final String DEFAULT_USER = "";
    public static final String DEFAULT_PASSWORD = "";

    @NotNull
    public DataBaseType getType();

    @NotNull
    public String getHost();

    public @Range(from=0L, to=65535L) int getPort();

    @NotNull
    public String getDatabaseName();

    @NotNull
    public String getUser();

    @NotNull
    public String getPassword();

    public static enum DataBaseType implements NameSerializableEnum
    {
        SQLITE("sqlite"),
        MYSQL("mysql");

        private final String name;

        private DataBaseType(String name) {
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

