/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.dict;

import com.google.common.collect.ImmutableMap;
import dev.felnull.itts.core.dict.Dictionary;
import dev.felnull.itts.core.dict.RegexUtil;
import dev.felnull.itts.core.dict.URLReplacer;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class AbbreviationDictionary
implements Dictionary {
    private static final Pattern CODE_BLOCK_REGEX = Pattern.compile("```(.|\n)*```");
    private final RegexUtil regexUtil = new RegexUtil().addOption(1, "\u30c9\u30e1\u30a4\u30f3\u30b7\u30e7\u30a6\u30ea\u30e3\u30af", s -> {
        Pattern pattern = Pattern.compile("^([a-zA-Z0-9][a-zA-Z0-9-]*[a-zA-Z0-9]*\\.)+[a-zA-Z]{2,}$");
        Matcher matcher = pattern.matcher((CharSequence)s);
        return matcher.find();
    }).addOption(1, "\u30a2\u30a4\u30d4\u30fc\u30d6\u30a4\u30d5\u30a9\u30fc\u30b7\u30e7\u30a6\u30ea\u30e3\u30af", s -> {
        Pattern pattern = Pattern.compile("^((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])\\.){3}(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])$");
        Matcher matcher = pattern.matcher((CharSequence)s);
        return matcher.matches();
    }).addOption(1, "\u30a2\u30a4\u30d4\u30fc\u30d6\u30a4\u30ed\u30af\u30b7\u30e7\u30a6\u30ea\u30e3\u30af", s -> {
        Pattern pattern = Pattern.compile("(([0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,7}:|([0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|([0-9a-fA-F]{1,4}:){1,5}(:[0-9a-fA-F]{1,4}){1,2}|([0-9a-fA-F]{1,4}:){1,4}(:[0-9a-fA-F]{1,4}){1,3}|([0-9a-fA-F]{1,4}:){1,3}(:[0-9a-fA-F]{1,4}){1,4}|([0-9a-fA-F]{1,4}:){1,2}(:[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:((:[0-9a-fA-F]{1,4}){1,6})|:((:[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(:[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]+|::(ffff(:0{1,4})?:)?((25[0-5]|(2[0-4]|1?[0-9])?[0-9])\\.){3}(25[0-5]|(2[0-4]|1?[0-9])?[0-9])|([0-9a-fA-F]{1,4}:){1,4}:((25[0-5]|(2[0-4]|1?[0-9])?[0-9])\\.){3}(25[0-5]|(2[0-4]|1?[0-9])?[0-9]))");
        Matcher matcher = pattern.matcher((CharSequence)s);
        return matcher.matches();
    });
    private final URLReplacer urlReplacer = new URLReplacer("\u30e6\u30fc\u30a2\u30eb\u30a8\u30eb\u30b7\u30e7\u30a6\u30ea\u30e3\u30af");

    @Override
    @NotNull
    public String apply(@NotNull String text, long guildId) {
        text = this.urlReplacer.replace(text);
        text = CODE_BLOCK_REGEX.matcher(text).replaceAll("\u30b3\u30fc\u30c9\u30d6\u30ed\u30c3\u30af\u30b7\u30e7\u30a6\u30ea\u30e3\u30af");
        return this.regexUtil.replaceText(text);
    }

    @Override
    public boolean isBuiltIn() {
        return true;
    }

    @Override
    @NotNull
    public String getName() {
        return "\u7701\u7565\u8f9e\u66f8";
    }

    @Override
    @NotNull
    public String getId() {
        return "abbreviation";
    }

    @Override
    @NotNull
    public @Unmodifiable Map<String, String> getShowInfo(long guildId) {
        return ImmutableMap.of((Object)"https://...", (Object)"URL\u7701\u7565", (Object)"``` \u30b3\u30fc\u30c9\u30d6\u30ed\u30c3\u30af ```", (Object)"\u30b3\u30fc\u30c9\u30d6\u30ed\u30c3\u30af\u7701\u7565");
    }

    @Override
    public int getDefaultPriority() {
        return 1;
    }
}

