/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.dict;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.felnull.itts.core.ITTSRuntimeUse;
import dev.felnull.itts.core.dict.AbbreviationDictionary;
import dev.felnull.itts.core.dict.Dictionary;
import dev.felnull.itts.core.dict.DictionaryUseEntry;
import dev.felnull.itts.core.dict.GlobalDictionary;
import dev.felnull.itts.core.dict.RomajiDictionary;
import dev.felnull.itts.core.dict.ServerDictionary;
import dev.felnull.itts.core.dict.UnitDictionary;
import dev.felnull.itts.core.savedata.SaveDataManager;
import dev.felnull.itts.core.savedata.legacy.LegacyDictData;
import dev.felnull.itts.core.savedata.legacy.LegacySaveDataLayer;
import dev.felnull.itts.core.util.JsonUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class DictionaryManager
implements ITTSRuntimeUse {
    private static final int FILE_VERSION = 0;
    private final Dictionary globalDictionary = new GlobalDictionary();
    private final Dictionary serverDictionary = new ServerDictionary();
    private final Dictionary abbreviationDictionary = new AbbreviationDictionary();
    private final Dictionary unitDictionary = new UnitDictionary();
    private final Dictionary romajiDictionary = new RomajiDictionary();
    private final List<Dictionary> dictionaries = ImmutableList.of((Object)this.globalDictionary, (Object)this.serverDictionary, (Object)this.abbreviationDictionary, (Object)this.unitDictionary, (Object)this.romajiDictionary);
    private final List<Dictionary> defaultEnableDictionaries = ImmutableList.of((Object)this.globalDictionary, (Object)this.serverDictionary, (Object)this.abbreviationDictionary, (Object)this.romajiDictionary);

    @Nullable
    public Dictionary getDictionary(@NotNull String id, long guildId) {
        return this.dictionaries.stream().filter(r -> id.equals(r.getId())).findAny().orElse(null);
    }

    public @Unmodifiable @NotNull List<Dictionary> getAllDictionaries(long guildId) {
        return this.dictionaries;
    }

    public List<Dictionary> getAllPriorityOrderEnableDictionaries(long guildId) {
        SaveDataManager saveDataManager = SaveDataManager.getInstance();
        List<DictionaryUseEntry> savedDictionaryUseEntries = saveDataManager.getRepository().getAllDictionaryUseData(guildId);
        Map<String, Integer> savedEnableDictAndPriority = savedDictionaryUseEntries.stream().filter(it -> Boolean.TRUE.equals(it.enable())).collect(Collectors.toMap(DictionaryUseEntry::dictionaryId, it -> {
            Dictionary dict;
            int priority = it.priority() != null ? it.priority() : ((dict = this.getDictionary(it.dictionaryId(), guildId)) != null ? dict.getDefaultPriority() : 0);
            return priority;
        }));
        Map<String, Integer> savedDefaultEnableDictAndPriority = savedDictionaryUseEntries.stream().filter(it -> {
            if (it.enable() == null) {
                return this.defaultEnableDictionaries.contains(this.getDictionary(it.dictionaryId(), guildId));
            }
            return false;
        }).collect(Collectors.toMap(DictionaryUseEntry::dictionaryId, it -> {
            Dictionary dict;
            int priority = it.priority() != null ? it.priority() : ((dict = this.getDictionary(it.dictionaryId(), guildId)) != null ? dict.getDefaultPriority() : 0);
            return priority;
        }));
        Map<String, Integer> defaultEnableDictAndPriority = this.defaultEnableDictionaries.stream().filter(it -> savedDictionaryUseEntries.stream().noneMatch(data -> data.dictionaryId().equals(it.getId()))).collect(Collectors.toMap(Dictionary::getId, Dictionary::getDefaultPriority));
        HashMap retDictAndPriority = new HashMap();
        savedEnableDictAndPriority.forEach((dictId, priority) -> {
            Dictionary dictionary = this.getDictionary((String)dictId, guildId);
            if (dictionary != null) {
                retDictAndPriority.put(dictionary, priority);
            }
        });
        savedDefaultEnableDictAndPriority.forEach((dictId, priority) -> {
            Dictionary dictionary = this.getDictionary((String)dictId, guildId);
            if (dictionary != null) {
                retDictAndPriority.put(dictionary, priority);
            }
        });
        defaultEnableDictAndPriority.forEach((dictId, priority) -> {
            Dictionary dictionary = this.getDictionary((String)dictId, guildId);
            if (dictionary != null) {
                retDictAndPriority.put(dictionary, priority);
            }
        });
        return retDictAndPriority.entrySet().stream().sorted(Comparator.comparingInt(Map.Entry::getValue)).map(Map.Entry::getKey).toList();
    }

    public boolean isEnable(long guildId, String dictId) {
        SaveDataManager saveDataManager = SaveDataManager.getInstance();
        Boolean savedEnable = saveDataManager.getRepository().getDictionaryUseData(guildId, dictId).isEnable();
        if (savedEnable != null) {
            return savedEnable;
        }
        Dictionary dict = this.getDictionary(dictId, guildId);
        return this.defaultEnableDictionaries.contains(dict);
    }

    public void setEnable(long guildId, String dictId, boolean enable) {
        SaveDataManager saveDataManager = SaveDataManager.getInstance();
        saveDataManager.getRepository().getDictionaryUseData(guildId, dictId).setEnable(enable);
    }

    public String applyDict(String text, long guildId) {
        AtomicReference<String> retText = new AtomicReference<String>(text);
        this.getAllPriorityOrderEnableDictionaries(guildId).forEach(dict -> retText.set(dict.apply((String)retText.get(), guildId)));
        return retText.get();
    }

    public void serverDictSaveToJson(@NotNull JsonObject jo, long guildId) {
        LegacySaveDataLayer legacySaveDataLayer = SaveDataManager.getInstance().getLegacySaveDataLayer();
        jo.addProperty("version", (Number)0);
        JsonObject entry = new JsonObject();
        List<LegacyDictData> allDict = legacySaveDataLayer.getAllServerDictData(guildId);
        for (LegacyDictData dictData : allDict) {
            entry.addProperty(dictData.getTarget(), dictData.getRead());
        }
        jo.add("entry", (JsonElement)entry);
    }

    public List<LegacyDictData> serverDictLoadFromJson(@NotNull JsonObject jo, long guildId, boolean overwrite) {
        ArrayList<LegacyDictData> ret = new ArrayList<LegacyDictData>();
        int version = JsonUtils.getInt(jo, "version", -1);
        if (version != 0) {
            throw new RuntimeException("Unsupported dictionary file version.");
        }
        if (jo.get("entry").isJsonObject()) {
            JsonObject entry = jo.getAsJsonObject("entry");
            LegacySaveDataLayer legacySaveDataLayer = SaveDataManager.getInstance().getLegacySaveDataLayer();
            for (Map.Entry en : entry.entrySet()) {
                String target = (String)en.getKey();
                if (!((JsonElement)en.getValue()).isJsonPrimitive() || !((JsonElement)en.getValue()).getAsJsonPrimitive().isString()) continue;
                String read = ((JsonElement)en.getValue()).getAsString();
                LegacyDictData pre = legacySaveDataLayer.getServerDictData(guildId, target);
                if (!overwrite && pre != null) continue;
                legacySaveDataLayer.addServerDictData(guildId, target, read);
                LegacyDictData ndata = Objects.requireNonNull(legacySaveDataLayer.getServerDictData(guildId, target));
                if (ndata.equals(pre)) continue;
                ret.add(ndata);
            }
        }
        return ret;
    }
}

