/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.dict;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;

public class RegexUtil {
    private final List<RegexOption> optionList = new ArrayList<RegexOption>();

    private List<String> splitJapaneseEnglish(String text) {
        String[] dividedText = text.split("");
        ArrayList<String> createdText = new ArrayList<String>();
        StringBuilder tmpText = new StringBuilder();
        boolean en = false;
        for (String txt : dividedText) {
            if (txt.matches("[A-Za-z0-9:/#$%&.,-?_]+")) {
                if (!en) {
                    createdText.add(tmpText.toString());
                    tmpText.setLength(0);
                }
                en = true;
                tmpText.append(txt);
                continue;
            }
            if (en) {
                createdText.add(tmpText.toString());
                tmpText.setLength(0);
                en = false;
            }
            tmpText.append(txt);
        }
        if (!tmpText.isEmpty()) {
            createdText.add(tmpText.toString());
        }
        return createdText;
    }

    public RegexUtil addOption(int priority, String replacedText, Function<String, Boolean> testFunction) {
        this.optionList.add(new RegexOption(priority, replacedText, testFunction));
        return this;
    }

    public String replaceText(String text) {
        List<String> texts = this.splitJapaneseEnglish(text);
        ArrayList<String> createdText = new ArrayList<String>();
        block0: for (String txt : texts) {
            for (RegexOption ops : this.optionList.stream().sorted(Comparator.comparingInt(o -> o.priority)).toList()) {
                if (!ops.testFunction.apply(txt).booleanValue()) continue;
                createdText.add(ops.replacedText);
                continue block0;
            }
            createdText.add(txt);
        }
        return String.join((CharSequence)"", createdText);
    }

    public static class RegexOption {
        public int priority;
        public Function<String, Boolean> testFunction;
        public String replacedText;

        public RegexOption(int priority, String replacedText, Function<String, Boolean> testFunction) {
            this.priority = priority;
            this.replacedText = replacedText;
            this.testFunction = testFunction;
        }
    }
}

