/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.dict;

import com.google.common.collect.ImmutableMap;
import com.ibm.icu.text.Transliterator;
import dev.felnull.itts.core.dict.Dictionary;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class RomajiDictionary
implements Dictionary {
    @Override
    @NotNull
    public String apply(@NotNull String text, long guildId) {
        Transliterator transliterator = Transliterator.getInstance((String)"Latin-Hiragana");
        return transliterator.transliterate(text);
    }

    @Override
    public boolean isBuiltIn() {
        return true;
    }

    @Override
    @NotNull
    public String getName() {
        return "\u30ed\u30fc\u30de\u5b57\u8aad\u307f\u8f9e\u66f8";
    }

    @Override
    @NotNull
    public String getId() {
        return "romaji";
    }

    @Override
    @NotNull
    public @Unmodifiable Map<String, String> getShowInfo(long guildId) {
        return ImmutableMap.of((Object)"\u30ed\u30fc\u30de\u5b57\u3092\u5e73\u4eee\u540d\u3078\u5909\u63db", (Object)"Katyou -> \u304b\u3061\u3087\u3046");
    }

    @Override
    public int getDefaultPriority() {
        return 4;
    }
}

