/*
 * Decompiled with CFR 0.152.
 */
package dev.felnull.itts.core.dict;

import dev.felnull.itts.core.ITTSRuntimeUse;
import dev.felnull.itts.core.dict.RegexReplaceBaseDictionary;
import dev.felnull.itts.core.savedata.SaveDataManager;
import dev.felnull.itts.core.savedata.legacy.LegacyDictData;
import dev.felnull.itts.core.savedata.legacy.LegacySaveDataLayer;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public class ServerDictionary
extends RegexReplaceBaseDictionary
implements ITTSRuntimeUse {
    @Override
    public boolean isBuiltIn() {
        return false;
    }

    @Override
    @NotNull
    public String getName() {
        return "\u30b5\u30fc\u30d0\u30fc\u8f9e\u66f8";
    }

    @Override
    @NotNull
    public String getId() {
        return "server";
    }

    @Override
    @NotNull
    public @Unmodifiable Map<String, String> getShowInfo(long guildId) {
        LegacySaveDataLayer legacySaveDataLayer = SaveDataManager.getInstance().getLegacySaveDataLayer();
        return legacySaveDataLayer.getAllServerDictData(guildId).stream().collect(Collectors.toMap(LegacyDictData::getTarget, LegacyDictData::getRead));
    }

    @Override
    public int getDefaultPriority() {
        return 2;
    }

    @Override
    @NotNull
    protected Map<Pattern, Function<String, String>> getReplaces(long guildId) {
        LegacySaveDataLayer legacySaveDataLayer = SaveDataManager.getInstance().getLegacySaveDataLayer();
        return legacySaveDataLayer.getAllServerDictData(guildId).stream().map(n -> Pair.of((Object)Pattern.compile(n.getTarget()), (Object)n.getRead())).collect(Collectors.toMap(Pair::getLeft, patternStringPair -> n -> (String)patternStringPair.getRight()));
    }
}

